/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent.loader;

import es.bsc.compss.api.COMPSsRuntime;
import es.bsc.compss.loader.LoaderAPI;
import es.bsc.compss.loader.LoaderConstants;
import es.bsc.compss.loader.LoaderUtils;
import es.bsc.compss.loader.total.ITAppEditor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CodeConverter;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;

public class Loader {
    public static void load(COMPSsRuntime runtime, LoaderAPI api, String ceiClass, long appId, String className, String methodName, Object ... params) throws MalformedURLException {
        try {
            String compssHome = System.getenv("COMPSS_HOME");
            URLClassLoader myLoader = new URLClassLoader(new URL[]{new URL("file:" + compssHome + LoaderConstants.ENGINE_JAR_WITH_REL_PATH)});
            Thread.currentThread().setContextClassLoader(myLoader);
            ClassPool classPool = Loader.getClassPool();
            CtClass appClass = classPool.get(className);
            appClass.defrost();
            String varName = LoaderUtils.randomName((int)5, (String)"compss");
            String itApiVar = varName + "Api";
            String itSRVar = varName + "SR";
            String itORVar = varName + "OR";
            String itAppIdVar = varName + "AppId";
            Loader.addVariables(classPool, appClass, itApiVar, itSRVar, itORVar, itAppIdVar);
            Loader.instrumentClass(classPool, appClass, ceiClass, itApiVar, itSRVar, itORVar, itAppIdVar);
            Loader.addModifyVariablesMethod(appClass, itApiVar, itSRVar, itORVar, itAppIdVar);
            Class app = appClass.toClass();
            appClass.defrost();
            Method setter = app.getDeclaredMethod("setCOMPSsVariables", Class.forName(LoaderConstants.CLASS_COMPSSRUNTIME_API), Class.forName(LoaderConstants.CLASS_LOADERAPI), Class.forName(LoaderConstants.CLASS_APP_ID));
            Object[] values = new Object[]{runtime, api, appId};
            setter.invoke(null, values);
            Class[] types = new Class[params.length];
            for (int i = 0; i < params.length; ++i) {
                types[i] = params[i].getClass();
            }
            Method main = Loader.findMethod(app, methodName, params.length, types, params);
            main.invoke(null, params);
            runtime.noMoreTasks(Long.valueOf(appId));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static void addVariables(ClassPool cp, CtClass appClass, String itApiVar, String itSRVar, String itORVar, String itAppIdVar) throws NotFoundException, CannotCompileException {
        CtClass itApiClass = cp.get(LoaderConstants.CLASS_COMPSSRUNTIME_API);
        CtField itApiField = new CtField(itApiClass, itApiVar, appClass);
        itApiField.setModifiers(10);
        appClass.addField(itApiField);
        CtClass itSRClass = cp.get(LoaderConstants.CLASS_STREAM_REGISTRY);
        CtField itSRField = new CtField(itSRClass, itSRVar, appClass);
        itSRField.setModifiers(10);
        appClass.addField(itSRField);
        CtClass itORClass = cp.get(LoaderConstants.CLASS_OBJECT_REGISTRY);
        CtField itORField = new CtField(itORClass, itORVar, appClass);
        itORField.setModifiers(10);
        appClass.addField(itORField);
        CtClass appIdClass = cp.get(LoaderConstants.CLASS_APP_ID);
        CtField appIdField = new CtField(appIdClass, itAppIdVar, appClass);
        appIdField.setModifiers(10);
        appClass.addField(appIdField);
    }

    private static void instrumentClass(ClassPool cp, CtClass appClass, String ceiClass, String itApiVar, String itSRVar, String itORVar, String itAppIdVar) throws ClassNotFoundException, NotFoundException, CannotCompileException {
        Class<?> annotItf = Class.forName(ceiClass);
        Method[] remoteMethods = annotItf.getMethods();
        CtMethod[] instrCandidates = appClass.getDeclaredMethods();
        ITAppEditor itAppEditor = new ITAppEditor(remoteMethods, instrCandidates, itApiVar, itSRVar, itORVar, itAppIdVar, appClass);
        CodeConverter converter = new CodeConverter();
        CtClass arrayWatcher = cp.get(LoaderConstants.CLASS_ARRAY_ACCESS_WATCHER);
        CodeConverter.DefaultArrayAccessReplacementMethodNames names = new CodeConverter.DefaultArrayAccessReplacementMethodNames();
        converter.replaceArrayAccess(arrayWatcher, (CodeConverter.ArrayAccessReplacementMethodNames)names);
        for (CtMethod ctMethod : instrCandidates) {
            ctMethod.instrument(converter);
            ctMethod.instrument((ExprEditor)itAppEditor);
        }
        for (CtMethod ctMethod : appClass.getDeclaredConstructors()) {
            ctMethod.instrument(converter);
            ctMethod.instrument((ExprEditor)itAppEditor);
        }
    }

    private static void addModifyVariablesMethod(CtClass appClass, String itApiVar, String itSRVar, String itORVar, String itAppIdVar) throws CannotCompileException, NotFoundException {
        String methodBody = "public static void printCOMPSsVariables() { System.out.println(\"Api Var: \" + " + itApiVar + ");" + "System.out.println(\"SR Var: \" + " + itSRVar + ");" + "System.out.println(\"OR Var: \" + " + itORVar + ");" + "System.out.println(\"App Id: \" + " + itAppIdVar + ");" + "}";
        CtMethod m = CtNewMethod.make((String)methodBody, (CtClass)appClass);
        appClass.addMethod(m);
        methodBody = "public static void setCOMPSsVariables( " + LoaderConstants.CLASS_COMPSSRUNTIME_API + " runtime" + ", " + LoaderConstants.CLASS_LOADERAPI + " loader" + ", " + LoaderConstants.CLASS_APP_ID + " appId" + ") { \n" + itApiVar + "= runtime; \n" + itSRVar + "= loader.getStreamRegistry(); \n" + itORVar + "= loader.getObjectRegistry(); \n" + itAppIdVar + "= appId; \n" + "}";
        m = CtNewMethod.make((String)methodBody, (CtClass)appClass);
        appClass.addMethod(m);
    }

    private static ClassPool getClassPool() {
        ClassPool cp = new ClassPool();
        cp.appendSystemPath();
        cp.importPackage("es.bsc.compss");
        cp.importPackage("es.bsc.compss.api");
        cp.importPackage("es.bsc.compss.api.impl");
        cp.importPackage("es.bsc.compss.loader");
        cp.importPackage("es.bsc.compss.loader.total");
        return cp;
    }

    private static Method findMethod(Class<?> methodClass, String methodName, int numParams, Class<?>[] types, Object[] values) {
        Method method = null;
        try {
            method = methodClass.getMethod(methodName, types);
        }
        catch (NoSuchMethodException | SecurityException e) {
            for (Method m : methodClass.getDeclaredMethods()) {
                if (!m.getName().equals(methodName) || numParams != m.getParameterCount()) continue;
                int paramId = 0;
                boolean isMatch = true;
                for (Parameter p : m.getParameters()) {
                    if (p.getType().isPrimitive()) {
                        if (p.getType() != values[paramId].getClass()) {
                            switch (p.getType().getCanonicalName()) {
                                case "byte": {
                                    isMatch = values[paramId].getClass().getCanonicalName().equals("java.lang.Byte");
                                    break;
                                }
                                case "char": {
                                    isMatch = values[paramId].getClass().getCanonicalName().equals("java.lang.Char");
                                    break;
                                }
                                case "short": {
                                    isMatch = values[paramId].getClass().getCanonicalName().equals("java.lang.Short");
                                    break;
                                }
                                case "int": {
                                    isMatch = values[paramId].getClass().getCanonicalName().equals("java.lang.Integer");
                                    break;
                                }
                                case "long": {
                                    isMatch = values[paramId].getClass().getCanonicalName().equals("java.lang.Long");
                                    break;
                                }
                                case "float": {
                                    isMatch = values[paramId].getClass().getCanonicalName().equals("java.lang.Float");
                                    break;
                                }
                                case "double": {
                                    isMatch = values[paramId].getClass().getCanonicalName().equals("java.lang.Double");
                                    break;
                                }
                                case "boolean": {
                                    isMatch = values[paramId].getClass().getCanonicalName().equals("java.lang.Boolean");
                                }
                            }
                        }
                    } else {
                        try {
                            p.getType().cast(values[paramId]);
                        }
                        catch (ClassCastException cce) {
                            isMatch = false;
                            break;
                        }
                    }
                    ++paramId;
                }
                if (!isMatch) continue;
                method = m;
            }
        }
        return method;
    }

    private static void printVariables(Class<?> app) throws Exception {
        Method setter = app.getDeclaredMethod("printCOMPSsVariables", new Class[0]);
        Object[] values = new Object[]{};
        setter.invoke(null, values);
    }
}

