/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.agent.AgentException;
import es.bsc.compss.agent.AgentInterface;
import es.bsc.compss.agent.AgentInterfaceConfig;
import es.bsc.compss.agent.AppMonitor;
import es.bsc.compss.agent.LoaderMonitor;
import es.bsc.compss.agent.loader.Loader;
import es.bsc.compss.agent.types.ApplicationParameter;
import es.bsc.compss.agent.types.RemoteDataInformation;
import es.bsc.compss.agent.types.RemoteDataLocation;
import es.bsc.compss.agent.types.Resource;
import es.bsc.compss.api.TaskMonitor;
import es.bsc.compss.api.impl.COMPSsRuntimeImpl;
import es.bsc.compss.comm.Comm;
import es.bsc.compss.exceptions.ConstructConfigurationException;
import es.bsc.compss.loader.LoaderAPI;
import es.bsc.compss.loader.total.ObjectRegistry;
import es.bsc.compss.loader.total.StreamRegistry;
import es.bsc.compss.types.COMPSsNode;
import es.bsc.compss.types.CommException;
import es.bsc.compss.types.CoreElementDefinition;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.annotations.parameter.OnFailure;
import es.bsc.compss.types.annotations.parameter.StdIOStream;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.implementations.definition.ImplementationDefinition;
import es.bsc.compss.types.resources.DynamicMethodWorker;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.configuration.MethodConfiguration;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.ResourceManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import storage.StorageException;
import storage.StorageItf;

public class Agent {
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Agent");
    private static final String LOADER_CLASS_NAME = Loader.class.getCanonicalName();
    private static final String LOADER_METHOD_NAME = "load";
    private static final String LOADER_PARAMS = "(OBJECT_T,OBJECT_T,STRING_T,LONG_T,STRING_T,STRING_T,INT_T,OBJECT_T)";
    private static final String LOADER_SIGNATURE = "load(OBJECT_T,OBJECT_T,STRING_T,LONG_T,STRING_T,STRING_T,INT_T,OBJECT_T)";
    private static final String AGENT_NAME;
    private static final COMPSsRuntimeImpl RUNTIME;
    private static final Random APP_ID_GENERATOR;
    private static final List<AgentInterface<?>> INTERFACES;
    private static final int PARAM_LENGTH = 9;
    private static final int LOAD_PARAMS_COUNT = 7;

    public static void start() {
        RUNTIME.startIT();
        LogicalData ld = Comm.registerData((String)"runtime");
        ld.setValue((Object)RUNTIME);
        String targetPath = ProtocolType.OBJECT_URI.getSchema() + "runtime";
        SimpleURI uri = new SimpleURI(targetPath);
        try {
            DataLocation loc = DataLocation.createLocation((es.bsc.compss.types.resources.Resource)Comm.getAppHost(), (SimpleURI)uri);
            ld.addLocation(loc);
        }
        catch (Exception e) {
            ErrorManager.fatal((String)"Could not create the location for the runtime object.", (Exception)e);
        }
        RUNTIME.registerData(null, DataType.OBJECT_T, (Object)RUNTIME, "runtime");
        CoreElementDefinition ced = new CoreElementDefinition();
        ced.setCeSignature(LOADER_SIGNATURE);
        MethodResourceDescription mrd = new MethodResourceDescription("");
        ImplementationDefinition implDef = ImplementationDefinition.defineImplementation((String)"METHOD", (String)(LOADER_SIGNATURE + LOADER_CLASS_NAME), (ResourceDescription)mrd, (String[])new String[]{LOADER_CLASS_NAME, LOADER_METHOD_NAME});
        ced.addImplementation(implDef);
        RUNTIME.registerCoreElement(ced);
    }

    public static long runMain(COMPSsConstants.Lang lang, String ceiClass, String className, String methodName, ApplicationParameter[] arguments, ApplicationParameter target, ApplicationParameter[] results, AppMonitor monitor) throws AgentException {
        long appId = Math.abs(APP_ID_GENERATOR.nextLong());
        monitor.setAppId(appId);
        long mainAppId = Math.abs(APP_ID_GENERATOR.nextLong());
        try {
            int taskParamsCount = arguments.length;
            if (target != null) {
                ++taskParamsCount;
            }
            int totalParamsCount = (taskParamsCount += results.length) + 7;
            Object[] params = new Object[9 * totalParamsCount];
            Object[] loadParams = new Object[]{RUNTIME, DataType.OBJECT_T, Direction.IN, StdIOStream.UNSPECIFIED, "", "runtime", "", "1.0", new Boolean(false), RUNTIME, DataType.OBJECT_T, Direction.IN, StdIOStream.UNSPECIFIED, "", "api", "", "1.0", new Boolean(false), ceiClass, DataType.STRING_T, Direction.IN, StdIOStream.UNSPECIFIED, "", "ceiClass", "", "1.0", new Boolean(false), appId, DataType.LONG_T, Direction.IN, StdIOStream.UNSPECIFIED, "", "appId", "", "1.0", new Boolean(false), className, DataType.STRING_T, Direction.IN, StdIOStream.UNSPECIFIED, "", "className", "", "1.0", new Boolean(false), methodName, DataType.STRING_T, Direction.IN, StdIOStream.UNSPECIFIED, "", "methodName", "", "1.0", new Boolean(false), 3, DataType.INT_T, Direction.IN, StdIOStream.UNSPECIFIED, "", "fakeParam", "", "1.0", new Boolean(false)};
            System.arraycopy(loadParams, 0, params, 0, loadParams.length);
            int position = loadParams.length;
            for (ApplicationParameter param : arguments) {
                LOGGER.debug("\t Parameter:" + param.getParamName());
                Agent.addParameterToTaskArguments(mainAppId, param, position, params);
                position += 9;
            }
            if (target != null) {
                LOGGER.debug("\t Target:" + target.getParamName());
                Agent.addParameterToTaskArguments(mainAppId, target, position, params);
                position += 9;
            }
            for (ApplicationParameter param : results) {
                params[position] = new Object();
                params[position + 1] = param.getType();
                params[position + 2] = param.getDirection();
                params[position + 3] = param.getStdIOStream();
                params[position + 4] = param.getPrefix();
                params[position + 5] = param.getParamName();
                params[position + 6] = param.getContentType();
                params[position + 7] = Double.toString(param.getWeight());
                params[position + 8] = new Boolean(param.isKeepRename());
                position += 9;
            }
            LoaderMonitor mainMonitor = new LoaderMonitor(mainAppId, monitor);
            RUNTIME.executeTask(Long.valueOf(mainAppId), (TaskMonitor)mainMonitor, lang, true, LOADER_CLASS_NAME, LOADER_METHOD_NAME, LOADER_SIGNATURE + LOADER_CLASS_NAME, OnFailure.RETRY, 0, false, 1, false, false, false, null, totalParamsCount, params);
        }
        catch (Exception e) {
            throw new AgentException(e);
        }
        return mainAppId;
    }

    public static long runTask(COMPSsConstants.Lang lang, String className, String methodName, ApplicationParameter[] arguments, ApplicationParameter target, ApplicationParameter[] results, MethodResourceDescription requirements, AppMonitor monitor) throws AgentException {
        System.out.println("");
        System.out.println("");
        System.out.println("");
        System.out.println("");
        System.out.println("");
        System.out.println("New request to run as a " + lang + " task " + className + "." + methodName);
        System.out.println("Parameters: ");
        for (ApplicationParameter param : arguments) {
            System.out.println("\t* " + param.getDirection() + " " + param.getType() + (param.getDataMgmtId() == null ? "" : " (" + param.getDataMgmtId() + ")"));
        }
        System.out.println("Target: ");
        if (target != null) {
            System.out.println("\t* " + target.getDirection() + " " + target.getType() + (target.getDataMgmtId() == null ? "" : " (" + target.getDataMgmtId() + ")"));
        }
        System.out.println("Results: ");
        for (ApplicationParameter param : results) {
            System.out.println("\t* " + param.getDirection() + " " + param.getType() + (param.getDataMgmtId() == null ? "" : " (" + param.getDataMgmtId() + ")"));
        }
        System.out.println("");
        System.out.println("");
        LOGGER.debug("New request to run as a " + lang + " task " + className + "." + methodName);
        LOGGER.debug("Parameters: ");
        for (ApplicationParameter param : arguments) {
            LOGGER.debug("\t* " + param);
        }
        LOGGER.debug("The task requires " + requirements);
        long appId = Math.abs(APP_ID_GENERATOR.nextLong());
        monitor.setAppId(appId);
        try {
            StringBuilder typesSB = new StringBuilder();
            int paramsCount = arguments.length;
            if (target != null) {
                ++paramsCount;
            }
            Object[] params = new Object[9 * (paramsCount += results.length)];
            int position = 0;
            LOGGER.debug("Handles parameters:");
            for (ApplicationParameter param : arguments) {
                LOGGER.debug("\t Parameter:" + param.getParamName());
                if (typesSB.length() > 0) {
                    typesSB.append(",");
                }
                if (param.getType() != DataType.PSCO_T) {
                    typesSB.append(param.getType().toString());
                } else {
                    typesSB.append("OBJECT_T");
                }
                Agent.addParameterToTaskArguments(appId, param, position, params);
                position += 9;
            }
            if (target != null) {
                LOGGER.debug("\t Target:" + target.getParamName());
                Agent.addParameterToTaskArguments(appId, target, position, params);
                position += 9;
            }
            for (ApplicationParameter param : results) {
                params[position] = new Object();
                params[position + 1] = param.getType();
                params[position + 2] = param.getDirection();
                params[position + 3] = param.getStdIOStream();
                params[position + 4] = param.getPrefix();
                params[position + 5] = param.getParamName();
                params[position + 6] = param.getContentType();
                params[position + 7] = Double.toString(param.getWeight());
                params[position + 8] = new Boolean(param.isKeepRename());
                position += 9;
            }
            String paramsTypes = typesSB.toString();
            String ceSignature = methodName + "(" + paramsTypes + ")";
            String implSignature = methodName + "(" + paramsTypes + ")" + className;
            CoreElementDefinition ced = new CoreElementDefinition();
            ced.setCeSignature(ceSignature);
            ImplementationDefinition implDef = ImplementationDefinition.defineImplementation((String)"METHOD", (String)implSignature, (ResourceDescription)requirements, (String[])new String[]{className, methodName});
            ced.addImplementation(implDef);
            RUNTIME.registerCoreElement(ced);
            RUNTIME.executeTask(Long.valueOf(appId), (TaskMonitor)monitor, lang, className, methodName, false, 1, false, false, target != null, paramsCount, OnFailure.RETRY, 0, params);
        }
        catch (Exception e) {
            throw new AgentException(e);
        }
        return appId;
    }

    private static void addParameterToTaskArguments(Long appId, ApplicationParameter param, int position, Object[] arguments) throws AgentException, Exception {
        RemoteDataInformation remote = param.getRemoteData();
        if (param.getRemoteData() == null) {
            LOGGER.debug("\t\tUsing value passed in as parameter");
            arguments[position] = param.getValueContent();
        } else {
            Object stub = new Object();
            LOGGER.debug("\t\tRegistering manually " + stub + "as" + param.getRemoteData());
            arguments[position] = stub;
            Agent.addRemoteData(remote);
            RUNTIME.registerData(appId, param.getType(), stub, remote.getRenaming());
        }
        System.out.println("Loading argument " + arguments[position]);
        arguments[position + 1] = param.getType();
        arguments[position + 2] = param.getDirection();
        arguments[position + 3] = param.getStdIOStream();
        arguments[position + 4] = param.getPrefix();
        arguments[position + 5] = param.getParamName();
        arguments[position + 6] = param.getContentType();
        arguments[position + 7] = Double.toString(param.getWeight());
        arguments[position + 8] = new Boolean(param.isKeepRename());
    }

    private static void addRemoteData(RemoteDataInformation remote) throws AgentException {
        System.out.println("ADDING REMOTE DATA " + remote);
        int addedSources = 0;
        LogicalData ld = Comm.getData((String)remote.getRenaming());
        System.out.println(ld);
        LogicalData otherNamedLocalData = null;
        LinkedList<DataLocation> locations = new LinkedList<DataLocation>();
        for (RemoteDataLocation remoteDataLocation : remote.getSources()) {
            try {
                LogicalData localData;
                String path = remoteDataLocation.getPath();
                SimpleURI uri = new SimpleURI(path);
                Resource<?, ?> r = remoteDataLocation.getResource();
                String workerName = r.getName();
                Worker host = ResourceManager.getWorker((String)workerName);
                if (host == null) {
                    MethodResourceDescription mrd = r.getDescription();
                    String adaptor = r.getAdaptor();
                    HashMap<String, Object> projectConf = new HashMap<String, Object>();
                    projectConf.put("Properties", r.getProjectConf());
                    HashMap<String, Object> resourcesConf = new HashMap<String, Object>();
                    resourcesConf.put("Properties", r.getResourceConf());
                    host = Agent.registerWorker(workerName, mrd, adaptor, projectConf, resourcesConf);
                } else if (host == Comm.getAppHost() && (localData = Comm.getData((String)uri.getPath())) != null) {
                    otherNamedLocalData = localData;
                    ++addedSources;
                    continue;
                }
                DataLocation dl = DataLocation.createLocation((es.bsc.compss.types.resources.Resource)host, (SimpleURI)uri);
                locations.add(dl);
            }
            catch (AgentException | IOException e) {
                e.printStackTrace();
            }
        }
        if (ld == null) {
            if (otherNamedLocalData == null) {
                ld = Comm.registerData((String)remote.getRenaming());
            } else {
                try {
                    Comm.linkData((String)otherNamedLocalData.getName(), (String)remote.getRenaming());
                }
                catch (CommException ce) {
                    ErrorManager.error((String)("Could not link " + remote.getRenaming() + " and " + otherNamedLocalData.getName()), (Exception)((Object)ce));
                }
                ++addedSources;
            }
        }
        for (DataLocation dataLocation : locations) {
            ld.addLocation(dataLocation);
            ++addedSources;
        }
        System.out.println(ld);
        if (addedSources == 0) {
            throw new AgentException("Could not add any source for data " + remote.getRenaming());
        }
    }

    public static void addResources(Resource<?, ?> r) throws AgentException {
        String workerName = r.getName();
        MethodResourceDescription description = r.getDescription();
        DynamicMethodWorker worker = ResourceManager.getDynamicResource((String)workerName);
        if (worker != null) {
            ResourceManager.increasedDynamicWorker((DynamicMethodWorker)worker, (MethodResourceDescription)description);
        } else {
            String adaptor = r.getAdaptor();
            HashMap<String, Object> projectConf = new HashMap<String, Object>();
            projectConf.put("Properties", r.getProjectConf());
            HashMap<String, Object> resourcesConf = new HashMap<String, Object>();
            resourcesConf.put("Properties", r.getResourceConf());
            Agent.registerWorker(workerName, description, adaptor, projectConf, resourcesConf);
        }
    }

    private static DynamicMethodWorker registerWorker(String workerName, MethodResourceDescription description, String adaptor, Map<String, Object> projectConf, Map<String, Object> resourcesConf) throws AgentException {
        MethodConfiguration mc;
        System.out.println("REGISTERING NEW WORKER with adaptor " + adaptor);
        if (description == null) {
            description = new MethodResourceDescription();
        }
        try {
            mc = (MethodConfiguration)Comm.constructConfiguration((String)adaptor, projectConf, resourcesConf);
        }
        catch (ConstructConfigurationException e) {
            throw new AgentException(e.getMessage(), e);
        }
        int limitOfTasks = mc.getLimitOfTasks();
        int computingUnits = description.getTotalCPUComputingUnits();
        if (limitOfTasks < 0 && computingUnits < 0) {
            mc.setLimitOfTasks(0);
            mc.setTotalComputingUnits(0);
        } else {
            mc.setLimitOfTasks(Math.max(limitOfTasks, computingUnits));
            mc.setTotalComputingUnits(Math.max(limitOfTasks, computingUnits));
        }
        mc.setLimitOfGPUTasks(description.getTotalGPUComputingUnits());
        mc.setTotalGPUComputingUnits(description.getTotalGPUComputingUnits());
        mc.setLimitOfFPGATasks(description.getTotalFPGAComputingUnits());
        mc.setTotalFPGAComputingUnits(description.getTotalFPGAComputingUnits());
        mc.setLimitOfOTHERsTasks(description.getTotalOTHERComputingUnits());
        mc.setTotalOTHERComputingUnits(description.getTotalOTHERComputingUnits());
        mc.setHost(workerName);
        DynamicMethodWorker worker = new DynamicMethodWorker(workerName, description, mc, new HashMap());
        ResourceManager.addDynamicWorker((DynamicMethodWorker)worker, (MethodResourceDescription)description);
        return worker;
    }

    public static void removeResources(String workerName, MethodResourceDescription reduction) throws AgentException {
        DynamicMethodWorker worker = ResourceManager.getDynamicResource((String)workerName);
        if (worker == null) {
            throw new AgentException("Resource " + workerName + " was not set up for this agent. Ignoring request.");
        }
        ResourceManager.requestWorkerReduction((DynamicMethodWorker)worker, (MethodResourceDescription)reduction);
    }

    public static void removeNode(String workerName) throws AgentException {
        try {
            ResourceManager.requestWholeWorkerReduction((String)workerName);
        }
        catch (NullPointerException e) {
            throw new AgentException("Resource " + workerName + " was not set up for this agent. Ignoring request.");
        }
    }

    public static void lostNode(String workerName) throws AgentException {
        try {
            ResourceManager.notifyWholeWorkerReduction((String)workerName);
        }
        catch (NullPointerException e) {
            throw new AgentException("Resource " + workerName + " was not set up for this agent. Ignoring request.");
        }
    }

    public static final void startInterface(AgentInterfaceConfig conf) throws ClassNotFoundException, InstantiationException, IllegalAccessException, AgentException {
        AgentInterface<?> itf = conf.getAgentInterface();
        itf.start(conf);
        INTERFACES.add(itf);
    }

    private static AgentInterfaceConfig getInterfaceConfig(String className, JSONObject arguments) throws ClassNotFoundException, InstantiationException, IllegalAccessException, AgentException {
        Class<?> agentClass = Class.forName(className);
        AgentInterface itf = (AgentInterface)agentClass.newInstance();
        return itf.configure(arguments);
    }

    public static final void main(String[] args) throws Exception {
        AgentInterfaceConfig aic;
        JSONObject conf;
        String interfaceClass;
        JSONObject jo;
        LinkedList<AgentInterfaceConfig> agents = new LinkedList<AgentInterfaceConfig>();
        String agentConfig = System.getProperty("compss.agent.configpath");
        if (agentConfig != null && !agentConfig.isEmpty()) {
            LOGGER.info("Reading Agent config from " + agentConfig);
            File configFile = new File(agentConfig);
            if (configFile.exists()) {
                String configString = new String(Files.readAllBytes(configFile.toPath()));
                JSONArray array = new JSONArray(configString);
                for (int i = 0; i < array.length(); ++i) {
                    jo = array.getJSONObject(i);
                    try {
                        interfaceClass = jo.getString("AGENT_IMPL");
                        conf = jo.getJSONObject("CONF");
                        LOGGER.info("Loading " + interfaceClass + "'s agent interface");
                        aic = Agent.getInterfaceConfig(interfaceClass, conf);
                        agents.add(aic);
                        continue;
                    }
                    catch (Exception e) {
                        ErrorManager.warn((String)("Unexpected format for agent config: " + jo));
                    }
                }
            } else {
                ErrorManager.warn((String)("Could not find the agent configuration file " + agentConfig));
            }
        }
        for (String arg : args) {
            try {
                jo = new JSONObject(arg);
                interfaceClass = jo.getString("AGENT_IMPL");
                conf = jo.getJSONObject("CONF");
                LOGGER.info("Loading " + agentConfig + "'s agent interface");
                aic = Agent.getInterfaceConfig(interfaceClass, conf);
                agents.add(aic);
            }
            catch (Exception e) {
                ErrorManager.warn((String)("Unexpected format for agent config: " + arg));
            }
        }
        for (AgentInterfaceConfig agent : agents) {
            try {
                Agent.startInterface(agent);
            }
            catch (Exception e) {
                ErrorManager.warn((String)"Could not start Agent", (Exception)e);
            }
        }
        if (INTERFACES.isEmpty()) {
            ErrorManager.fatal((String)"Could not start any interface");
        }
        Agent.start();
    }

    public static void finishedApplication(long appId) {
        RUNTIME.removeApplicationData(Long.valueOf(appId));
    }

    static {
        APP_ID_GENERATOR = new Random();
        AGENT_NAME = COMPSsNode.getMasterName();
        LOGGER.info("Initializing agent with name: " + AGENT_NAME);
        String dcConfigPath = System.getProperty("dataclay.configpath");
        LOGGER.debug("DataClay configuration: " + dcConfigPath);
        if (dcConfigPath != null) {
            try {
                StorageItf.init((String)dcConfigPath);
            }
            catch (StorageException se) {
                se.printStackTrace(System.err);
                System.err.println("Continuing...");
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        StorageItf.finish();
                    }
                    catch (StorageException se) {
                        se.printStackTrace(System.err);
                        System.err.println("Continuing...");
                    }
                }
            });
        }
        RUNTIME = new COMPSsRuntimeImpl();
        RUNTIME.setObjectRegistry(new ObjectRegistry((LoaderAPI)RUNTIME));
        RUNTIME.setStreamRegistry(new StreamRegistry((LoaderAPI)RUNTIME));
        INTERFACES = new LinkedList();
    }
}

