/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.agent.AgentException;
import es.bsc.compss.agent.AgentInterface;
import es.bsc.compss.agent.AgentInterfaceConfig;
import es.bsc.compss.agent.AppMonitor;
import es.bsc.compss.agent.types.ApplicationParameter;
import es.bsc.compss.agent.types.RemoteDataInformation;
import es.bsc.compss.agent.types.RemoteDataLocation;
import es.bsc.compss.agent.types.Resource;
import es.bsc.compss.api.TaskMonitor;
import es.bsc.compss.api.impl.COMPSsRuntimeImpl;
import es.bsc.compss.comm.Comm;
import es.bsc.compss.exceptions.CommException;
import es.bsc.compss.exceptions.ConstructConfigurationException;
import es.bsc.compss.loader.LoaderAPI;
import es.bsc.compss.loader.total.ObjectRegistry;
import es.bsc.compss.loader.total.StreamRegistry;
import es.bsc.compss.types.COMPSsNode;
import es.bsc.compss.types.CoreElementDefinition;
import es.bsc.compss.types.ErrorHandler;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.OnFailure;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.resources.DynamicMethodWorker;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.configuration.MethodConfiguration;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.ResourceManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import storage.StorageException;
import storage.StorageItf;

public class Agent {
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Agent");
    private static final String AGENT_NAME = COMPSsNode.getMasterName();
    private static final COMPSsRuntimeImpl RUNTIME;
    private static final List<AgentInterface<?>> INTERFACES;
    private static final int PARAM_LENGTH = 9;

    public static void start() {
        RUNTIME.startIT();
    }

    public static void stop() {
        RUNTIME.stopIT(true);
        Iterator<AgentInterface<?>> itfs = INTERFACES.iterator();
        while (itfs.hasNext()) {
            AgentInterface<?> itf = itfs.next();
            itf.stop();
            itfs.remove();
        }
    }

    public static long runTask(COMPSsConstants.Lang lang, CoreElementDefinition ced, String ceiClass, ApplicationParameter[] arguments, ApplicationParameter target, ApplicationParameter[] results, AppMonitor monitor, OnFailure onFailure) throws AgentException {
        LOGGER.debug("New request to run as a " + lang + " task " + ced.getCeSignature());
        LOGGER.debug("Parallelizing application according to " + ceiClass);
        LOGGER.debug("Parameters: ");
        for (ApplicationParameter param : arguments) {
            LOGGER.debug("\t* " + param);
        }
        Long appId = RUNTIME.registerApplication(ceiClass, null);
        monitor.setAppId(appId);
        try {
            StringBuilder typesSB = new StringBuilder();
            int paramsCount = arguments.length;
            if (target != null) {
                ++paramsCount;
            }
            Object[] params = new Object[9 * (paramsCount += results.length)];
            int position = 0;
            LOGGER.debug("Handles parameters:");
            for (ApplicationParameter param : arguments) {
                LOGGER.debug("\t Parameter:" + param.getParamName());
                if (typesSB.length() > 0) {
                    typesSB.append(",");
                }
                if (param.getType() != DataType.PSCO_T) {
                    typesSB.append(param.getType().toString());
                } else {
                    typesSB.append("OBJECT_T");
                }
                Agent.addParameterToTaskArguments(appId, param, position, params);
                position += 9;
            }
            if (target != null) {
                LOGGER.debug("\t Target:" + target.getParamName());
                Agent.addParameterToTaskArguments(appId, target, position, params);
                position += 9;
            }
            for (ApplicationParameter param : results) {
                params[position] = new Object();
                params[position + 1] = param.getType();
                params[position + 2] = param.getDirection();
                params[position + 3] = param.getStdIOStream();
                params[position + 4] = param.getPrefix();
                params[position + 5] = param.getParamName();
                params[position + 6] = param.getContentType();
                params[position + 7] = Double.toString(param.getWeight());
                params[position + 8] = new Boolean(param.isKeepRename());
                position += 9;
            }
            RUNTIME.registerCoreElement(ced);
            int numNodes = 1;
            RUNTIME.executeTask(appId, (TaskMonitor)monitor, lang, true, null, null, ced.getCeSignature(), onFailure, 0, false, numNodes, false, 0, false, false, target != null, null, paramsCount, params);
        }
        catch (Exception e) {
            LOGGER.error("Error submitting task", (Throwable)e);
            throw new AgentException(e);
        }
        return appId;
    }

    private static void addParameterToTaskArguments(Long appId, ApplicationParameter param, int position, Object[] arguments) throws AgentException, Exception {
        RemoteDataInformation remote = param.getRemoteData();
        if (param.getRemoteData() == null) {
            LOGGER.debug("\t\tUsing value passed in as parameter");
            arguments[position] = param.getValueContent();
        } else {
            Object stub = param.getType() == DataType.FILE_T ? param.getValueContent() : "app_" + appId + "_param" + position;
            arguments[position] = stub;
            Agent.addRemoteData(remote);
            RUNTIME.registerData(appId, param.getType(), stub, remote.getRenaming());
        }
        arguments[position + 1] = param.getType();
        arguments[position + 2] = param.getDirection();
        arguments[position + 3] = param.getStdIOStream();
        arguments[position + 4] = param.getPrefix();
        arguments[position + 5] = param.getParamName();
        arguments[position + 6] = param.getContentType();
        arguments[position + 7] = Double.toString(param.getWeight());
        arguments[position + 8] = new Boolean(param.isKeepRename());
    }

    private static void addRemoteData(RemoteDataInformation remote) throws AgentException {
        int addedSources = 0;
        LogicalData ld = Comm.getData((String)remote.getRenaming());
        LogicalData otherNamedLocalData = null;
        LinkedList<DataLocation> locations = new LinkedList<DataLocation>();
        for (RemoteDataLocation remoteDataLocation : remote.getSources()) {
            try {
                LogicalData localData;
                String path = remoteDataLocation.getPath();
                SimpleURI uri = new SimpleURI(path);
                Resource<?, ?> r = remoteDataLocation.getResource();
                String workerName = r.getName();
                Worker host = ResourceManager.getWorker((String)workerName);
                if (host == null) {
                    MethodResourceDescription mrd = r.getDescription();
                    String adaptor = r.getAdaptor();
                    HashMap<String, Object> projectConf = new HashMap<String, Object>();
                    projectConf.put("Properties", r.getProjectConf());
                    HashMap<String, Object> resourcesConf = new HashMap<String, Object>();
                    resourcesConf.put("Properties", r.getResourceConf());
                    host = Agent.registerWorker(workerName, mrd, adaptor, projectConf, resourcesConf);
                } else if (host == Comm.getAppHost() && (localData = Comm.getData((String)uri.getPath())) != null) {
                    otherNamedLocalData = localData;
                    ++addedSources;
                    continue;
                }
                DataLocation dl = DataLocation.createLocation((es.bsc.compss.types.resources.Resource)host, (SimpleURI)uri);
                locations.add(dl);
            }
            catch (AgentException | IOException e) {
                LOGGER.warn("Exception adding remote data", (Throwable)e);
            }
        }
        if (ld == null) {
            if (otherNamedLocalData == null) {
                ld = Comm.registerData((String)remote.getRenaming(), null);
            } else {
                try {
                    Comm.linkData((String)otherNamedLocalData.getName(), (String)remote.getRenaming());
                }
                catch (CommException ce) {
                    ErrorManager.error((String)("Could not link " + remote.getRenaming() + " and " + otherNamedLocalData.getName()), (Exception)((Object)ce));
                }
                ++addedSources;
            }
        }
        for (DataLocation dataLocation : locations) {
            ld.addLocation(dataLocation);
            ++addedSources;
        }
        if (addedSources == 0) {
            throw new AgentException("Could not add any source for data " + remote.getRenaming());
        }
    }

    public static void addResources(Resource<?, ?> r) throws AgentException {
        String workerName = r.getName();
        MethodResourceDescription description = r.getDescription();
        DynamicMethodWorker worker = ResourceManager.getDynamicResource((String)workerName);
        if (worker != null) {
            ResourceManager.increasedDynamicWorker((DynamicMethodWorker)worker, (MethodResourceDescription)description);
        } else {
            String adaptor = r.getAdaptor();
            HashMap<String, Object> projectConf = new HashMap<String, Object>();
            projectConf.put("Properties", r.getProjectConf());
            HashMap<String, Object> resourcesConf = new HashMap<String, Object>();
            resourcesConf.put("Properties", r.getResourceConf());
            Agent.registerWorker(workerName, description, adaptor, projectConf, resourcesConf);
        }
    }

    private static DynamicMethodWorker registerWorker(String workerName, MethodResourceDescription description, String adaptor, Map<String, Object> projectConf, Map<String, Object> resourcesConf) throws AgentException {
        MethodConfiguration mc;
        if (description == null) {
            description = new MethodResourceDescription();
        }
        try {
            mc = (MethodConfiguration)Comm.constructConfiguration((String)adaptor, projectConf, resourcesConf);
        }
        catch (ConstructConfigurationException e) {
            throw new AgentException(e.getMessage(), e);
        }
        int limitOfTasks = mc.getLimitOfTasks();
        int computingUnits = description.getTotalCPUComputingUnits();
        if (limitOfTasks < 0 && computingUnits < 0) {
            mc.setLimitOfTasks(0);
            mc.setTotalComputingUnits(0);
        } else {
            mc.setLimitOfTasks(Math.max(limitOfTasks, computingUnits));
            mc.setTotalComputingUnits(Math.max(limitOfTasks, computingUnits));
        }
        mc.setLimitOfGPUTasks(description.getTotalGPUComputingUnits());
        mc.setTotalGPUComputingUnits(description.getTotalGPUComputingUnits());
        mc.setLimitOfFPGATasks(description.getTotalFPGAComputingUnits());
        mc.setTotalFPGAComputingUnits(description.getTotalFPGAComputingUnits());
        mc.setLimitOfOTHERsTasks(description.getTotalOTHERComputingUnits());
        mc.setTotalOTHERComputingUnits(description.getTotalOTHERComputingUnits());
        mc.setHost(workerName);
        DynamicMethodWorker worker = new DynamicMethodWorker(workerName, description, mc, new HashMap());
        ResourceManager.addDynamicWorker((DynamicMethodWorker)worker, (MethodResourceDescription)description);
        return worker;
    }

    public static void removeResources(String workerName, MethodResourceDescription reduction) throws AgentException {
        DynamicMethodWorker worker = ResourceManager.getDynamicResource((String)workerName);
        if (worker == null) {
            throw new AgentException("Resource " + workerName + " was not set up for this agent. Ignoring request.");
        }
        ResourceManager.requestWorkerReduction((DynamicMethodWorker)worker, (MethodResourceDescription)reduction);
    }

    public static void removeNode(String workerName) throws AgentException {
        try {
            ResourceManager.requestWholeWorkerReduction((String)workerName);
        }
        catch (NullPointerException e) {
            throw new AgentException("Resource " + workerName + " was not set up for this agent. Ignoring request.");
        }
    }

    public static void lostNode(String workerName) throws AgentException {
        try {
            ResourceManager.notifyWholeWorkerReduction((String)workerName);
        }
        catch (NullPointerException e) {
            throw new AgentException("Resource " + workerName + " was not set up for this agent. Ignoring request.");
        }
    }

    public static final void startInterface(AgentInterfaceConfig conf) throws ClassNotFoundException, InstantiationException, IllegalAccessException, AgentException {
        AgentInterface<?> itf = conf.getAgentInterface();
        itf.start(conf);
        INTERFACES.add(itf);
    }

    private static AgentInterfaceConfig getInterfaceConfig(String className, JSONObject arguments) throws ClassNotFoundException, InstantiationException, IllegalAccessException, AgentException {
        Class<?> agentClass = Class.forName(className);
        AgentInterface itf = (AgentInterface)agentClass.newInstance();
        return itf.configure(arguments);
    }

    public static final void main(String[] args) throws Exception {
        AgentInterfaceConfig aic;
        JSONObject conf;
        String interfaceClass;
        JSONObject jo;
        LinkedList<AgentInterfaceConfig> agents = new LinkedList<AgentInterfaceConfig>();
        String agentConfig = System.getProperty("compss.agent.configpath");
        if (agentConfig != null && !agentConfig.isEmpty()) {
            LOGGER.info("Reading Agent config from " + agentConfig);
            File configFile = new File(agentConfig);
            if (configFile.exists()) {
                String configString = new String(Files.readAllBytes(configFile.toPath()));
                JSONArray array = new JSONArray(configString);
                for (int i = 0; i < array.length(); ++i) {
                    jo = array.getJSONObject(i);
                    try {
                        interfaceClass = jo.getString("AGENT_IMPL");
                        conf = jo.getJSONObject("CONF");
                        LOGGER.info("Loading " + interfaceClass + "'s agent interface");
                        aic = Agent.getInterfaceConfig(interfaceClass, conf);
                        agents.add(aic);
                        continue;
                    }
                    catch (Exception e) {
                        ErrorManager.warn((String)("Unexpected format for agent config: " + jo));
                    }
                }
            } else {
                ErrorManager.warn((String)("Could not find the agent configuration file " + agentConfig));
            }
        }
        for (String arg : args) {
            try {
                jo = new JSONObject(arg);
                interfaceClass = jo.getString("AGENT_IMPL");
                conf = jo.getJSONObject("CONF");
                LOGGER.info("Loading " + agentConfig + "'s agent interface");
                aic = Agent.getInterfaceConfig(interfaceClass, conf);
                agents.add(aic);
            }
            catch (Exception e) {
                ErrorManager.warn((String)("Unexpected format for agent config: " + arg));
            }
        }
        for (AgentInterfaceConfig agent : agents) {
            try {
                Agent.startInterface(agent);
            }
            catch (Exception e) {
                ErrorManager.warn((String)"Could not start Agent", (Exception)e);
            }
        }
        if (INTERFACES.isEmpty()) {
            ErrorManager.fatal((String)"Could not start any interface");
        }
        Agent.start();
    }

    public static void finishedApplication(long appId) {
        RUNTIME.removeApplicationData(Long.valueOf(appId));
        RUNTIME.deregisterApplication(Long.valueOf(appId));
    }

    static {
        LOGGER.info("Initializing agent with name: " + AGENT_NAME);
        String dcConfigPath = System.getProperty("dataclay.configpath");
        LOGGER.debug("DataClay configuration: " + dcConfigPath);
        if (dcConfigPath != null) {
            try {
                StorageItf.init((String)dcConfigPath);
            }
            catch (StorageException se) {
                se.printStackTrace(System.err);
                System.err.println("Continuing...");
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        StorageItf.finish();
                    }
                    catch (StorageException se) {
                        se.printStackTrace(System.err);
                        System.err.println("Continuing...");
                    }
                }
            });
        }
        RUNTIME = new COMPSsRuntimeImpl();
        ErrorHandler feh = new ErrorHandler(){

            public boolean handleError() {
                LOGGER.info("Error raised. Please, check runtime.log");
                return false;
            }

            public boolean handleFatalError() {
                LOGGER.info("Fatal error for an application raised. Please, check runtime.log");
                return false;
            }
        };
        ErrorManager.init((ErrorHandler)feh);
        RUNTIME.setObjectRegistry(new ObjectRegistry((LoaderAPI)RUNTIME));
        RUNTIME.setStreamRegistry(new StreamRegistry((LoaderAPI)RUNTIME));
        INTERFACES = new LinkedList();
    }
}

