/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent;

import es.bsc.compss.agent.Agent;
import es.bsc.compss.agent.types.ApplicationParameter;
import es.bsc.compss.api.TaskMonitor;
import es.bsc.compss.comm.Comm;
import es.bsc.compss.exceptions.CommException;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.ErrorManager;

public abstract class AppMonitor
implements TaskMonitor {
    private long appId;
    private final ApplicationParameter[] params;
    private final DataType[] paramTypes;
    private final String[] paramLocations;

    public AppMonitor(ApplicationParameter[] params) {
        int numParams = params.length;
        this.params = params;
        this.paramTypes = new DataType[numParams];
        this.paramLocations = new String[numParams];
    }

    public AppMonitor(ApplicationParameter[] args, ApplicationParameter target, ApplicationParameter[] results) {
        int argsCount = args.length;
        int resultsCount = results.length;
        int numParams = argsCount + resultsCount + (target != null ? 1 : 0);
        this.params = new ApplicationParameter[numParams];
        int offset = 0;
        System.arraycopy(args, 0, this.params, 0, argsCount);
        offset = argsCount;
        if (target != null) {
            this.params[argsCount] = target;
            ++offset;
        }
        System.arraycopy(results, 0, this.params, offset, resultsCount);
        this.paramTypes = new DataType[numParams];
        this.paramLocations = new String[numParams];
    }

    public void setAppId(long appId) {
        this.appId = appId;
    }

    public long getAppId() {
        return this.appId;
    }

    public void onCreation() {
    }

    public void onAccessesProcessed() {
    }

    public void onSchedule() {
    }

    public void onSubmission() {
    }

    public void onDataReception() {
    }

    public void valueGenerated(int paramId, String paramName, DataType paramType, String dataId, Object dataLocation) {
        ApplicationParameter originalParam = this.params[paramId];
        String originalDataMgmtId = originalParam.getDataMgmtId();
        this.paramTypes[paramId] = paramType;
        if (paramType == DataType.OBJECT_T) {
            LogicalData ld = Comm.getData((String)dataId);
            if (ld.getPscoId() != null) {
                this.paramTypes[paramId] = DataType.PSCO_T;
                SimpleURI targetURI = new SimpleURI(ProtocolType.PERSISTENT_URI.getSchema() + ld.getPscoId());
                this.paramLocations[paramId] = targetURI.toString();
            } else {
                this.paramTypes[paramId] = paramType;
                this.paramLocations[paramId] = originalDataMgmtId;
            }
        } else {
            this.paramTypes[paramId] = paramType;
            this.paramLocations[paramId] = dataLocation.toString();
        }
        if (dataId.compareTo(originalDataMgmtId) != 0) {
            try {
                Comm.linkData((String)originalDataMgmtId, (String)dataId);
            }
            catch (CommException ce) {
                ErrorManager.error((String)("Could not link " + originalDataMgmtId + " and " + dataId), (Exception)((Object)ce));
            }
        }
    }

    public String[] getParamLocations() {
        return this.paramLocations;
    }

    public DataType[] getParamTypes() {
        return this.paramTypes;
    }

    public void onAbortedExecution() {
    }

    public void onErrorExecution() {
    }

    public void onFailedExecution() {
    }

    public void onSuccesfulExecution() {
    }

    public void onCancellation() {
    }

    public void onException() {
    }

    public void onCompletion() {
        Agent.finishedApplication(this.appId);
    }

    public void onFailure() {
        Agent.finishedApplication(this.appId);
    }
}

