/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.agent.AgentException;
import es.bsc.compss.agent.AgentInterface;
import es.bsc.compss.agent.AgentInterfaceConfig;
import es.bsc.compss.agent.AppMonitor;
import es.bsc.compss.agent.types.ApplicationParameter;
import es.bsc.compss.agent.types.RemoteDataInformation;
import es.bsc.compss.agent.types.RemoteDataLocation;
import es.bsc.compss.agent.types.Resource;
import es.bsc.compss.api.TaskMonitor;
import es.bsc.compss.api.impl.COMPSsRuntimeImpl;
import es.bsc.compss.comm.Comm;
import es.bsc.compss.exceptions.CommException;
import es.bsc.compss.exceptions.ConstructConfigurationException;
import es.bsc.compss.loader.LoaderAPI;
import es.bsc.compss.loader.total.ObjectRegistry;
import es.bsc.compss.loader.total.StreamRegistry;
import es.bsc.compss.log.LoggerManager;
import es.bsc.compss.types.COMPSsNode;
import es.bsc.compss.types.CoreElementDefinition;
import es.bsc.compss.types.ErrorHandler;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.OnFailure;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.resources.DynamicMethodWorker;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.configuration.MethodConfiguration;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.ResourceManager;
import es.bsc.compss.util.RuntimeConfigManager;
import es.bsc.compss.util.TraceEvent;
import es.bsc.compss.util.Tracer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import storage.StorageException;
import storage.StorageItf;

public class Agent {
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Agent");
    private static final String AGENT_NAME = COMPSsNode.getMasterName();
    private static final COMPSsRuntimeImpl RUNTIME;
    private static final List<AgentInterface<?>> INTERFACES;
    private static final int PARAM_LENGTH = 9;
    private static final String WARN_IT_FILE_NOT_READ = "WARNING: COMPSs Properties file could not be read";
    private static final String WARN_FILE_EMPTY_DEFAULT = "WARNING: COMPSs Properties file is null. Setting default values";

    private static void setAgentProperties() {
        String propertiesLoc = System.getProperty("compss.properties.location");
        if (propertiesLoc == null) {
            InputStream stream = Agent.findPropertiesConfigFile();
            if (stream != null) {
                try {
                    Agent.setPropertiesFromRuntime(new RuntimeConfigManager(stream));
                }
                catch (Exception e) {
                    System.err.println(WARN_IT_FILE_NOT_READ);
                    e.printStackTrace();
                }
            } else {
                Agent.setDefaultProperties();
            }
        } else {
            try {
                Agent.setPropertiesFromRuntime(new RuntimeConfigManager(propertiesLoc));
            }
            catch (Exception e) {
                System.err.println(WARN_IT_FILE_NOT_READ);
                e.printStackTrace();
            }
        }
    }

    private static void setDefaultProperties() {
        System.err.println(WARN_FILE_EMPTY_DEFAULT);
        Agent.setDefaultProperty("compss.uuid", COMPSsConstants.DEFAULT_DEPLOYMENT_ID);
        Agent.setDefaultProperty("compss.resources.schema", COMPSsConstants.DEFAULT_RES_SCHEMA);
        Agent.setDefaultProperty("compss.project.schema", COMPSsConstants.DEFAULT_PROJECT_SCHEMA);
        Agent.setDefaultProperty("gat.adaptor.path", COMPSsConstants.DEFAULT_GAT_ADAPTOR_LOCATION);
        Agent.setDefaultProperty("compss.comm", "es.bsc.compss.nio.master.NIOAdaptor");
        Agent.setDefaultProperty("compss.execution.reuseOnBlock", "true");
        Agent.setDefaultProperty("compss.execution.nested.enabled", "false");
        Agent.setDefaultProperty("compss.conn", "es.bsc.compss.connectors.DefaultSSHConnector");
        Agent.setDefaultProperty("compss.scheduler", "es.bsc.compss.components.impl.TaskScheduler");
        Agent.setDefaultProperty("compss.tracing", "0");
        Agent.setDefaultProperty("compss.extrae.file", "null");
        Agent.setDefaultProperty("compss.task.execution", COMPSsConstants.TaskExecution.COMPSS.toString());
    }

    private static void setDefaultProperty(String propertyName, String defaultValue) {
        String propertyValue = System.getProperty(propertyName);
        if (propertyValue == null || propertyValue.isEmpty()) {
            System.setProperty(propertyName, defaultValue);
        }
    }

    private static void setPropertyFromRuntime(String propertyName, String managerValue) {
        if (managerValue != null && System.getProperty(propertyName) == null) {
            System.setProperty(propertyName, managerValue);
        }
    }

    private static void setPropertiesFromRuntime(RuntimeConfigManager manager) {
        try {
            if (manager != null) {
                Agent.setPropertyFromRuntime("compss.uuid", manager.getDeploymentId());
                Agent.setPropertyFromRuntime("compss.masterName", manager.getMasterName());
                Agent.setPropertyFromRuntime("compss.masterPort", manager.getMasterPort());
                Agent.setPropertyFromRuntime("compss.appName", manager.getAppName());
                Agent.setPropertyFromRuntime("compss.summary", manager.getTaskSummary());
                Agent.setPropertyFromRuntime("compss.baseLogDir", manager.getCOMPSsBaseLogDir());
                Agent.setPropertyFromRuntime("compss.specificLogDir", manager.getSpecificLogDir());
                Agent.setPropertyFromRuntime("log4j.configurationFile", manager.getLog4jConfiguration());
                Agent.setPropertyFromRuntime("compss.resources.file", manager.getResourcesFile());
                Agent.setPropertyFromRuntime("compss.resources.schema", manager.getResourcesSchema());
                Agent.setPropertyFromRuntime("compss.project.file", manager.getProjectFile());
                Agent.setPropertyFromRuntime("compss.project.schema", manager.getProjectSchema());
                Agent.setPropertyFromRuntime("compss.scheduler", manager.getScheduler());
                Agent.setPropertyFromRuntime("compss.monitor", Long.toString(manager.getMonitorInterval()));
                Agent.setPropertyFromRuntime("gat.adaptor.path", manager.getGATAdaptor());
                Agent.setPropertyFromRuntime("gat.broker.adaptor", manager.getGATBrokerAdaptor());
                Agent.setPropertyFromRuntime("gat.file.adaptor", manager.getGATFileAdaptor());
                if (System.getProperty("compss.execution.reuseOnBlock") == null || System.getProperty("compss.execution.reuseOnBlock").isEmpty()) {
                    System.setProperty("compss.execution.reuseOnBlock", Boolean.toString(manager.getReuseResourcesOnBlock()));
                }
                if (System.getProperty("compss.execution.nested.enabled") == null || System.getProperty("compss.execution.nested.enabled").isEmpty()) {
                    System.setProperty("compss.execution.nested.enabled", Boolean.toString(manager.isNestedDetectionEnabled()));
                }
                Agent.setPropertyFromRuntime("compss.worker.cp", manager.getWorkerCP());
                Agent.setPropertyFromRuntime("compss.worker.jvm_opts", manager.getWorkerJVMOpts());
                if (System.getProperty("compss.worker.cpu_affinity") == null || System.getProperty("compss.worker.cpu_affinity").isEmpty()) {
                    System.setProperty("compss.worker.cpu_affinity", Boolean.toString(manager.isWorkerCPUAffinityEnabled()));
                }
                if (System.getProperty("compss.worker.gpu_affinity") == null || System.getProperty("compss.worker.gpu_affinity").isEmpty()) {
                    System.setProperty("compss.worker.gpu_affinity", Boolean.toString(manager.isWorkerGPUAffinityEnabled()));
                }
                Agent.setPropertyFromRuntime("compss.serviceName", manager.getServiceName());
                if (System.getProperty("compss.comm") == null) {
                    if (manager.getCommAdaptor() != null) {
                        System.setProperty("compss.comm", manager.getCommAdaptor());
                    } else {
                        System.setProperty("compss.comm", "es.bsc.compss.nio.master.NIOAdaptor");
                    }
                }
                if (System.getProperty("compss.conn") == null) {
                    if (manager.getConn() != null) {
                        System.setProperty("compss.conn", manager.getConn());
                    } else {
                        System.setProperty("compss.conn", "es.bsc.compss.connectors.DefaultSSHConnector");
                    }
                }
                if (System.getProperty("gat.debug") == null) {
                    System.setProperty("gat.debug", Boolean.toString(manager.isGATDebug()));
                }
                if (System.getProperty("compss.lang") == null) {
                    System.setProperty("compss.lang", manager.getLang());
                }
                if (System.getProperty("compss.graph") == null) {
                    System.setProperty("compss.graph", Boolean.toString(manager.isGraph()));
                }
                if (System.getProperty("compss.tracing") == null) {
                    System.setProperty("compss.tracing", String.valueOf(manager.getTracing()));
                }
                if (System.getProperty("compss.extrae.file") == null) {
                    System.setProperty("compss.extrae.file", manager.getCustomExtraeFile());
                }
                if (System.getProperty("compss.extrae.file.python") == null) {
                    System.setProperty("compss.extrae.file.python", manager.getCustomExtraeFilePython());
                }
                if (System.getProperty("compss.task.execution") == null || System.getProperty("compss.task.execution").equals("")) {
                    System.setProperty("compss.task.execution", COMPSsConstants.TaskExecution.COMPSS.toString());
                }
                if (manager.getContext() != null) {
                    System.setProperty("compss.context", manager.getContext());
                }
                System.setProperty("compss.to.file", Boolean.toString(manager.isToFile()));
            } else {
                Agent.setDefaultProperties();
            }
        }
        catch (Exception e) {
            System.err.println(WARN_IT_FILE_NOT_READ);
            e.printStackTrace();
        }
    }

    private static InputStream findPropertiesConfigFile() {
        InputStream stream = COMPSsRuntimeImpl.class.getResourceAsStream("compss.properties");
        if (stream == null && (stream = COMPSsRuntimeImpl.class.getResourceAsStream(File.separator + "compss.properties")) == null && (stream = COMPSsRuntimeImpl.class.getClassLoader().getResourceAsStream("compss.properties")) == null && (stream = COMPSsRuntimeImpl.class.getClassLoader().getResourceAsStream(File.separator + "compss.properties")) == null && (stream = ClassLoader.getSystemResourceAsStream("compss.properties")) == null && (stream = ClassLoader.getSystemResourceAsStream(File.separator + "compss.properties")) == null && (stream = COMPSsRuntimeImpl.class.getClassLoader().getParent().getResourceAsStream("compss.properties")) == null) {
            stream = COMPSsRuntimeImpl.class.getClassLoader().getParent().getResourceAsStream(File.separator + "compss.properties");
        }
        return stream;
    }

    public static void start() {
        RUNTIME.startIT();
    }

    public static void stop() {
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent((long)TraceEvent.AGENT_STOP.getId(), (int)TraceEvent.AGENT_STOP.getType());
        }
        RUNTIME.stopIT(true);
        Iterator<AgentInterface<?>> itfs = INTERFACES.iterator();
        while (itfs.hasNext()) {
            AgentInterface<?> itf = itfs.next();
            itf.stop();
            itfs.remove();
        }
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent((long)0L, (int)TraceEvent.AGENT_STOP.getType());
        }
    }

    public static long runTask(COMPSsConstants.Lang lang, CoreElementDefinition ced, String ceiClass, ApplicationParameter[] arguments, ApplicationParameter target, ApplicationParameter[] results, AppMonitor monitor, OnFailure onFailure) throws AgentException {
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent((long)TraceEvent.AGENT_RUN_TASK.getId(), (int)TraceEvent.AGENT_RUN_TASK.getType());
        }
        Long appId = RUNTIME.registerApplication(ceiClass, null);
        monitor.setAppId(appId);
        LOGGER.debug("New request to run as a " + lang + " task " + ced.getCeSignature());
        LOGGER.debug("appId: " + appId);
        LOGGER.debug("Ced.tostring: " + ced.toString());
        LOGGER.debug("Parallelizing application according to " + ceiClass);
        LOGGER.debug("Parameters: ");
        for (ApplicationParameter param : arguments) {
            LOGGER.debug("\t* " + param);
        }
        try {
            StringBuilder typesSB = new StringBuilder();
            int paramsCount = arguments.length;
            if (target != null) {
                ++paramsCount;
            }
            Object[] params = new Object[9 * (paramsCount += results.length)];
            int position = 0;
            LOGGER.debug("Handles parameters:");
            for (ApplicationParameter param : arguments) {
                LOGGER.debug("\t Parameter:" + param.getParamName());
                if (typesSB.length() > 0) {
                    typesSB.append(",");
                }
                if (param.getType() != DataType.PSCO_T) {
                    typesSB.append(param.getType().toString());
                } else {
                    typesSB.append("OBJECT_T");
                }
                Agent.addParameterToTaskArguments(appId, param, position, params);
                position += 9;
            }
            if (target != null) {
                LOGGER.debug("\t Target:" + target.getParamName());
                Agent.addParameterToTaskArguments(appId, target, position, params);
                position += 9;
            }
            for (ApplicationParameter param : results) {
                params[position] = DataType.FILE_T.equals((Object)param.getType()) ? UUID.randomUUID().toString() : new Object();
                params[position + 1] = param.getType();
                params[position + 2] = param.getDirection();
                params[position + 3] = param.getStdIOStream();
                params[position + 4] = param.getPrefix();
                params[position + 5] = param.getParamName();
                params[position + 6] = param.getContentType();
                params[position + 7] = Double.toString(param.getWeight());
                params[position + 8] = new Boolean(param.isKeepRename());
                position += 9;
            }
            RUNTIME.registerCoreElement(ced);
            int numNodes = 1;
            RUNTIME.executeTask(appId, (TaskMonitor)monitor, lang, true, null, null, ced.getCeSignature(), onFailure, 0, false, numNodes, false, 0, false, false, target != null, null, paramsCount, params);
        }
        catch (Exception e) {
            LOGGER.error("Error submitting task", (Throwable)e);
            throw new AgentException(e);
        }
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent((long)0L, (int)TraceEvent.AGENT_RUN_TASK.getType());
        }
        return appId;
    }

    private static void addParameterToTaskArguments(Long appId, ApplicationParameter param, int position, Object[] arguments) throws AgentException, Exception {
        RemoteDataInformation remote = param.getRemoteData();
        if (param.getRemoteData() == null) {
            LOGGER.debug("\t\tUsing value passed in as parameter");
            arguments[position] = param.getValueContent();
        } else {
            Object stub = param.getType() == DataType.FILE_T ? param.getValueContent() : "app_" + appId + "_param" + position;
            arguments[position] = stub;
            Agent.addRemoteData(remote);
            RUNTIME.registerData(appId, param.getType(), stub, remote.getRenaming());
        }
        arguments[position + 1] = param.getType();
        arguments[position + 2] = param.getDirection();
        arguments[position + 3] = param.getStdIOStream();
        arguments[position + 4] = param.getPrefix();
        arguments[position + 5] = param.getParamName();
        arguments[position + 6] = param.getContentType();
        arguments[position + 7] = Double.toString(param.getWeight());
        arguments[position + 8] = new Boolean(param.isKeepRename());
    }

    private static void addRemoteData(RemoteDataInformation remote) throws AgentException {
        int addedSources = 0;
        LogicalData ld = Comm.getData((String)remote.getRenaming());
        LogicalData otherNamedLocalData = null;
        LinkedList<DataLocation> locations = new LinkedList<DataLocation>();
        for (RemoteDataLocation remoteDataLocation : remote.getSources()) {
            try {
                LogicalData localData;
                String path = remoteDataLocation.getPath();
                SimpleURI uri = new SimpleURI(path);
                Resource<?, ?> r = remoteDataLocation.getResource();
                String workerName = r.getName();
                Worker host = ResourceManager.getWorker((String)workerName);
                if (host == null) {
                    MethodResourceDescription mrd = r.getDescription();
                    String adaptor = r.getAdaptor();
                    HashMap<String, Object> projectConf = new HashMap<String, Object>();
                    projectConf.put("Properties", r.getProjectConf());
                    HashMap<String, Object> resourcesConf = new HashMap<String, Object>();
                    resourcesConf.put("Properties", r.getResourceConf());
                    host = Agent.registerWorker(workerName, mrd, adaptor, projectConf, resourcesConf);
                } else if (host == Comm.getAppHost() && (localData = Comm.getData((String)uri.getPath())) != null) {
                    otherNamedLocalData = localData;
                    ++addedSources;
                    continue;
                }
                DataLocation dl = DataLocation.createLocation((es.bsc.compss.types.resources.Resource)host, (SimpleURI)uri);
                locations.add(dl);
            }
            catch (AgentException | IOException e) {
                LOGGER.warn("Exception adding remote data", (Throwable)e);
            }
        }
        if (ld == null) {
            if (otherNamedLocalData == null) {
                ld = Comm.registerData((String)remote.getRenaming(), null);
            } else {
                try {
                    Comm.linkData((String)otherNamedLocalData.getName(), (String)remote.getRenaming());
                }
                catch (CommException ce) {
                    ErrorManager.error((String)("Could not link " + remote.getRenaming() + " and " + otherNamedLocalData.getName()), (Exception)((Object)ce));
                }
                ++addedSources;
            }
        }
        for (DataLocation dataLocation : locations) {
            ld.addLocation(dataLocation);
            ++addedSources;
        }
        if (addedSources == 0) {
            throw new AgentException("Could not add any source for data " + remote.getRenaming());
        }
    }

    public static void addResources(Resource<?, ?> r) throws AgentException {
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent((long)TraceEvent.AGENT_ADD_RESOURCE.getId(), (int)TraceEvent.AGENT_ADD_RESOURCE.getType());
        }
        String workerName = r.getName();
        MethodResourceDescription description = r.getDescription();
        DynamicMethodWorker worker = ResourceManager.getDynamicResource((String)workerName);
        if (worker != null) {
            ResourceManager.increasedDynamicWorker((DynamicMethodWorker)worker, (MethodResourceDescription)description);
        } else {
            String adaptor = r.getAdaptor();
            HashMap<String, Object> projectConf = new HashMap<String, Object>();
            projectConf.put("Properties", r.getProjectConf());
            HashMap<String, Object> resourcesConf = new HashMap<String, Object>();
            resourcesConf.put("Properties", r.getResourceConf());
            Agent.registerWorker(workerName, description, adaptor, projectConf, resourcesConf);
        }
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent((long)0L, (int)TraceEvent.AGENT_ADD_RESOURCE.getType());
        }
    }

    private static DynamicMethodWorker registerWorker(String workerName, MethodResourceDescription description, String adaptor, Map<String, Object> projectConf, Map<String, Object> resourcesConf) throws AgentException {
        MethodConfiguration mc;
        if (description == null) {
            description = new MethodResourceDescription();
        }
        try {
            mc = (MethodConfiguration)Comm.constructConfiguration((String)adaptor, projectConf, resourcesConf);
        }
        catch (ConstructConfigurationException e) {
            throw new AgentException(e.getMessage(), e);
        }
        int limitOfTasks = mc.getLimitOfTasks();
        int computingUnits = description.getTotalCPUComputingUnits();
        if (limitOfTasks < 0 && computingUnits < 0) {
            mc.setLimitOfTasks(0);
            mc.setTotalComputingUnits(0);
        } else {
            mc.setLimitOfTasks(Math.max(limitOfTasks, computingUnits));
            mc.setTotalComputingUnits(Math.max(limitOfTasks, computingUnits));
        }
        mc.setLimitOfGPUTasks(description.getTotalGPUComputingUnits());
        mc.setTotalGPUComputingUnits(description.getTotalGPUComputingUnits());
        mc.setLimitOfFPGATasks(description.getTotalFPGAComputingUnits());
        mc.setTotalFPGAComputingUnits(description.getTotalFPGAComputingUnits());
        mc.setLimitOfOTHERsTasks(description.getTotalOTHERComputingUnits());
        mc.setTotalOTHERComputingUnits(description.getTotalOTHERComputingUnits());
        mc.setHost(workerName);
        DynamicMethodWorker worker = new DynamicMethodWorker(workerName, description, mc, new HashMap());
        ResourceManager.addDynamicWorker((DynamicMethodWorker)worker, (MethodResourceDescription)description);
        return worker;
    }

    public static void removeResources(String workerName, MethodResourceDescription reduction) throws AgentException {
        DynamicMethodWorker worker;
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent((long)TraceEvent.AGENT_REMOVE_RESOURCES.getId(), (int)TraceEvent.AGENT_REMOVE_RESOURCES.getType());
        }
        if ((worker = ResourceManager.getDynamicResource((String)workerName)) == null) {
            throw new AgentException("Resource " + workerName + " was not set up for this agent. Ignoring request.");
        }
        ResourceManager.requestWorkerReduction((DynamicMethodWorker)worker, (MethodResourceDescription)reduction);
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent((long)0L, (int)TraceEvent.AGENT_REMOVE_RESOURCES.getType());
        }
    }

    public static void removeNode(String workerName) throws AgentException {
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent((long)TraceEvent.AGENT_REMOVE_RESOURCES.getId(), (int)TraceEvent.AGENT_REMOVE_RESOURCES.getType());
        }
        try {
            ResourceManager.requestWholeWorkerReduction((String)workerName);
        }
        catch (NullPointerException e) {
            throw new AgentException("Resource " + workerName + " was not set up for this agent. Ignoring request.");
        }
        finally {
            if (Tracer.extraeEnabled()) {
                Tracer.emitEvent((long)0L, (int)TraceEvent.AGENT_REMOVE_RESOURCES.getType());
            }
        }
    }

    public static void lostNode(String workerName) throws AgentException {
        try {
            ResourceManager.notifyWholeWorkerReduction((String)workerName);
        }
        catch (NullPointerException e) {
            throw new AgentException("Resource " + workerName + " was not set up for this agent. Ignoring request.");
        }
    }

    public static final void startInterface(AgentInterfaceConfig conf) throws ClassNotFoundException, InstantiationException, IllegalAccessException, AgentException {
        AgentInterface<?> itf = conf.getAgentInterface();
        itf.start(conf);
        INTERFACES.add(itf);
    }

    private static AgentInterfaceConfig getInterfaceConfig(String className, JSONObject arguments) throws ClassNotFoundException, InstantiationException, IllegalAccessException, AgentException {
        Class<?> agentClass = Class.forName(className);
        AgentInterface itf = (AgentInterface)agentClass.newInstance();
        return itf.configure(arguments);
    }

    public static final void main(String[] args) throws Exception {
        AgentInterfaceConfig aic;
        JSONObject conf;
        String interfaceClass;
        JSONObject jo;
        LinkedList<AgentInterfaceConfig> agents = new LinkedList<AgentInterfaceConfig>();
        String agentConfig = System.getProperty("compss.agent.configpath");
        if (agentConfig != null && !agentConfig.isEmpty()) {
            LOGGER.info("Reading Agent config from " + agentConfig);
            File configFile = new File(agentConfig);
            if (configFile.exists()) {
                String configString = new String(Files.readAllBytes(configFile.toPath()));
                JSONArray array = new JSONArray(configString);
                for (int i = 0; i < array.length(); ++i) {
                    jo = array.getJSONObject(i);
                    try {
                        interfaceClass = jo.getString("AGENT_IMPL");
                        conf = jo.getJSONObject("CONF");
                        LOGGER.info("Loading " + interfaceClass + "'s agent interface");
                        aic = Agent.getInterfaceConfig(interfaceClass, conf);
                        agents.add(aic);
                        continue;
                    }
                    catch (Exception e) {
                        ErrorManager.warn((String)("Unexpected format for agent config: " + jo));
                    }
                }
            } else {
                ErrorManager.warn((String)("Could not find the agent configuration file " + agentConfig));
            }
        }
        for (String arg : args) {
            try {
                jo = new JSONObject(arg);
                interfaceClass = jo.getString("AGENT_IMPL");
                conf = jo.getJSONObject("CONF");
                LOGGER.info("Loading " + agentConfig + "'s agent interface");
                aic = Agent.getInterfaceConfig(interfaceClass, conf);
                agents.add(aic);
            }
            catch (Exception e) {
                ErrorManager.warn((String)("Unexpected format for agent config: " + arg));
            }
        }
        for (AgentInterfaceConfig agent : agents) {
            try {
                Agent.startInterface(agent);
            }
            catch (Exception e) {
                ErrorManager.warn((String)"Could not start Agent", (Exception)e);
            }
        }
        if (INTERFACES.isEmpty()) {
            ErrorManager.fatal((String)"Could not start any interface");
        }
        Agent.start();
    }

    public static void finishedApplication(long appId) {
        RUNTIME.removeApplicationData(Long.valueOf(appId));
        RUNTIME.deregisterApplication(Long.valueOf(appId));
    }

    static {
        Agent.setAgentProperties();
        LoggerManager.init();
        LOGGER.info("Initializing agent with name: " + AGENT_NAME);
        if (System.getProperty("compss.tracing") != null && Integer.parseInt(System.getProperty("compss.tracing")) != 0) {
            int tracingLevel = Integer.parseInt(System.getProperty("compss.tracing"));
            LOGGER.debug("Tracing is activated [" + tracingLevel + ']');
            Tracer.init((String)LoggerManager.getAppLogDirPath(), (int)tracingLevel);
            if (Tracer.extraeEnabled()) {
                Tracer.emitEvent((long)TraceEvent.STATIC_IT.getId(), (int)TraceEvent.STATIC_IT.getType());
            }
        }
        String dcConfigPath = System.getProperty("dataclay.configpath");
        LOGGER.debug("DataClay configuration: " + dcConfigPath);
        if (dcConfigPath != null) {
            try {
                StorageItf.init((String)dcConfigPath);
            }
            catch (StorageException se) {
                se.printStackTrace(System.err);
                System.err.println("Continuing...");
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        StorageItf.finish();
                    }
                    catch (StorageException se) {
                        se.printStackTrace(System.err);
                        System.err.println("Continuing...");
                    }
                }
            });
        }
        RUNTIME = new COMPSsRuntimeImpl();
        LOGGER.debug("Executing Agent");
        try {
            Thread.sleep(200L);
        }
        catch (Exception e) {
            LOGGER.debug("");
        }
        ErrorHandler feh = new ErrorHandler(){

            public boolean handleError() {
                LOGGER.info("Error raised. Please, check runtime.log");
                return false;
            }

            public boolean handleFatalError() {
                LOGGER.info("Fatal error for an application raised. Please, check runtime.log");
                return false;
            }
        };
        ErrorManager.init((ErrorHandler)feh);
        RUNTIME.setObjectRegistry(new ObjectRegistry((LoaderAPI)RUNTIME));
        RUNTIME.setStreamRegistry(new StreamRegistry((LoaderAPI)RUNTIME));
        INTERFACES = new LinkedList();
    }
}

