/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent;

import es.bsc.compss.util.TraceMerger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;

public class AgentTraceMerger
extends TraceMerger {
    private static Logger LOGGER;

    private static void loggerSetUp(String path) throws IOException {
        File logFile = new File(path);
        if (!logFile.exists()) {
            logFile.mkdirs();
        }
        System.setProperty("compss.appLogDir", logFile.getAbsolutePath());
        ((LoggerContext)LogManager.getContext((boolean)false)).reconfigure();
        LOGGER = LogManager.getLogger((String)"es.bsc.compss.Communication");
    }

    public AgentTraceMerger(String outputDir, String[] agentsDirs, String traceName) throws IOException {
        LOGGER.debug("Initializing AgentTraceMerger");
        ArrayList<File> workersFiles = new ArrayList<File>();
        LOGGER.debug("Searching for trace files");
        for (String oneAgentDir : agentsDirs) {
            File traceDirFile = new File(oneAgentDir + File.separator + "trace");
            File tracesToMergeDirFile = new File(oneAgentDir + File.separator + "to_merge");
            tracesToMergeDirFile.mkdirs();
            File[] allFilesInFolder = traceDirFile.listFiles();
            if (allFilesInFolder == null) {
                throw new FileNotFoundException("Folder not found: " + oneAgentDir);
            }
            for (int i = 0; i < allFilesInFolder.length; ++i) {
                String newFileName = tracesToMergeDirFile.getAbsolutePath() + File.separator + allFilesInFolder[i].getName();
                File newFile = new File(newFileName);
                File oldFile = allFilesInFolder[i];
                newFile.createNewFile();
                TraceMerger.copyFile((File)oldFile, (File)newFile);
                allFilesInFolder[i] = newFile;
            }
            File[] oneAgentMatchingFiles = tracesToMergeDirFile.listFiles((dir, name) -> name.endsWith(".prv"));
            if (oneAgentMatchingFiles == null || oneAgentMatchingFiles.length < 1) {
                throw new FileNotFoundException("No traces matching  were found at directory " + oneAgentDir);
            }
            workersFiles.addAll(Arrays.asList(oneAgentMatchingFiles));
        }
        File[] workersTraces = workersFiles.toArray(new File[0]);
        LOGGER.debug("The following traces will be merged:");
        for (File trace : workersTraces) {
            LOGGER.debug("    " + trace.getAbsolutePath());
        }
        this.setUpWorkers(workersTraces);
        File outputFile = new File(outputDir + File.separator + traceName + ".prv");
        LOGGER.debug("Merge result will be stored at " + outputFile.getAbsolutePath());
        if (!outputFile.exists()) {
            Files.createDirectories(Paths.get(outputDir, new String[0]), new FileAttribute[0]);
            outputFile.createNewFile();
        }
        this.setUpMaster(outputFile);
        LOGGER.debug("AgentTraceMerger initialization successful");
    }

    public void merge() throws Exception {
        LOGGER.debug("Starting merge process.");
        System.out.println("Starting merge process.");
        this.createPRVswithGlobalCE();
        this.mergePRVsIntoNewFile();
        this.mergeROWsIntoNewFile();
        LOGGER.debug("Merge finished.");
        System.out.println("Merge finished.");
        this.removeTmpAgentFiles();
    }

    public static void main(String[] args) throws IOException {
        String resTraceName = args[0];
        String outputDir = args[1];
        String[] traceDirs = Arrays.copyOfRange(args, 2, args.length);
        AgentTraceMerger.loggerSetUp(outputDir);
        System.out.println("----------------------------------------");
        System.out.println("Initiating agent trace merging");
        System.out.println("----------------------------------------");
        System.out.println("Result trace name: " + resTraceName);
        System.out.println("OutputDir: " + outputDir);
        System.out.println("Merging traces in the following folders:");
        for (String path : traceDirs) {
            System.out.println("    " + path);
        }
        LOGGER.debug("----------------------------------------");
        LOGGER.debug("Initiating agent trace merging");
        LOGGER.debug("----------------------------------------");
        LOGGER.debug("Result trace name: " + resTraceName);
        LOGGER.debug("OutputDir: " + outputDir);
        LOGGER.debug("Merging traces in the following folders:");
        for (String path : traceDirs) {
            LOGGER.debug("    " + path);
        }
        try {
            AgentTraceMerger tm = new AgentTraceMerger(outputDir, traceDirs, resTraceName);
            tm.merge();
        }
        catch (Throwable t) {
            System.err.println("Failed to correctly merge traces: exception risen");
            LOGGER.error("Failed to correctly merge traces: exception risen", t);
        }
    }
}

