/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent;

import es.bsc.compss.agent.Agent;
import es.bsc.compss.agent.types.ApplicationParameter;
import es.bsc.compss.agent.types.ApplicationParameterCollection;
import es.bsc.compss.api.ParameterCollectionMonitor;
import es.bsc.compss.api.ParameterMonitor;
import es.bsc.compss.api.TaskMonitor;
import es.bsc.compss.comm.Comm;
import es.bsc.compss.exceptions.CommException;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.worker.COMPSsException;
import java.util.List;

public abstract class AppMonitor
implements TaskMonitor {
    private long appId;
    private TaskResult[] taskResults;
    private COMPSsException exception;

    public AppMonitor(ApplicationParameter[] args, ApplicationParameter target, ApplicationParameter[] results) {
        int offset;
        int argsCount = args.length;
        int resultsCount = results.length;
        int numParams = argsCount + resultsCount + (target != null ? 1 : 0);
        this.taskResults = new TaskResult[numParams];
        for (offset = 0; offset < argsCount; ++offset) {
            ApplicationParameter param = args[offset];
            this.taskResults[offset] = this.buildResult(param);
        }
        if (target != null) {
            this.taskResults[offset] = this.buildResult(target);
            ++offset;
        }
        for (int resultIdx = 0; resultIdx < results.length; ++resultIdx) {
            ApplicationParameter param = results[resultIdx];
            this.taskResults[offset] = this.buildResult(param);
            ++offset;
        }
    }

    private TaskResult buildResult(ApplicationParameter param) {
        switch (param.getType()) {
            case COLLECTION_T: 
            case DICT_COLLECTION_T: {
                ApplicationParameterCollection colParam = (ApplicationParameterCollection)param;
                List subParams = colParam.getCollectionParameters();
                int numElements = subParams.size();
                TaskResult[] subResults = new TaskResult[numElements];
                int subElementIdx = 0;
                for (ApplicationParameter subParam : subParams) {
                    subResults[subElementIdx] = this.buildResult(subParam);
                    ++subElementIdx;
                }
                return new CollectionTaskResult(param.getDataMgmtId(), subResults);
            }
        }
        return new TaskResult(param.getDataMgmtId());
    }

    public ParameterMonitor getParameterMonitor(int paramId) {
        return this.taskResults[paramId].getMonitor();
    }

    public void setAppId(long appId) {
        this.appId = appId;
    }

    public long getAppId() {
        return this.appId;
    }

    public void onCreation() {
    }

    public void onAccessesProcessed() {
    }

    public void onSchedule() {
    }

    public void onSubmission() {
    }

    public void onDataReception() {
    }

    public void onAbortedExecution() {
    }

    public void onErrorExecution() {
    }

    public void onFailedExecution() {
    }

    public void onSuccesfulExecution() {
    }

    public void onCancellation() {
    }

    public void onException(COMPSsException e) {
        this.exception = e;
    }

    public TaskResult[] getResults() {
        return this.taskResults;
    }

    public void setResults(TaskResult[] params) {
        this.taskResults = params;
    }

    public void onCompletion() {
        Agent.finishedApplication(this.appId);
    }

    public void onFailure() {
        Agent.finishedApplication(this.appId);
    }

    public COMPSsException getException() {
        return this.exception;
    }

    public static class CollectionTaskResult
    extends TaskResult {
        private final TaskResult[] subElements;

        public CollectionTaskResult(String externalDataId, TaskResult[] subResults) {
            super(externalDataId);
            this.subElements = subResults;
        }

        @Override
        public boolean isCollective() {
            return true;
        }

        public TaskResult[] getSubelements() {
            return this.subElements;
        }

        @Override
        public ParameterMonitor getMonitor() {
            return new CollectionParameterUpdater();
        }

        public class CollectionParameterUpdater
        extends TaskResult.ParameterUpdater
        implements ParameterCollectionMonitor {
            public ParameterMonitor getParameterMonitor(int i) {
                return CollectionTaskResult.this.subElements[i].getMonitor();
            }
        }
    }

    public static class TaskResult {
        private final String externalDataId;
        private String dataLocation;

        public TaskResult(String externalDataId) {
            this.externalDataId = externalDataId;
        }

        public boolean isCollective() {
            return false;
        }

        public String getDataLocation() {
            return this.dataLocation;
        }

        public void setDataLocation(String dataLocation) {
            this.dataLocation = dataLocation;
        }

        public ParameterMonitor getMonitor() {
            return new ParameterUpdater();
        }

        public class ParameterUpdater
        implements ParameterMonitor {
            public void onCreation(DataType type, String dataName, String dataLocation) {
                TaskResult.this.dataLocation = dataLocation;
                LogicalData ld = Comm.getData((String)dataName);
                if (type == DataType.OBJECT_T) {
                    SimpleURI targetURI;
                    if (ld.getPscoId() != null) {
                        targetURI = new SimpleURI(ProtocolType.PERSISTENT_URI.getSchema() + ld.getPscoId());
                        TaskResult.this.dataLocation = targetURI.toString();
                    } else {
                        targetURI = new SimpleURI(ProtocolType.OBJECT_URI.getSchema() + TaskResult.this.externalDataId);
                        TaskResult.this.dataLocation = targetURI.toString();
                    }
                }
                if (dataName.compareTo(TaskResult.this.externalDataId) != 0) {
                    try {
                        Comm.linkData((String)TaskResult.this.externalDataId, (String)dataName);
                    }
                    catch (CommException ce) {
                        ErrorManager.error((String)("Could not link " + TaskResult.this.externalDataId + " and " + dataName), (Exception)((Object)ce));
                    }
                }
            }
        }
    }
}

