/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent;

import es.bsc.compss.agent.Agent;
import es.bsc.compss.agent.types.ApplicationParameter;
import es.bsc.compss.agent.types.ApplicationParameterCollection;
import es.bsc.compss.agent.types.PrivateRemoteDataLocation;
import es.bsc.compss.agent.types.RemoteDataLocation;
import es.bsc.compss.agent.types.Resource;
import es.bsc.compss.agent.types.SharedRemoteDataLocation;
import es.bsc.compss.api.ApplicationRunner;
import es.bsc.compss.api.ParameterCollectionMonitor;
import es.bsc.compss.api.ParameterMonitor;
import es.bsc.compss.api.TaskMonitor;
import es.bsc.compss.comm.Comm;
import es.bsc.compss.exceptions.CommException;
import es.bsc.compss.types.COMPSsNode;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.SharedDisk;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.worker.COMPSsException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AppMonitor
implements ApplicationRunner {
    private long appId;
    private TaskResult[] taskResults;
    private COMPSsException exception;
    protected static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Communication");

    public AppMonitor(ApplicationParameter[] args, ApplicationParameter target, ApplicationParameter[] results) {
        int offset;
        int argsCount = args.length;
        int resultsCount = results.length;
        int numParams = argsCount + resultsCount + (target != null ? 1 : 0);
        this.taskResults = new TaskResult[numParams];
        for (offset = 0; offset < argsCount; ++offset) {
            ApplicationParameter param = args[offset];
            this.taskResults[offset] = this.buildResult(param);
        }
        if (target != null) {
            this.taskResults[offset] = this.buildResult(target);
            ++offset;
        }
        for (int resultIdx = 0; resultIdx < results.length; ++resultIdx) {
            ApplicationParameter param = results[resultIdx];
            this.taskResults[offset] = this.buildResult(param);
            ++offset;
        }
    }

    private TaskResult buildResult(ApplicationParameter param) {
        switch (param.getType()) {
            case COLLECTION_T: 
            case DICT_COLLECTION_T: {
                ApplicationParameterCollection colParam = (ApplicationParameterCollection)param;
                List subParams = colParam.getCollectionParameters();
                int numElements = subParams.size();
                TaskResult[] subResults = new TaskResult[numElements];
                int subElementIdx = 0;
                for (ApplicationParameter subParam : subParams) {
                    subResults[subElementIdx] = this.buildResult(subParam);
                    ++subElementIdx;
                }
                return new CollectionTaskResult(param.getDataMgmtId(), subResults, this);
            }
        }
        return new TaskResult(param.getDataMgmtId(), this);
    }

    public void setAppId(long appId) {
        this.appId = appId;
    }

    public long getAppId() {
        return this.appId;
    }

    public COMPSsException getException() {
        return this.exception;
    }

    public TaskResult[] getResults() {
        return this.taskResults;
    }

    public void setResults(TaskResult[] params) {
        this.taskResults = params;
    }

    public void stalledApplication() {
    }

    public void readyToContinue(Semaphore sem) {
    }

    public final void onCancellation() {
        this.specificOnCancellation();
    }

    protected abstract void specificOnCancellation();

    public final void onException(COMPSsException e) {
        this.exception = e;
        this.specificOnException(e);
    }

    protected abstract void specificOnException(COMPSsException var1);

    public final void onCompletion() {
        new Thread(){

            @Override
            public void run() {
                Agent.finishedApplication(AppMonitor.this.appId);
                AppMonitor.this.specificOnCompletion();
            }
        }.start();
    }

    protected abstract void specificOnCompletion();

    public void onFailure() {
        new Thread(){

            @Override
            public void run() {
                Agent.finishedApplication(AppMonitor.this.appId);
                AppMonitor.this.specificOnFailure();
            }
        }.start();
    }

    protected abstract void specificOnFailure();

    public abstract UniqueTaskMonitor getTaskMonitor();

    public static class CollectionTaskResult
    extends TaskResult {
        private final TaskResult[] subElements;

        public CollectionTaskResult(String externalDataId, TaskResult[] subResults, AppMonitor monitor) {
            super(externalDataId, monitor);
            this.subElements = subResults;
        }

        @Override
        public boolean isCollective() {
            return true;
        }

        public TaskResult[] getSubelements() {
            return this.subElements;
        }

        @Override
        public ParameterMonitor getMonitor() {
            return new CollectionParameterUpdater();
        }

        public class CollectionParameterUpdater
        extends TaskResult.ParameterUpdater
        implements ParameterCollectionMonitor {
            public ParameterMonitor getParameterMonitor(int i) {
                return CollectionTaskResult.this.subElements[i].getMonitor();
            }
        }
    }

    public static class TaskResult {
        private final String externalDataId;

        public TaskResult(String externalDataId, AppMonitor monitor) {
            this.externalDataId = externalDataId;
        }

        public boolean isCollective() {
            return false;
        }

        public ParameterMonitor getMonitor() {
            return new ParameterUpdater();
        }

        public Collection<RemoteDataLocation> getLocations() {
            LogicalData ld;
            if (this.externalDataId != null && (ld = Comm.getData((String)this.externalDataId)) != null) {
                return this.createRDLfromLD(ld);
            }
            return null;
        }

        private Collection<RemoteDataLocation> createRDLfromLD(LogicalData ld) {
            ArrayList<RemoteDataLocation> locations = new ArrayList<RemoteDataLocation>();
            boolean isLocal = false;
            for (DataLocation loc : ld.getLocations()) {
                boolean localLocation = this.isLocal(loc);
                boolean bl = isLocal = isLocal || localLocation;
                RemoteDataLocation rdl = this.createRemoteDLFromLocation(loc, localLocation);
                if (rdl == null) continue;
                locations.add(rdl);
            }
            boolean done = false;
            if (isLocal) {
                while (!done) {
                    ArrayList<PrivateRemoteDataLocation> localLocations = new ArrayList<PrivateRemoteDataLocation>();
                    try {
                        for (String alias : ld.getKnownAlias()) {
                            localLocations.add(new PrivateRemoteDataLocation(null, alias));
                        }
                    }
                    catch (ConcurrentModificationException cme) {
                        LOGGER.warn("Logical data was modified while constructing it's remote data location to send as a result");
                    }
                    locations.addAll(localLocations);
                    done = true;
                }
            }
            return locations;
        }

        private RemoteDataLocation createRemoteDLFromLocation(DataLocation loc, boolean isLocal) {
            RemoteDataLocation rdl = null;
            switch (loc.getType()) {
                case PRIVATE: {
                    if (isLocal) break;
                    for (MultiURI uri : loc.getURIs()) {
                        Resource<?, ?> hostResource = this.createRemoteResourceFromResource(uri.getHost());
                        if (hostResource == null) continue;
                        String pathInHost = uri.getPath();
                        rdl = new PrivateRemoteDataLocation(hostResource, pathInHost);
                    }
                    break;
                }
                case SHARED: {
                    SharedDisk sd = loc.getSharedDisk();
                    String diskName = sd.getName();
                    Map sdMountpoints = sd.getAllMountpoints();
                    SharedRemoteDataLocation.Mountpoint[] srdlMountpoints = new SharedRemoteDataLocation.Mountpoint[sdMountpoints.size()];
                    int i = 0;
                    for (Map.Entry sdMp : sdMountpoints.entrySet()) {
                        Resource<?, ?> r = this.createRemoteResourceFromResource((es.bsc.compss.types.resources.Resource)sdMp.getKey());
                        String mountpoint = (String)sdMp.getValue();
                        srdlMountpoints[i++] = new SharedRemoteDataLocation.Mountpoint(r, mountpoint);
                    }
                    rdl = new SharedRemoteDataLocation(diskName, loc.getPath(), srdlMountpoints);
                    break;
                }
            }
            return rdl;
        }

        private Resource<?, ?> createRemoteResourceFromResource(es.bsc.compss.types.resources.Resource res) {
            COMPSsNode node = res.getNode();
            String name = node.getName();
            String adaptor = node.getAdaptor();
            Object project = node.getProjectProperties();
            Object resources = node.getResourcesProperties();
            if (resources == null) {
                return null;
            }
            Resource<Object, Object> remoteResource = new Resource<Object, Object>(name, null, adaptor, project, resources);
            return remoteResource;
        }

        private boolean isLocal(DataLocation dl) {
            for (es.bsc.compss.types.resources.Resource host : dl.getHosts()) {
                if (host != Comm.getAppHost()) continue;
                return true;
            }
            return false;
        }

        public class ParameterUpdater
        implements ParameterMonitor {
            public void onCreation(DataType type, String dataName) {
                if (dataName.compareTo(TaskResult.this.externalDataId) != 0) {
                    try {
                        Comm.linkData((String)TaskResult.this.externalDataId, (String)dataName);
                    }
                    catch (CommException ce) {
                        ErrorManager.error((String)("Could not link " + TaskResult.this.externalDataId + " and " + dataName), (Exception)((Object)ce));
                    }
                }
            }
        }
    }

    protected abstract class UniqueTaskMonitor
    implements TaskMonitor {
        protected UniqueTaskMonitor() {
        }

        public ParameterMonitor getParameterMonitor(int paramId) {
            return AppMonitor.this.taskResults[paramId].getMonitor();
        }

        public final void onCreation() {
            this.specificOnCreation();
        }

        protected abstract void specificOnCreation();

        public final void onAccessesProcessed() {
            this.specificOnAccessesProcessed();
        }

        protected abstract void specificOnAccessesProcessed();

        public final void onSchedule() {
            this.specificOnSchedule();
        }

        protected abstract void specificOnSchedule();

        public final void onSubmission() {
            this.specificOnSubmission();
        }

        protected abstract void specificOnSubmission();

        public final void onDataReception() {
            this.specificOnDataReception();
        }

        protected abstract void specificOnDataReception();

        public final void onExecutionStart() {
            this.specificOnExecutionStart();
        }

        protected abstract void specificOnExecutionStart();

        public final void onExecutionStartAt(long t) {
            this.specificOnExecutionStartAt(t);
        }

        protected abstract void specificOnExecutionStartAt(long var1);

        public final void onExecutionEnd() {
            this.specificOnExecutionEnd();
        }

        protected abstract void specificOnExecutionEnd();

        public final void onExecutionEndAt(long t) {
            this.specificOnExecutionEndAt(t);
        }

        protected abstract void specificOnExecutionEndAt(long var1);

        public final void onAbortedExecution() {
            this.specificOnAbortedExecution();
        }

        protected abstract void specificOnAbortedExecution();

        public final void onErrorExecution() {
            this.specificOnErrorExecution();
        }

        protected abstract void specificOnErrorExecution();

        public final void onFailedExecution() {
            this.specificOnFailedExecution();
        }

        protected abstract void specificOnFailedExecution();

        public final void onSuccesfulExecution() {
            this.specificOnSuccessfulExecution();
        }

        protected abstract void specificOnSuccessfulExecution();

        public final void onCancellation() {
            this.specificOnCancellation();
            AppMonitor.this.onCancellation();
        }

        protected abstract void specificOnCancellation();

        public final void onException(COMPSsException e) {
            AppMonitor.this.exception = e;
            this.specificOnException(e);
            AppMonitor.this.onException(e);
        }

        protected abstract void specificOnException(COMPSsException var1);

        public final void onCompletion() {
            this.specificOnCompletion();
            AppMonitor.this.onCompletion();
        }

        protected abstract void specificOnCompletion();

        public void onFailure() {
            this.specificOnFailure();
            AppMonitor.this.onFailure();
        }

        protected abstract void specificOnFailure();
    }
}

