/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent.types;

import es.bsc.compss.agent.types.PrivateRemoteDataLocation;
import es.bsc.compss.agent.types.RemoteDataLocation;
import es.bsc.compss.agent.types.Resource;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class SharedRemoteDataLocation
implements RemoteDataLocation {
    private String diskName;
    private String pathOnDisk;
    private Mountpoint[] mountpoints;

    public SharedRemoteDataLocation() {
        this.diskName = null;
        this.pathOnDisk = null;
        this.mountpoints = new Mountpoint[0];
    }

    public SharedRemoteDataLocation(String sharedDisk, String pathOnDisk, Mountpoint[] mountpoints) {
        this.diskName = sharedDisk;
        this.pathOnDisk = pathOnDisk;
        this.mountpoints = mountpoints;
    }

    @Override
    public RemoteDataLocation.Type getType() {
        return RemoteDataLocation.Type.SHARED;
    }

    public String getDiskName() {
        return this.diskName;
    }

    public String getPathOnDisk() {
        return this.pathOnDisk;
    }

    public PrivateRemoteDataLocation[] getAllPrivateLocations() {
        PrivateRemoteDataLocation[] locs = new PrivateRemoteDataLocation[this.mountpoints.length];
        for (int i = 0; i < this.mountpoints.length; ++i) {
            Mountpoint m = this.mountpoints[i];
            locs[i] = new PrivateRemoteDataLocation(m.resource, m.path + this.pathOnDisk);
        }
        return locs;
    }

    public Mountpoint[] getMountpoints() {
        return this.mountpoints;
    }

    @Override
    public void writeExternal(ObjectOutput oo) throws IOException {
        oo.writeUTF(this.diskName);
        oo.writeUTF(this.pathOnDisk);
        oo.writeInt(this.mountpoints.length);
        for (Mountpoint m : this.mountpoints) {
            oo.writeObject(m);
        }
    }

    @Override
    public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
        this.diskName = oi.readUTF();
        this.pathOnDisk = oi.readUTF();
        int numMountpoints = oi.readInt();
        this.mountpoints = new Mountpoint[numMountpoints];
        for (int i = 0; i < numMountpoints; ++i) {
            this.mountpoints[i] = (Mountpoint)oi.readObject();
        }
    }

    public String toString() {
        StringBuilder desc = new StringBuilder("{\"disk\":\"" + this.diskName + "\", \"path\":\"" + this.pathOnDisk + "\",\"mountpoints\":[");
        for (Mountpoint m : this.mountpoints) {
            desc.append(m.toString() + ",");
        }
        desc.append("]}");
        return desc.toString();
    }

    public static class Mountpoint
    implements Externalizable {
        private Resource<?, ?> resource;
        private String path;

        public Mountpoint() {
        }

        public Mountpoint(Resource<?, ?> r, String path) {
            this.resource = r;
            this.path = path;
        }

        public Resource<?, ?> getResource() {
            return this.resource;
        }

        public String getPath() {
            return this.path;
        }

        @Override
        public void writeExternal(ObjectOutput oo) throws IOException {
            oo.writeObject(this.resource);
            oo.writeUTF(this.path);
        }

        @Override
        public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
            this.resource = (Resource)oi.readObject();
            this.path = oi.readUTF();
        }

        public String toString() {
            return "{\"resource\":" + (this.resource == null ? "null" : this.resource) + ", \"path\":" + this.path + "}";
        }
    }
}

