/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.COMPSsDefaults;
import es.bsc.compss.COMPSsPaths;
import es.bsc.compss.agent.AgentException;
import es.bsc.compss.agent.AgentInterface;
import es.bsc.compss.agent.AgentInterfaceConfig;
import es.bsc.compss.agent.AppMonitor;
import es.bsc.compss.agent.types.ApplicationParameter;
import es.bsc.compss.agent.types.ApplicationParameterCollection;
import es.bsc.compss.agent.types.PrivateRemoteDataLocation;
import es.bsc.compss.agent.types.RemoteDataInformation;
import es.bsc.compss.agent.types.RemoteDataLocation;
import es.bsc.compss.agent.types.Resource;
import es.bsc.compss.agent.types.SharedRemoteDataLocation;
import es.bsc.compss.api.ApplicationRunner;
import es.bsc.compss.api.impl.COMPSsRuntimeImpl;
import es.bsc.compss.comm.Comm;
import es.bsc.compss.exceptions.CommException;
import es.bsc.compss.exceptions.ConstructConfigurationException;
import es.bsc.compss.loader.LoaderAPI;
import es.bsc.compss.loader.total.ObjectRegistry;
import es.bsc.compss.loader.total.StreamRegistry;
import es.bsc.compss.log.LoggerManager;
import es.bsc.compss.types.COMPSsNode;
import es.bsc.compss.types.CoreElementDefinition;
import es.bsc.compss.types.ErrorHandler;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.OnFailure;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.resources.DynamicMethodWorker;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.configuration.MethodConfiguration;
import es.bsc.compss.types.tracing.TraceEvent;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.ResourceManager;
import es.bsc.compss.util.RuntimeConfigManager;
import es.bsc.compss.util.Tracer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import storage.StorageException;
import storage.StorageItf;

public class Agent {
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Agent");
    private static final String AGENT_NAME = COMPSsNode.getMasterName();
    private static final COMPSsRuntimeImpl RUNTIME;
    private static final List<AgentInterface<?>> INTERFACES;
    private static final int PARAM_LENGTH = 9;
    private static final String WARN_IT_FILE_NOT_READ = "WARNING: COMPSs Properties file could not be read";
    private static final String WARN_FILE_EMPTY_DEFAULT = "WARNING: COMPSs Properties file is null. Setting default values";

    private static void setAgentProperties() {
        String propertiesLoc = System.getProperty("compss.properties.location");
        if (propertiesLoc == null) {
            InputStream stream = Agent.findPropertiesConfigFile();
            if (stream != null) {
                try {
                    Agent.setPropertiesFromRuntime(new RuntimeConfigManager(stream));
                }
                catch (Exception e) {
                    System.err.println(WARN_IT_FILE_NOT_READ);
                    e.printStackTrace();
                }
            } else {
                Agent.setDefaultProperties();
            }
        } else {
            try {
                Agent.setPropertiesFromRuntime(new RuntimeConfigManager(propertiesLoc));
            }
            catch (Exception e) {
                System.err.println(WARN_IT_FILE_NOT_READ);
                e.printStackTrace();
            }
        }
    }

    private static void setDefaultProperties() {
        System.err.println(WARN_FILE_EMPTY_DEFAULT);
        Agent.setDefaultProperty("compss.uuid", COMPSsDefaults.DEPLOYMENT_ID);
        Agent.setDefaultProperty("compss.resources.schema", COMPSsPaths.LOCAL_RES_SCHEMA);
        Agent.setDefaultProperty("compss.project.schema", COMPSsPaths.LOCAL_PROJECT_SCHEMA);
        Agent.setDefaultProperty("gat.adaptor.path", COMPSsPaths.GAT_ADAPTOR_LOCATION);
        Agent.setDefaultProperty("compss.comm", "es.bsc.compss.nio.master.NIOAdaptor");
        Agent.setDefaultProperty("compss.execution.reuseOnBlock", "true");
        Agent.setDefaultProperty("compss.execution.nested.enabled", "false");
        Agent.setDefaultProperty("compss.conn", "es.bsc.compss.connectors.DefaultSSHConnector");
        Agent.setDefaultProperty("compss.scheduler", "es.bsc.compss.components.impl.TaskScheduler");
        Agent.setDefaultProperty("compss.tracing", "false");
        Agent.setDefaultProperty("compss.extrae.file", "null");
        Agent.setDefaultProperty("compss.task.execution", COMPSsConstants.TaskExecution.COMPSS.toString());
    }

    private static void setDefaultProperty(String propertyName, String defaultValue) {
        String propertyValue = System.getProperty(propertyName);
        if (propertyValue == null || propertyValue.isEmpty()) {
            System.setProperty(propertyName, defaultValue);
        }
    }

    private static void setPropertyFromRuntime(String propertyName, String managerValue) {
        if (managerValue != null && System.getProperty(propertyName) == null) {
            System.setProperty(propertyName, managerValue);
        }
    }

    private static void setPropertiesFromRuntime(RuntimeConfigManager manager) {
        try {
            if (manager != null) {
                Agent.setPropertyFromRuntime("compss.uuid", manager.getDeploymentId());
                Agent.setPropertyFromRuntime("compss.masterName", manager.getMasterName());
                Agent.setPropertyFromRuntime("compss.masterPort", manager.getMasterPort());
                Agent.setPropertyFromRuntime("compss.appName", manager.getAppName());
                Agent.setPropertyFromRuntime("compss.summary", manager.getTaskSummary());
                Agent.setPropertyFromRuntime("compss.log.dir", manager.getLogDir());
                Agent.setPropertyFromRuntime("compss.master.workingDir", manager.getWorkingDir());
                Agent.setPropertyFromRuntime("log4j.configurationFile", manager.getLog4jConfiguration());
                Agent.setPropertyFromRuntime("compss.resources.file", manager.getResourcesFile());
                Agent.setPropertyFromRuntime("compss.resources.schema", manager.getResourcesSchema());
                Agent.setPropertyFromRuntime("compss.project.file", manager.getProjectFile());
                Agent.setPropertyFromRuntime("compss.project.schema", manager.getProjectSchema());
                Agent.setPropertyFromRuntime("compss.scheduler", manager.getScheduler());
                Agent.setPropertyFromRuntime("compss.monitor", Long.toString(manager.getMonitorInterval()));
                Agent.setPropertyFromRuntime("gat.adaptor.path", manager.getGATAdaptor());
                Agent.setPropertyFromRuntime("gat.broker.adaptor", manager.getGATBrokerAdaptor());
                Agent.setPropertyFromRuntime("gat.file.adaptor", manager.getGATFileAdaptor());
                if (System.getProperty("compss.execution.reuseOnBlock") == null || System.getProperty("compss.execution.reuseOnBlock").isEmpty()) {
                    System.setProperty("compss.execution.reuseOnBlock", Boolean.toString(manager.getReuseResourcesOnBlock()));
                }
                if (System.getProperty("compss.execution.nested.enabled") == null || System.getProperty("compss.execution.nested.enabled").isEmpty()) {
                    System.setProperty("compss.execution.nested.enabled", Boolean.toString(manager.isNestedDetectionEnabled()));
                }
                Agent.setPropertyFromRuntime("compss.worker.cp", manager.getWorkerCP());
                Agent.setPropertyFromRuntime("compss.worker.jvm_opts", manager.getWorkerJVMOpts());
                if (System.getProperty("compss.worker.cpu_affinity") == null || System.getProperty("compss.worker.cpu_affinity").isEmpty()) {
                    System.setProperty("compss.worker.cpu_affinity", Boolean.toString(manager.isWorkerCPUAffinityEnabled()));
                }
                if (System.getProperty("compss.worker.gpu_affinity") == null || System.getProperty("compss.worker.gpu_affinity").isEmpty()) {
                    System.setProperty("compss.worker.gpu_affinity", Boolean.toString(manager.isWorkerGPUAffinityEnabled()));
                }
                Agent.setPropertyFromRuntime("compss.serviceName", manager.getServiceName());
                if (System.getProperty("compss.comm") == null) {
                    if (manager.getCommAdaptor() != null) {
                        System.setProperty("compss.comm", manager.getCommAdaptor());
                    } else {
                        System.setProperty("compss.comm", "es.bsc.compss.nio.master.NIOAdaptor");
                    }
                }
                if (System.getProperty("compss.conn") == null) {
                    if (manager.getConn() != null) {
                        System.setProperty("compss.conn", manager.getConn());
                    } else {
                        System.setProperty("compss.conn", "es.bsc.compss.connectors.DefaultSSHConnector");
                    }
                }
                if (System.getProperty("gat.debug") == null) {
                    System.setProperty("gat.debug", Boolean.toString(manager.isGATDebug()));
                }
                if (System.getProperty("compss.lang") == null) {
                    System.setProperty("compss.lang", manager.getLang());
                }
                if (System.getProperty("compss.graph") == null) {
                    System.setProperty("compss.graph", Boolean.toString(manager.isGraph()));
                }
                if (System.getProperty("compss.tracing") == null) {
                    System.setProperty("compss.tracing", String.valueOf(manager.getTracing()));
                }
                if (System.getProperty("compss.extrae.working_dir") == null) {
                    System.setProperty("compss.extrae.working_dir", manager.getExtraeWDir());
                }
                if (System.getProperty("compss.extrae.file") == null) {
                    System.setProperty("compss.extrae.file", manager.getCustomExtraeFile());
                }
                if (System.getProperty("compss.tracing.task.dependencies") == null) {
                    System.setProperty("compss.tracing.task.dependencies", String.valueOf(manager.getTracingTaskDep()));
                }
                if (System.getProperty("compss.extrae.file.python") == null) {
                    System.setProperty("compss.extrae.file.python", manager.getCustomExtraeFilePython());
                }
                if (System.getProperty("compss.task.execution") == null || System.getProperty("compss.task.execution").equals("")) {
                    System.setProperty("compss.task.execution", COMPSsConstants.TaskExecution.COMPSS.toString());
                }
                if (manager.getContext() != null) {
                    System.setProperty("compss.context", manager.getContext());
                }
                System.setProperty("compss.to.file", Boolean.toString(manager.isToFile()));
            } else {
                Agent.setDefaultProperties();
            }
        }
        catch (Exception e) {
            System.err.println(WARN_IT_FILE_NOT_READ);
            e.printStackTrace();
        }
    }

    private static InputStream findPropertiesConfigFile() {
        InputStream stream = COMPSsRuntimeImpl.class.getResourceAsStream("compss.properties");
        if (stream == null && (stream = COMPSsRuntimeImpl.class.getResourceAsStream(File.separator + "compss.properties")) == null && (stream = COMPSsRuntimeImpl.class.getClassLoader().getResourceAsStream("compss.properties")) == null && (stream = COMPSsRuntimeImpl.class.getClassLoader().getResourceAsStream(File.separator + "compss.properties")) == null && (stream = ClassLoader.getSystemResourceAsStream("compss.properties")) == null && (stream = ClassLoader.getSystemResourceAsStream(File.separator + "compss.properties")) == null && (stream = COMPSsRuntimeImpl.class.getClassLoader().getParent().getResourceAsStream("compss.properties")) == null) {
            stream = COMPSsRuntimeImpl.class.getClassLoader().getParent().getResourceAsStream(File.separator + "compss.properties");
        }
        return stream;
    }

    public static void start() {
        RUNTIME.startIT();
    }

    public static void stop() {
        if (Tracer.isActivated()) {
            Tracer.emitEvent((TraceEvent)TraceEvent.AGENT_STOP);
        }
        RUNTIME.stopIT(true);
        Iterator<AgentInterface<?>> itfs = INTERFACES.iterator();
        while (itfs.hasNext()) {
            AgentInterface<?> itf = itfs.next();
            itf.stop();
            itfs.remove();
        }
        if (Tracer.isActivated()) {
            Tracer.emitEventEnd((TraceEvent)TraceEvent.AGENT_STOP);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long runTask(COMPSsConstants.Lang lang, CoreElementDefinition ced, String ceiClass, ApplicationParameter[] arguments, ApplicationParameter target, ApplicationParameter[] results, AppMonitor monitor, OnFailure onFailure) throws AgentException {
        if (Tracer.isActivated()) {
            Tracer.emitEvent((TraceEvent)TraceEvent.AGENT_RUN_TASK);
        }
        COMPSsRuntimeImpl cOMPSsRuntimeImpl = RUNTIME;
        synchronized (cOMPSsRuntimeImpl) {
        }
        Long appId = RUNTIME.registerApplication(ceiClass, (ApplicationRunner)monitor);
        monitor.setAppId(appId);
        LOGGER.debug("New request to run as a " + lang + " task " + ced.getCeSignature());
        LOGGER.debug("appId: " + appId);
        LOGGER.debug("Core Element Description: " + ced.toString());
        LOGGER.debug("Parallelizing application according to " + ceiClass);
        LOGGER.debug("Parameters: ");
        for (ApplicationParameter applicationParameter : arguments) {
            LOGGER.debug("\t* " + applicationParameter);
        }
        try {
            int paramsCount = arguments.length;
            if (target != null) {
                ++paramsCount;
            }
            Object[] params = new Object[9 * (paramsCount += results.length)];
            int position = 0;
            LOGGER.debug("Handles parameters:");
            for (ApplicationParameter param : arguments) {
                LOGGER.debug("\t Parameter:" + param.getParamName());
                Agent.processParameter(appId, param, position, params);
                position += 9;
            }
            if (target != null) {
                LOGGER.debug("\t Target:" + target.getParamName());
                Agent.processParameter(appId, target, position, params);
                position += 9;
            }
            for (ApplicationParameter param : results) {
                Object value = DataType.FILE_T.equals((Object)param.getType()) ? UUID.randomUUID().toString() : new Object();
                Agent.addTaskParameter(value, param, position, params);
                position += 9;
            }
            onFailure = OnFailure.FAIL;
            RUNTIME.registerCoreElement(ced);
            int n = 1;
            RUNTIME.executeTask(appId, lang, true, null, null, ced.getCeSignature(), onFailure, 0, false, n, false, 0, false, false, target != null, Integer.valueOf(results.length), paramsCount, params);
        }
        catch (Exception e) {
            LOGGER.error("Error submitting task", (Throwable)e);
            throw new AgentException(e);
        }
        finally {
            if (Tracer.isActivated()) {
                Tracer.emitEventEnd((TraceEvent)TraceEvent.AGENT_RUN_TASK);
            }
        }
        return appId;
    }

    private static String processCollParamValue(ApplicationParameterCollection<ApplicationParameter> param, Long appId, String colName) throws Exception {
        int collSize = param.getCollectionParameters().size();
        StringBuilder sb = new StringBuilder();
        sb.append(colName).append(" ");
        sb.append(collSize).append(" ");
        sb.append(param.getContentType()).append(" ");
        List<ApplicationParameter> subParams = param.getCollectionParameters();
        for (int i = 0; i < subParams.size(); ++i) {
            String paramValue;
            ApplicationParameter subParam = subParams.get(i);
            sb.append(subParam.getType().ordinal()).append(" ");
            if (subParam.getType() == DataType.COLLECTION_T) {
                String subParamName = colName + "_" + i;
                ApplicationParameterCollection collSubParam = (ApplicationParameterCollection)subParam;
                paramValue = Agent.processCollParamValue(collSubParam, appId, subParamName);
            } else {
                paramValue = subParam.getValueContent().toString() + " " + subParam.getContentType();
            }
            sb.append(paramValue).append(" ");
            RemoteDataInformation remote = subParam.getRemoteData();
            if (remote == null) continue;
            Object stub = subParam.getType() == DataType.FILE_T ? subParam.getValueContent() : paramValue;
            Agent.addRemoteData(remote);
            RUNTIME.registerData(appId, subParam.getType(), stub, remote.getRenaming());
        }
        return sb.toString();
    }

    private static Object processParamValue(Long appId, int position, ApplicationParameter param) throws Exception {
        Object stub;
        RemoteDataInformation remote = param.getRemoteData();
        if (remote == null && param.getType() != DataType.COLLECTION_T) {
            LOGGER.debug("\t\tUsing value passed in as parameter");
            return param.getValueContent();
        }
        if (param.getType() == DataType.FILE_T) {
            stub = param.getValueContent();
        } else {
            stub = "app_" + appId + "_param" + position;
            if (param.getType() == DataType.COLLECTION_T) {
                ApplicationParameterCollection collSubParam = (ApplicationParameterCollection)param;
                stub = Agent.processCollParamValue(collSubParam, appId, (String)stub);
            }
        }
        if (remote != null) {
            Agent.addRemoteData(remote);
            RUNTIME.registerData(appId, param.getType(), stub, remote.getRenaming());
        }
        return stub;
    }

    private static void processParameter(Long appId, ApplicationParameter param, int position, Object[] arguments) throws AgentException, Exception {
        Object value = Agent.processParamValue(appId, position, param);
        Agent.addTaskParameter(value, param, position, arguments);
    }

    private static void addTaskParameter(Object value, ApplicationParameter param, int position, Object[] arguments) throws AgentException, Exception {
        arguments[position] = value;
        arguments[position + 1] = param.getType();
        arguments[position + 2] = param.getDirection();
        arguments[position + 3] = param.getStdIOStream();
        arguments[position + 4] = param.getPrefix();
        arguments[position + 5] = param.getParamName();
        arguments[position + 6] = param.getContentType();
        arguments[position + 7] = Double.toString(param.getWeight());
        arguments[position + 8] = param.isKeepRename();
    }

    public static es.bsc.compss.types.resources.Resource getNodeForResource(Resource<?, ?> r) throws AgentException {
        if (r == null) {
            return null;
        }
        String workerName = r.getName();
        Worker host = ResourceManager.getWorker((String)workerName);
        if (host == null) {
            MethodResourceDescription mrd = r.getDescription();
            String adaptor = r.getAdaptor();
            HashMap<String, Object> projectConf = new HashMap<String, Object>();
            projectConf.put("Properties", r.getProjectConf());
            HashMap<String, Object> resourcesConf = new HashMap<String, Object>();
            resourcesConf.put("Properties", r.getResourceConf());
            host = Agent.registerWorker(workerName, mrd, adaptor, projectConf, resourcesConf);
        }
        return host;
    }

    private static void addRemoteData(RemoteDataInformation remote) throws AgentException {
        int addedSources = 0;
        LogicalData ld = Comm.getData((String)remote.getRenaming());
        String otherDataNameInLocal = null;
        LinkedList<DataLocation> locations = new LinkedList<DataLocation>();
        for (RemoteDataLocation remoteDataLocation : remote.getSources()) {
            if (remoteDataLocation == null) continue;
            try {
                DataLocation dl = null;
                if (remoteDataLocation.getType() == RemoteDataLocation.Type.SHARED) {
                    SharedRemoteDataLocation sloc = (SharedRemoteDataLocation)remoteDataLocation;
                    String diskName = sloc.getDiskName();
                    String pathOnDisk = sloc.getPathOnDisk();
                    for (SharedRemoteDataLocation.Mountpoint mp : sloc.getMountpoints()) {
                        Resource<?, ?> r = mp.getResource();
                        es.bsc.compss.types.resources.Resource host = Agent.getNodeForResource(r);
                        host.addSharedDisk(diskName, mp.getPath());
                    }
                    String sPath = ProtocolType.SHARED_URI.getSchema() + diskName + File.separator + pathOnDisk;
                    SimpleURI resultURI = new SimpleURI(sPath);
                    dl = DataLocation.createLocation(null, (SimpleURI)resultURI);
                } else {
                    PrivateRemoteDataLocation ploc = (PrivateRemoteDataLocation)remoteDataLocation;
                    String path = ploc.getPath();
                    SimpleURI uri = new SimpleURI(path);
                    Resource<?, ?> r = ploc.getResource();
                    if (r != null) {
                        String name;
                        LogicalData localData;
                        es.bsc.compss.types.resources.Resource host = Agent.getNodeForResource(r);
                        if (host == Comm.getAppHost() && (localData = Comm.getData((String)(name = uri.getPath()))) != null) {
                            otherDataNameInLocal = name;
                            ++addedSources;
                            continue;
                        }
                        dl = DataLocation.createLocation((es.bsc.compss.types.resources.Resource)host, (SimpleURI)uri);
                    }
                }
                if (dl == null) continue;
                locations.add(dl);
            }
            catch (AgentException | IOException e) {
                LOGGER.warn("Exception adding remote data", (Throwable)e);
            }
        }
        if (ld == null) {
            if (otherDataNameInLocal == null) {
                ld = Comm.registerData((String)remote.getRenaming());
            } else {
                try {
                    ld = Comm.linkData(otherDataNameInLocal, (String)remote.getRenaming());
                }
                catch (CommException ce) {
                    ErrorManager.error((String)("Could not link " + remote.getRenaming() + " and " + otherDataNameInLocal), (Exception)((Object)ce));
                }
                ++addedSources;
            }
        }
        for (DataLocation dataLocation : locations) {
            ld.addLocation(dataLocation);
            ++addedSources;
        }
        if (addedSources == 0) {
            throw new AgentException("Could not add any source for data " + remote.getRenaming());
        }
    }

    public static void addResources(Resource<?, ?> r) throws AgentException {
        if (Tracer.isActivated()) {
            Tracer.emitEvent((TraceEvent)TraceEvent.AGENT_ADD_RESOURCE);
        }
        String workerName = r.getName();
        MethodResourceDescription description = r.getDescription();
        DynamicMethodWorker worker = ResourceManager.getDynamicResource((String)workerName);
        if (worker != null) {
            ResourceManager.increasedDynamicWorker((DynamicMethodWorker)worker, (MethodResourceDescription)description);
        } else {
            String adaptor = r.getAdaptor();
            HashMap<String, Object> projectConf = new HashMap<String, Object>();
            projectConf.put("Properties", r.getProjectConf());
            HashMap<String, Object> resourcesConf = new HashMap<String, Object>();
            resourcesConf.put("Properties", r.getResourceConf());
            Agent.registerWorker(workerName, description, adaptor, projectConf, resourcesConf);
        }
        if (Tracer.isActivated()) {
            Tracer.emitEventEnd((TraceEvent)TraceEvent.AGENT_ADD_RESOURCE);
        }
    }

    private static DynamicMethodWorker registerWorker(String workerName, MethodResourceDescription description, String adaptor, Map<String, Object> projectConf, Map<String, Object> resourcesConf) throws AgentException {
        MethodConfiguration mc;
        if (description == null) {
            description = new MethodResourceDescription();
        }
        try {
            mc = (MethodConfiguration)Comm.constructConfiguration((String)adaptor, projectConf, resourcesConf);
        }
        catch (ConstructConfigurationException e) {
            throw new AgentException(e.getMessage(), e);
        }
        int limitOfTasks = mc.getLimitOfTasks();
        int computingUnits = description.getTotalCPUComputingUnits();
        if (limitOfTasks < 0 && computingUnits < 0) {
            mc.setLimitOfTasks(0);
            mc.setTotalComputingUnits(0);
        } else {
            mc.setLimitOfTasks(Math.max(limitOfTasks, computingUnits));
            mc.setTotalComputingUnits(Math.max(limitOfTasks, computingUnits));
        }
        mc.setLimitOfGPUTasks(description.getTotalGPUComputingUnits());
        mc.setTotalGPUComputingUnits(description.getTotalGPUComputingUnits());
        mc.setLimitOfFPGATasks(description.getTotalFPGAComputingUnits());
        mc.setTotalFPGAComputingUnits(description.getTotalFPGAComputingUnits());
        mc.setLimitOfOTHERsTasks(description.getTotalOTHERComputingUnits());
        mc.setTotalOTHERComputingUnits(description.getTotalOTHERComputingUnits());
        mc.setHost(workerName);
        DynamicMethodWorker worker = new DynamicMethodWorker(workerName, description, mc, new HashMap());
        ResourceManager.addDynamicWorker((DynamicMethodWorker)worker, (MethodResourceDescription)description);
        return worker;
    }

    public static void removeResources(String workerName, MethodResourceDescription reduction) throws AgentException {
        DynamicMethodWorker worker;
        if (Tracer.isActivated()) {
            Tracer.emitEvent((TraceEvent)TraceEvent.AGENT_REMOVE_RESOURCES);
        }
        if ((worker = ResourceManager.getDynamicResource((String)workerName)) == null) {
            throw new AgentException("Resource " + workerName + " was not set up for this agent. Ignoring request.");
        }
        ResourceManager.requestWorkerReduction((DynamicMethodWorker)worker, (MethodResourceDescription)reduction);
        if (Tracer.isActivated()) {
            Tracer.emitEventEnd((TraceEvent)TraceEvent.AGENT_REMOVE_RESOURCES);
        }
    }

    public static void removeNode(String workerName) throws AgentException {
        if (Tracer.isActivated()) {
            Tracer.emitEvent((TraceEvent)TraceEvent.AGENT_REMOVE_RESOURCES);
        }
        try {
            ResourceManager.requestWholeWorkerReduction((String)workerName);
        }
        catch (NullPointerException e) {
            throw new AgentException("Resource " + workerName + " was not set up for this agent. Ignoring request.");
        }
        finally {
            if (Tracer.isActivated()) {
                Tracer.emitEventEnd((TraceEvent)TraceEvent.AGENT_REMOVE_RESOURCES);
            }
        }
    }

    public static void lostNode(String workerName) throws AgentException {
        try {
            ResourceManager.notifyWholeWorkerReduction((String)workerName);
        }
        catch (NullPointerException e) {
            throw new AgentException("Resource " + workerName + " was not set up for this agent. Ignoring request.");
        }
    }

    public static final void startInterface(AgentInterfaceConfig conf) throws ClassNotFoundException, InstantiationException, IllegalAccessException, AgentException {
        AgentInterface<?> itf = conf.getAgentInterface();
        itf.start(conf);
        INTERFACES.add(itf);
    }

    private static AgentInterfaceConfig getInterfaceConfig(String className, JSONObject arguments) throws ClassNotFoundException, InstantiationException, IllegalAccessException, AgentException {
        Class<?> agentClass = Class.forName(className);
        AgentInterface itf = (AgentInterface)agentClass.newInstance();
        return itf.configure(arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void main(String[] args) throws Exception {
        LinkedList<AgentInterfaceConfig> agents = new LinkedList<AgentInterfaceConfig>();
        String agentConfig = System.getProperty("compss.agent.configpath");
        if (agentConfig != null && !agentConfig.isEmpty()) {
            LOGGER.info("Reading Agent config from " + agentConfig);
            File configFile = new File(agentConfig);
            if (configFile.exists()) {
                String configString = new String(Files.readAllBytes(configFile.toPath()));
                JSONArray array = new JSONArray(configString);
                for (int i = 0; i < array.length(); ++i) {
                    JSONObject jo = array.getJSONObject(i);
                    try {
                        String interfaceClass = jo.getString("AGENT_IMPL");
                        JSONObject conf = jo.getJSONObject("CONF");
                        LOGGER.info("Loading " + interfaceClass + "'s agent interface");
                        AgentInterfaceConfig aic = Agent.getInterfaceConfig(interfaceClass, conf);
                        agents.add(aic);
                        continue;
                    }
                    catch (Exception e) {
                        ErrorManager.warn((String)("Unexpected format for agent config: " + jo));
                    }
                }
            } else {
                ErrorManager.warn((String)("Could not find the agent configuration file " + agentConfig));
            }
        }
        COMPSsRuntimeImpl cOMPSsRuntimeImpl = RUNTIME;
        synchronized (cOMPSsRuntimeImpl) {
            for (String arg : args) {
                try {
                    JSONObject jo = new JSONObject(arg);
                    String interfaceClass = jo.getString("AGENT_IMPL");
                    JSONObject conf = jo.getJSONObject("CONF");
                    LOGGER.info("Loading " + agentConfig + "'s agent interface");
                    AgentInterfaceConfig aic = Agent.getInterfaceConfig(interfaceClass, conf);
                    agents.add(aic);
                }
                catch (Exception e) {
                    ErrorManager.warn((String)("Unexpected format for agent config: " + arg));
                }
            }
            for (AgentInterfaceConfig agent : agents) {
                try {
                    Agent.startInterface(agent);
                }
                catch (Exception e) {
                    ErrorManager.warn((String)"Could not start Agent", (Exception)e);
                }
            }
            if (INTERFACES.isEmpty()) {
                ErrorManager.fatal((String)"Could not start any interface");
            }
            Agent.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void finishedApplication(long appId) {
        COMPSsRuntimeImpl cOMPSsRuntimeImpl = RUNTIME;
        synchronized (cOMPSsRuntimeImpl) {
        }
        RUNTIME.deregisterApplication(Long.valueOf(appId));
    }

    static {
        Agent.setAgentProperties();
        LoggerManager.init();
        LOGGER.info("Initializing agent with name: " + AGENT_NAME);
        boolean tracing = System.getProperty("compss.tracing") != null && Boolean.parseBoolean(System.getProperty("compss.tracing"));
        boolean tracingTaskDep = Boolean.parseBoolean(System.getProperty("compss.tracing.task.dependencies"));
        String installDir = System.getenv("COMPSS_HOME");
        Tracer.init((boolean)tracing, (int)0, (String)"master", (String)installDir, (boolean)tracingTaskDep);
        if (Tracer.isActivated()) {
            Tracer.emitEvent((TraceEvent)TraceEvent.STATIC_IT);
        }
        String dcConfigPath = System.getProperty("dataclay.configpath");
        LOGGER.debug("DataClay configuration: " + dcConfigPath);
        if (dcConfigPath != null) {
            try {
                StorageItf.init((String)dcConfigPath);
            }
            catch (StorageException se) {
                se.printStackTrace(System.err);
                System.err.println("Continuing...");
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        StorageItf.finish();
                    }
                    catch (StorageException se) {
                        se.printStackTrace(System.err);
                        System.err.println("Continuing...");
                    }
                }
            });
        }
        RUNTIME = new COMPSsRuntimeImpl();
        LOGGER.debug("Executing Agent");
        try {
            Thread.sleep(200L);
        }
        catch (Exception e) {
            LOGGER.debug("");
        }
        ErrorHandler feh = new ErrorHandler(){

            public boolean handleError() {
                LOGGER.info("Error raised. Please, check runtime.log");
                return false;
            }

            public boolean handleFatalError() {
                LOGGER.info("Fatal error for an application raised. Please, check runtime.log");
                return false;
            }
        };
        ErrorManager.init((ErrorHandler)feh);
        RUNTIME.setObjectRegistry(new ObjectRegistry((LoaderAPI)RUNTIME));
        RUNTIME.setStreamRegistry(new StreamRegistry((LoaderAPI)RUNTIME));
        INTERFACES = new LinkedList();
    }
}

