/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.checkpoint;

import es.bsc.compss.checkpoint.CheckpointGroup;
import es.bsc.compss.checkpoint.CheckpointManager;
import es.bsc.compss.checkpoint.CheckpointRecord;
import es.bsc.compss.checkpoint.CheckpointUtils;
import es.bsc.compss.checkpoint.types.CheckpointGroupImpl;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.DataVersion;
import es.bsc.compss.types.data.accessid.RWAccessId;
import es.bsc.compss.types.data.accessid.WAccessId;
import es.bsc.compss.types.parameter.CollectiveParameter;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.tracing.TraceEvent;
import es.bsc.compss.util.Tracer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class CheckpointManagerImpl
extends CheckpointRecord
implements CheckpointManager,
CheckpointUtils {
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Components.TaskProcessor.CheckpointManager");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static final String PERIOD_TIME = "period.time";
    private static final String FINISHED_TASKS = "finished.tasks";
    private static final String INSTANTIATED_GROUP = "instantiated.group";
    private static final String AVOID_CHECKPOINT = "avoid.checkpoint";
    private static final int DEF_GROUP_SIZE = 3;
    private int finishedTasksCounter = 0;
    protected int finishedTasksSpan = 0;
    private long time = 0L;
    protected int defGroup = -1;
    protected int countingGroup = 1;
    protected int groupSize = 0;
    private Timer timer = null;
    private final HashSet<String> avoidCheckpointTasks = new HashSet();
    private final HashMap<String, CheckpointGroupImpl> openGroups = new HashMap();

    public CheckpointManagerImpl(HashMap<String, String> config, long time, int finishedTasksSpan, CheckpointManager.User cpUser) {
        super(cpUser);
        this.setConfig(config, time, finishedTasksSpan);
    }

    public final void newTask(Task t) {
        if (Tracer.isActivated()) {
            Tracer.emitEvent((TraceEvent)TraceEvent.CHECKPOINT_NEW_TASK);
        }
        if (this.isTaskCheckpointed(t)) {
            this.recoverTask(t);
            if (DEBUG) {
                LOGGER.debug("Task " + t.getId() + " was recovered from a previous checkpoint");
            }
        } else {
            String signature = t.getTaskDescription().getCoreElement().getSignature();
            if (this.avoidCheckpointTasks.contains(signature)) {
                if (DEBUG) {
                    LOGGER.debug("Task " + t.getId() + " checkpointing ignored due to signature " + signature);
                }
            } else {
                this.assignTaskToGroup(t);
                this.registerTask(t);
                if (DEBUG) {
                    LOGGER.debug("Task " + t.getId() + " will be checkpointed.");
                }
            }
        }
        if (Tracer.isActivated()) {
            Tracer.emitEventEnd((TraceEvent)TraceEvent.CHECKPOINT_NEW_TASK);
        }
    }

    protected abstract void assignTaskToGroup(Task var1);

    public final void endTask(Task t) {
        String signature;
        if (Tracer.isActivated()) {
            Tracer.emitEvent((TraceEvent)TraceEvent.CHECKPOINT_END_TASK);
        }
        if (!this.avoidCheckpointTasks.contains(signature = t.getTaskDescription().getCoreElement().getSignature())) {
            this.completedTask(t);
            CheckpointGroupImpl group = (CheckpointGroupImpl)t.getCheckpointGroup();
            if (group != null) {
                group.addFinishedTask(t);
                if (group.getState() == CheckpointGroupImpl.GroupState.CLOSED) {
                    List<DataVersion> allowedValues = group.getOutputData();
                    this.requestTaskCheckpoint(t, allowedValues);
                }
            }
            if (this.finishedTasksSpan != 0 || this.time != 0L) {
                ++this.finishedTasksCounter;
                if (this.finishedTasksCounter == this.finishedTasksSpan) {
                    this.requestSaveLastDataVersions();
                    this.finishedTasksCounter -= this.finishedTasksSpan;
                }
            }
        }
        if (Tracer.isActivated()) {
            Tracer.emitEventEnd((TraceEvent)TraceEvent.CHECKPOINT_NEW_TASK);
        }
    }

    public final void snapshot() {
        if (Tracer.isActivated()) {
            Tracer.emitEvent((TraceEvent)TraceEvent.CHECKPOINT_SNAPSHOT);
        }
        for (CheckpointGroupImpl group : this.openGroups.values()) {
            this.closeGroup(group);
        }
        this.openGroups.clear();
        --this.defGroup;
        if (Tracer.isActivated()) {
            Tracer.emitEventEnd((TraceEvent)TraceEvent.CHECKPOINT_SNAPSHOT);
        }
    }

    @Override
    public final CheckpointGroupImpl addTaskToGroup(Task t, String groupName) {
        CheckpointGroupImpl group = this.openGroups.get(groupName);
        if (group == null) {
            LOGGER.debug("Creating checkpoint group " + groupName);
            group = new CheckpointGroupImpl(groupName);
            this.openGroups.put(groupName, group);
        }
        t.setCheckpointGroup((CheckpointGroup)group);
        for (Parameter param : t.getParameters()) {
            this.registerTaskParameterInGroup(param, group);
        }
        if (DEBUG) {
            LOGGER.debug("Task " + t.getId() + " assigned to checkpoint group " + groupName);
        }
        group.addTask(t);
        return group;
    }

    private void registerTaskParameterInGroup(Parameter param, CheckpointGroupImpl group) {
        DataType type;
        if (param.isCollective()) {
            CollectiveParameter cp = (CollectiveParameter)param;
            for (Parameter sp : cp.getElements()) {
                this.registerTaskParameterInGroup(sp, group);
            }
        }
        if ((type = param.getType()) == DataType.FILE_T || type == DataType.OBJECT_T || type == DataType.PSCO_T || type == DataType.EXTERNAL_PSCO_T || type == DataType.BINDING_OBJECT_T) {
            DependencyParameter dp = (DependencyParameter)param;
            this.registerTaskSimpleParameterInGroup(dp, group);
        }
    }

    private void registerTaskSimpleParameterInGroup(DependencyParameter dp, CheckpointGroupImpl group) {
        DataAccessId paramId = dp.getDataAccessId();
        DataVersion outDV = null;
        if (paramId instanceof RWAccessId) {
            outDV = ((RWAccessId)paramId).getWrittenDataVersion();
        } else if (paramId instanceof WAccessId) {
            outDV = ((WAccessId)paramId).getWrittenDataVersion();
        }
        if (outDV != null) {
            group.producesData(outDV);
        }
    }

    @Override
    public final void closeGroup(String groupName) {
        CheckpointGroupImpl group = this.openGroups.remove(groupName);
        if (group != null) {
            this.closeGroup(group);
        }
    }

    private void closeGroup(CheckpointGroupImpl group) {
        String groupName = group.getName();
        LOGGER.debug("Closing checkpoint group " + groupName);
        if (group.getState() == CheckpointGroupImpl.GroupState.CLOSED) {
            if (DEBUG) {
                LOGGER.warn("Checkpoint group " + groupName + " already closed");
            }
        } else {
            group.close();
            for (Task t : group.getFinishedTasks()) {
                this.requestTaskCheckpoint(t, group.getOutputData());
            }
        }
    }

    public final void shutdown() {
        if (Tracer.isActivated()) {
            Tracer.emitEvent((TraceEvent)TraceEvent.CHECKPOINT_SHUTDOWN);
        }
        for (CheckpointGroupImpl group : this.openGroups.values()) {
            this.closeGroup(group);
        }
        this.openGroups.clear();
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.performAllCopies();
        if (Tracer.isActivated()) {
            Tracer.emitEventEnd((TraceEvent)TraceEvent.CHECKPOINT_SHUTDOWN);
        }
    }

    private void setConfig(HashMap<String, String> config, long time, int finishedTasksSpan) {
        if (config.size() > 0) {
            this.time = config.get(PERIOD_TIME) != null ? Long.parseLong(config.get(PERIOD_TIME)) : time;
            this.finishedTasksSpan = config.get(FINISHED_TASKS) != null ? Integer.parseInt(config.get(FINISHED_TASKS)) : finishedTasksSpan;
            int n = this.groupSize = config.get(INSTANTIATED_GROUP) != null ? Integer.parseInt(config.get(INSTANTIATED_GROUP)) : 3;
            if (config.get(AVOID_CHECKPOINT) != null) {
                String[] avoidCheckpoint = config.get(AVOID_CHECKPOINT).substring(1, config.get(AVOID_CHECKPOINT).length() - 1).split(",");
                Collections.addAll(this.avoidCheckpointTasks, avoidCheckpoint);
            }
        } else {
            this.time = time;
            this.finishedTasksSpan = finishedTasksSpan;
            this.groupSize = 3;
        }
        if (this.time > 0L) {
            this.setTimerPolicy();
        }
        if (DEBUG) {
            LOGGER.debug("Checkpoint configuration: \n\tTime Interval: " + this.time + "\n\tFinished Tasks Span: " + this.finishedTasksSpan + "\n\tGroup Size: " + this.groupSize + "\n");
        }
    }

    private void setTimerPolicy() {
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                CheckpointManagerImpl.this.requestSaveLastDataVersions();
            }
        }, this.time, this.time);
    }
}

