/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.checkpoint;

import es.bsc.compss.checkpoint.types.CheckpointCopy;
import es.bsc.compss.comm.Comm;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.Transferable;
import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.operation.FileTransferable;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CheckpointCopiesHandler {
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Components.TaskProcessor.CheckpointManager");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static final int CONCURRENT_COPIES_LIMIT = 5;
    private final LinkedList<CheckpointCopy> pendingCopies = new LinkedList();
    private int ongoingCopies = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestCopy(LogicalData data, DataLocation targetLocation, EventListener listener) {
        boolean doCopy = false;
        CheckpointCopiesHandler checkpointCopiesHandler = this;
        synchronized (checkpointCopiesHandler) {
            if (this.ongoingCopies < 5) {
                ++this.ongoingCopies;
                doCopy = true;
            } else {
                CheckpointCopy pc = new CheckpointCopy(data, targetLocation, listener);
                this.pendingCopies.add(pc);
            }
        }
        if (doCopy) {
            this.orderCopy(data, targetLocation, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completedCopy() {
        CheckpointCopy pr;
        CheckpointCopiesHandler checkpointCopiesHandler = this;
        synchronized (checkpointCopiesHandler) {
            pr = this.pendingCopies.poll();
            if (pr == null) {
                --this.ongoingCopies;
            }
        }
        if (pr != null) {
            this.orderCopy(pr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ignoreConcurrencyLimit() {
        CheckpointCopiesHandler checkpointCopiesHandler = this;
        synchronized (checkpointCopiesHandler) {
            this.ongoingCopies += this.pendingCopies.size();
            for (CheckpointCopy pr : this.pendingCopies) {
                this.orderCopy(pr);
            }
            this.pendingCopies.clear();
        }
    }

    private void orderCopy(CheckpointCopy pr) {
        this.orderCopy(pr.getData(), pr.getTargetLocation(), pr.getListener());
    }

    private void orderCopy(LogicalData srcData, DataLocation targetLocation, EventListener listener) {
        if (DEBUG) {
            LOGGER.debug("Ordering Checkpoint copy " + srcData + " to " + targetLocation);
        }
        Comm.getAppHost().getData(srcData, targetLocation, srcData, (Transferable)new FileTransferable(true), listener);
    }
}

