/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.checkpoint;

import es.bsc.compss.checkpoint.CheckpointCopiesHandler;
import es.bsc.compss.checkpoint.CheckpointManager;
import es.bsc.compss.checkpoint.types.CheckpointData;
import es.bsc.compss.checkpoint.types.CheckpointDataVersion;
import es.bsc.compss.checkpoint.types.CheckpointTask;
import es.bsc.compss.checkpoint.types.request.ap.CheckpointerDataCopyEndedRequest;
import es.bsc.compss.checkpoint.types.request.ap.CheckpointerDataCopyFailedRequest;
import es.bsc.compss.checkpoint.types.request.ap.CheckpointerSaveLastDataVersionsRequest;
import es.bsc.compss.comm.Comm;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.TaskState;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.DataInstanceId;
import es.bsc.compss.types.data.DataVersion;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.info.DataInfo;
import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.data.operation.DataOperation;
import es.bsc.compss.types.parameter.CollectiveParameter;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.request.ap.APRequest;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.tracing.TraceEvent;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.Tracer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CheckpointRecord {
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Components.TaskProcessor.CheckpointManager");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static final String SEPARATOR = "#";
    private static final String DEFAULT_CHECKPOINT_FILE_NAME = "checkpoint.cp";
    private static final String CHECKPOINT_FOLDER;
    private static final String NOT_SUPPORTED_TYPE_MSG = "Checkpoint does nor support parameter type ";
    private final String checkpointFile;
    private final PrintWriter checkpointAppender;
    private final CheckpointManager.User cpUser;
    private int numCopiesRequested;
    private final CheckpointCopiesHandler cpHandler;
    private boolean isNotifyNoCopies;
    private final Map<Integer, TaskState> checkpointedTasks;
    private final Map<Integer, CheckpointData> dataInfo;
    private final Map<String, CheckpointDataVersion> dataVersion;

    public CheckpointRecord(CheckpointManager.User user) {
        PrintWriter checkpointAppender;
        this.cpUser = user;
        this.isNotifyNoCopies = false;
        this.numCopiesRequested = 0;
        this.checkpointedTasks = new TreeMap<Integer, TaskState>();
        this.dataInfo = new HashMap<Integer, CheckpointData>();
        this.dataVersion = new HashMap<String, CheckpointDataVersion>();
        this.checkpointFile = CHECKPOINT_FOLDER + DEFAULT_CHECKPOINT_FILE_NAME;
        File cpFolder = new File(CHECKPOINT_FOLDER);
        if (cpFolder.exists()) {
            try {
                this.loadCheckpointFile(this.checkpointFile);
            }
            catch (FileNotFoundException e) {
                LOGGER.warn("Checkpoint file not found");
            }
            catch (Exception e) {
                LOGGER.warn("Error reading checkpoint file.", (Throwable)e);
            }
        } else if (cpFolder.mkdirs()) {
            LOGGER.debug("Created Checkpointing folder: " + CHECKPOINT_FOLDER);
        } else {
            ErrorManager.fatal((String)"Could not create the directory");
        }
        try {
            checkpointAppender = new PrintWriter(new FileWriter(this.checkpointFile, true));
        }
        catch (IOException ioe) {
            ErrorManager.fatal((String)"Could not create checkpoint file", (Exception)ioe);
            checkpointAppender = null;
        }
        this.checkpointAppender = checkpointAppender;
        this.cpHandler = new CheckpointCopiesHandler();
    }

    private void loadCheckpointFile(String cpFile) throws FileNotFoundException {
        File checkpoint = new File(cpFile);
        if (DEBUG) {
            LOGGER.debug("Loading checkpoint file " + cpFile);
        }
        Scanner reader = new Scanner(checkpoint);
        block8: while (reader.hasNextLine()) {
            String data = reader.nextLine();
            String[] splited = data.split(SEPARATOR);
            switch (splited[0]) {
                case "D": {
                    String dv = splited[1];
                    String location = splited[2];
                    DataType type = DataType.valueOf((String)splited[3]);
                    Boolean checkpointed = Boolean.valueOf(splited[4]);
                    CheckpointDataVersion cdvi = new CheckpointDataVersion(location, type, checkpointed);
                    this.dataVersion.put(dv, cdvi);
                    continue block8;
                }
                case "T": {
                    int taskId = Integer.parseInt(splited[1]);
                    TaskState state = TaskState.valueOf((String)splited[2]);
                    this.checkpointedTasks.put(taskId, state);
                    continue block8;
                }
            }
            LOGGER.warn("Unknown checkpoint record type" + data);
        }
        reader.close();
    }

    public final boolean isTaskCheckpointed(Task task) {
        TaskState state = this.checkpointedTasks.get(task.getId());
        return state == TaskState.FINISHED || state == TaskState.RECOVERED;
    }

    protected final void recoverTask(Task t) {
        t.setStatus(TaskState.RECOVERED);
        for (Parameter param : t.getParameters()) {
            if (!param.isPotentialDependency()) continue;
            this.recoverTaskParameter(param);
        }
    }

    private void recoverTaskParameter(Parameter param) {
        if (param.isCollective()) {
            CollectiveParameter cp = (CollectiveParameter)param;
            for (Parameter sp : cp.getElements()) {
                this.recoverTaskParameter(sp);
            }
        } else if (param.isPotentialDependency()) {
            DependencyParameter dp = (DependencyParameter)param;
            this.recoverTaskSimpleTaskParameter(dp);
        } else {
            LOGGER.warn(NOT_SUPPORTED_TYPE_MSG + param.getType());
        }
    }

    private void recoverTaskSimpleTaskParameter(DependencyParameter dp) {
        String location;
        DataInstanceId outDaId;
        String outRename;
        String shortRename;
        CheckpointDataVersion cdvi;
        DataAccessId paramId = dp.getDataAccessId();
        DataVersion outDV = null;
        if (paramId.isWrite()) {
            outDV = ((DataAccessId.WritingDataAccessId)paramId).getWrittenDataVersion();
        }
        if (outDV != null && (cdvi = this.dataVersion.get(shortRename = CheckpointRecord.getShortName(outRename = (outDaId = outDV.getDataInstanceId()).getRenaming()))) != null && (location = cdvi.getLocation()) != null) {
            DataVersion prevDV;
            SimpleURI resultUri = new SimpleURI(location);
            dp.setType(cdvi.getType());
            dp.setDataTarget(resultUri.toString());
            outDV.willBeRead();
            int outDataId = outDaId.getDataId();
            CheckpointData cpi = this.dataInfo.get(outDataId);
            if (cpi == null) {
                cpi = new CheckpointData();
                this.dataInfo.put(outDataId, cpi);
            } else if (paramId.getDirection() == DataAccessId.Direction.RW && (prevDV = cpi.getLastCheckpointedVersion()) != null) {
                prevDV.hasBeenRead();
            }
            cpi.setLastCheckpointedVersion(outDV);
            try {
                DataLocation dataLocation = DataLocation.createLocation((Resource)Comm.getAppHost(), (SimpleURI)resultUri);
                dataLocation.isCheckpointLocation(true);
                LogicalData ld = Comm.getData((String)outRename);
                ld.addLocation(dataLocation);
            }
            catch (IOException e) {
                e.printStackTrace();
                ErrorManager.warn((String)("ERROR: Invalid location URI " + resultUri), (Exception)e);
            }
        }
    }

    protected final void registerTask(Task t) {
        CheckpointTask ctl = new CheckpointTask(t, 0);
        for (Parameter param : t.getParameters()) {
            if (!(param instanceof DependencyParameter)) continue;
            this.registerTaskParameter(param, ctl);
        }
    }

    private void registerTaskParameter(Parameter param, CheckpointTask ctl) {
        if (param.isCollective()) {
            CollectiveParameter cp = (CollectiveParameter)param;
            for (Parameter sp : cp.getElements()) {
                this.registerTaskParameter(sp, ctl);
            }
        } else if (param.isPotentialDependency()) {
            DependencyParameter dp = (DependencyParameter)param;
            this.registerTaskSimpleParameter(dp, ctl);
        } else {
            LOGGER.warn(NOT_SUPPORTED_TYPE_MSG + param.getType());
        }
    }

    private void registerTaskSimpleParameter(DependencyParameter dp, CheckpointTask ctl) {
        String inRename;
        String shortRename;
        CheckpointDataVersion cdvl;
        DataAccessId paramId = dp.getDataAccessId();
        DataVersion outDV = null;
        if (paramId.isWrite()) {
            outDV = ((DataAccessId.WritingDataAccessId)paramId).getWrittenDataVersion();
        }
        if (outDV != null) {
            LOGGER.debug("Adding data " + outDV.getDataInstanceId().getRenaming() + " to task " + ctl.getTask().getId() + " checkpoint.");
            ctl.addOutputToCheckpoint();
            CheckpointDataVersion cdvi = new CheckpointDataVersion(outDV, ctl);
            DataInstanceId outDaId = outDV.getDataInstanceId();
            String outRename = outDaId.getRenaming();
            String shortRename2 = CheckpointRecord.getShortName(outRename);
            this.dataVersion.put(shortRename2, cdvi);
            outDV.willBeRead();
            outDV.willBeRead();
            int outDataId = outDaId.getDataId();
            CheckpointData cpi = this.dataInfo.get(outDataId);
            if (cpi == null) {
                cpi = new CheckpointData();
                this.dataInfo.put(outDataId, cpi);
            }
            cpi.setLastCheckpointedVersion(outDV);
        }
        DataInstanceId inDaId = null;
        if (paramId.isRead()) {
            inDaId = ((DataAccessId.ReadingDataAccessId)paramId).getReadDataInstance();
        }
        if (inDaId != null && (cdvl = this.dataVersion.get(shortRename = CheckpointRecord.getShortName(inRename = inDaId.getRenaming()))) != null) {
            ctl.addReadValue(cdvl);
            cdvl.addReader(ctl);
        }
    }

    protected final void completedTask(Task t) {
        for (Parameter param : t.getParameters()) {
            this.computedTaskParameter(param);
        }
        if (t.getStatus() == TaskState.RECOVERED) {
            this.checkpointedTasks.remove(t.getId());
        }
    }

    private void computedTaskParameter(Parameter param) {
        if (param.isCollective()) {
            CollectiveParameter cp = (CollectiveParameter)param;
            for (Parameter sp : cp.getElements()) {
                this.computedTaskParameter(sp);
            }
        } else if (param.isPotentialDependency()) {
            DependencyParameter dp = (DependencyParameter)param;
            this.computedTaskSimpleParameter(dp);
        } else {
            LOGGER.warn(NOT_SUPPORTED_TYPE_MSG + param.getType());
        }
    }

    private void computedTaskSimpleParameter(DependencyParameter dp) {
        DataAccessId paramId = dp.getDataAccessId();
        if (paramId.isWrite()) {
            int dataId = paramId.getDataId();
            this.registerLastCompletedProducer(dataId, dp);
        }
    }

    private void registerLastCompletedProducer(Integer dataId, DependencyParameter dp) {
        CheckpointData cdi = this.dataInfo.get(dataId);
        if (cdi == null) {
            cdi = new CheckpointData();
            this.dataInfo.put(dataId, cdi);
        }
        cdi.setLastCompletedProducer((Parameter)dp);
    }

    protected final void requestTaskCheckpoint(Task t, List<DataVersion> allowed) {
        for (Parameter param : t.getParameters()) {
            this.requestTaskParameterCheckpoint(param, allowed);
        }
    }

    private void requestTaskParameterCheckpoint(Parameter param) {
        if (param.isCollective()) {
            CollectiveParameter cp = (CollectiveParameter)param;
            for (Parameter sp : cp.getElements()) {
                this.requestTaskParameterCheckpoint(sp);
            }
        } else if (param.isPotentialDependency()) {
            DependencyParameter dp = (DependencyParameter)param;
            this.requestTaskSimpleParameterCheckpoint(dp);
        } else {
            LOGGER.warn(NOT_SUPPORTED_TYPE_MSG + param.getType());
        }
    }

    private void requestTaskParameterCheckpoint(Parameter param, List<DataVersion> allowed) {
        if (param.isCollective()) {
            CollectiveParameter cp = (CollectiveParameter)param;
            for (Parameter sp : cp.getElements()) {
                this.requestTaskParameterCheckpoint(sp, allowed);
            }
        } else if (param.isPotentialDependency()) {
            DependencyParameter dp = (DependencyParameter)param;
            this.requestTaskSimpleParameterCheckpoint(dp, allowed);
        } else {
            LOGGER.warn(NOT_SUPPORTED_TYPE_MSG + param.getType());
        }
    }

    private void requestTaskSimpleParameterCheckpoint(DependencyParameter dp) {
        DataInstanceId outDaId;
        String outRename;
        String shortRename;
        CheckpointDataVersion cdvi;
        DataAccessId paramId = dp.getDataAccessId();
        DataVersion outDV = null;
        if (paramId.isWrite()) {
            outDV = ((DataAccessId.WritingDataAccessId)paramId).getWrittenDataVersion();
        }
        if (outDV != null && (cdvi = this.dataVersion.get(shortRename = CheckpointRecord.getShortName(outRename = (outDaId = outDV.getDataInstanceId()).getRenaming()))) != null && !cdvi.getCheckpointRequested().booleanValue()) {
            DataType type = dp.getType();
            cdvi.generatedData(ProtocolType.FILE_URI.getSchema() + CHECKPOINT_FOLDER + outRename, type);
            this.saveData(outDaId, cdvi);
        }
    }

    private void requestTaskSimpleParameterCheckpoint(DependencyParameter dp, List<DataVersion> allowed) {
        DataInstanceId outDaId;
        String outRename;
        String shortRename;
        CheckpointDataVersion cdvi;
        DataAccessId paramId = dp.getDataAccessId();
        DataVersion outDV = null;
        if (paramId.isWrite()) {
            outDV = ((DataAccessId.WritingDataAccessId)paramId).getWrittenDataVersion();
        }
        if (outDV != null && allowed.contains(outDV) && (cdvi = this.dataVersion.get(shortRename = CheckpointRecord.getShortName(outRename = (outDaId = outDV.getDataInstanceId()).getRenaming()))) != null && !cdvi.getCheckpointRequested().booleanValue()) {
            DataType type = dp.getType();
            cdvi.generatedData(ProtocolType.FILE_URI.getSchema() + CHECKPOINT_FOLDER + outRename, type);
            this.saveData(outDaId, cdvi);
        }
    }

    private void saveData(DataInstanceId daId, CheckpointDataVersion cdvi) {
        DataLocation targetLocation = null;
        try {
            SimpleURI targetURI = new SimpleURI(cdvi.getLocation());
            targetLocation = DataLocation.createLocation((Resource)Comm.getAppHost(), (SimpleURI)targetURI);
            targetLocation.isCheckpointLocation(true);
        }
        catch (IOException ioe) {
            ErrorManager.error((String)("ERROR: Invalid location URI " + CHECKPOINT_FOLDER), (Exception)ioe);
        }
        cdvi.setCheckpointRequested();
        CheckpointCopyListener dataListener = new CheckpointCopyListener(cdvi);
        LogicalData srcData = daId.getData();
        ++this.numCopiesRequested;
        this.cpHandler.requestCopy(srcData, targetLocation, dataListener);
    }

    public final void dataCheckpointed(CheckpointDataVersion cdvi) {
        DataVersion dv = cdvi.getVersion();
        if (DEBUG) {
            LOGGER.warn("Checkpointing copy for  " + dv.getDataInstanceId().getRenaming() + " completed.");
        }
        this.commitDataVersionCheckpoint(cdvi);
        dv.hasBeenRead();
        CheckpointData di = this.dataInfo.get(cdvi.getDataId());
        DataVersion prevCPVersion = di.getLastCheckpointedVersion();
        if (prevCPVersion != null) {
            DataInstanceId daId = dv.getDataInstanceId();
            DataInstanceId prevDaId = prevCPVersion.getDataInstanceId();
            if (prevDaId.getVersionId() < daId.getVersionId() && prevCPVersion.hasBeenRead()) {
                String prevRenaming = prevDaId.getRenaming();
                if (DEBUG) {
                    LOGGER.debug("Removing previous checkpoint data" + prevRenaming);
                }
                Comm.removeData((String)prevRenaming, (boolean)true);
            }
        }
        di.addNotDeletedFinishedCopies();
        if (cdvi.valueCheckpointed()) {
            this.checkpointProducerTasks(cdvi);
        }
        --this.numCopiesRequested;
        if (this.isNotifyNoCopies && this.numCopiesRequested == 0) {
            this.cpUser.allAvailableDataCheckpointed();
            this.isNotifyNoCopies = false;
        }
    }

    public final void dataCheckpointFailed(CheckpointDataVersion cdvi) {
        DataVersion dv = cdvi.getVersion();
        LOGGER.warn("Checkpointing copy for  " + dv.getDataInstanceId().getRenaming() + " failed.");
        --this.numCopiesRequested;
        if (this.isNotifyNoCopies && this.numCopiesRequested == 0) {
            this.cpUser.allAvailableDataCheckpointed();
            this.isNotifyNoCopies = false;
        }
    }

    private void commitDataVersionCheckpoint(CheckpointDataVersion cdvi) {
        String shortName = CheckpointRecord.getShortName(cdvi.getVersion().getDataInstanceId().getRenaming());
        String location = cdvi.getLocation();
        DataType type = cdvi.getType();
        boolean checkpointRequested = cdvi.getCheckpointRequested();
        String dataRecord = "D#" + shortName + SEPARATOR + location + SEPARATOR + type + SEPARATOR + checkpointRequested;
        this.appendRecord(dataRecord);
    }

    private void checkpointProducerTasks(CheckpointDataVersion cdvi) {
        CheckpointTask producer = cdvi.getProducer();
        if (producer != null) {
            DataVersion dv = cdvi.getVersion();
            if (producer.checkpointedOutput()) {
                Task task = producer.getTask();
                this.commitTaskCheckpoint(task.getId(), task.getStatus());
                for (CheckpointDataVersion readValue : producer.getReadValues()) {
                    if (!readValue.readerCheckpointed(producer)) continue;
                    this.checkpointProducerTasks(readValue);
                }
            } else {
                LOGGER.debug("Task not checkpointed " + producer.getTask().getId() + " not checkpointed because there is output data pending to checkpoint");
            }
            this.deleteIntermidateVersionsRecursively(CheckpointRecord.getShortName(dv.getDataInstanceId().getRenaming()), true);
        } else {
            LOGGER.warn("Data " + cdvi.getDataId() + " not checkpointed because produces is null");
        }
    }

    private void commitTaskCheckpoint(Integer taskId, TaskState state) {
        if (DEBUG) {
            LOGGER.debug("Task " + taskId + " has been checkpointed.");
        }
        if (state == TaskState.FINISHED || state == TaskState.RECOVERED) {
            String taskRecord = "T#" + taskId + SEPARATOR + state;
            this.appendRecord(taskRecord);
        }
    }

    private void appendRecord(String record) {
        if (this.checkpointAppender != null) {
            this.checkpointAppender.println(record);
            this.checkpointAppender.flush();
        }
    }

    private void deleteIntermidateVersionsRecursively(String shortName, Boolean first) {
        DataInstanceId daId;
        int dataId;
        CheckpointData cdi;
        DataVersion version;
        CheckpointDataVersion cdvi = this.dataVersion.get(shortName);
        if (cdvi != null && (version = cdvi.getVersion()) != null && (cdi = this.dataInfo.get(dataId = (daId = version.getDataInstanceId()).getDataId())).getNotDeletedFinishedCopies() > 1) {
            if (cdvi.isCheckpointed().booleanValue() && cdvi.areReadersEmpty().booleanValue() && version.getNumberOfReaders() > 0 && daId.getVersionId() > 1) {
                if (first.booleanValue()) {
                    first = false;
                } else {
                    LogicalData ld = daId.getData();
                    if (version.hasBeenRead() && !ld.isAccessedByMain()) {
                        String renaming = daId.getRenaming();
                        if (DEBUG) {
                            LOGGER.debug("Removing data " + renaming + " because it became obsolete");
                        }
                        Comm.removeData((String)daId.getRenaming(), (boolean)true);
                        cdi.removeNotDeletedFinishedCopies();
                    }
                }
            }
            this.deleteIntermidateVersionsRecursively(this.getPreviousDv(shortName), first);
        }
    }

    public final void mainAccess(DataInstanceId di) {
        if (Tracer.isActivated()) {
            Tracer.emitEvent((TraceEvent)TraceEvent.CHECKPOINT_MAIN_ACCESS);
        }
        LogicalData ld = di.getData();
        ld.setAccessedByMain(true);
        if (Tracer.isActivated()) {
            Tracer.emitEventEnd((TraceEvent)TraceEvent.CHECKPOINT_MAIN_ACCESS);
        }
    }

    public final void deletedData(DataInfo data) {
        DataVersion dv;
        if (Tracer.isActivated()) {
            Tracer.emitEvent((TraceEvent)TraceEvent.CHECKPOINT_DELETE_DATA);
        }
        int dataId = data.getDataId();
        LOGGER.info("Deleting data " + dataId);
        CheckpointData cpi = this.dataInfo.get(dataId);
        if (cpi != null && (dv = data.getCurrentDataVersion()) != null && cpi.getLastCheckpointedVersion() != dv && dv.hasBeenRead()) {
            if (DEBUG) {
                LOGGER.debug("Checkpointer deleting obsolete data " + dv.getDataInstanceId().getRenaming());
            }
            Comm.removeData((String)dv.getDataInstanceId().getRenaming(), (boolean)true);
        }
        if (Tracer.isActivated()) {
            Tracer.emitEventEnd((TraceEvent)TraceEvent.CHECKPOINT_DELETE_DATA);
        }
    }

    protected final void requestSaveLastDataVersions() {
        CheckpointerSaveLastDataVersionsRequest request = new CheckpointerSaveLastDataVersionsRequest(this);
        this.cpUser.addCheckpointRequest((APRequest)request, "force checkpointing  all last data versions.");
    }

    public final void requestSaveAllLastDataVersion() {
        if (this.dataInfo.size() > 0) {
            for (CheckpointData cdi : this.dataInfo.values()) {
                Parameter param = cdi.getLastCompletedProducer();
                if (param == null) continue;
                DependencyParameter dp = (DependencyParameter)param;
                this.requestTaskParameterCheckpoint((Parameter)dp);
            }
        }
    }

    protected final void performAllCopies() {
        if (this.numCopiesRequested > 0) {
            this.cpHandler.ignoreConcurrencyLimit();
            this.isNotifyNoCopies = true;
        } else {
            this.cpUser.allAvailableDataCheckpointed();
        }
    }

    private String getPreviousDv(String shortName) {
        List<String> dataAndVersion = Arrays.asList(shortName.split("v"));
        return dataAndVersion.get(0) + "v" + (Integer.valueOf(dataAndVersion.get(1)) - 1);
    }

    private static String getShortName(String rename) {
        return rename.substring(0, rename.indexOf("_"));
    }

    static {
        String folder = System.getProperty("compss.checkpoint.folder");
        if (!folder.endsWith(File.separator)) {
            folder = folder + File.separator;
        }
        CHECKPOINT_FOLDER = folder;
    }

    private class CheckpointCopyListener
    extends EventListener {
        private final CheckpointDataVersion cdvi;

        public CheckpointCopyListener(CheckpointDataVersion cdvl) {
            this.cdvi = cdvl;
        }

        public void notifyEnd(DataOperation fOp) {
            CheckpointRecord.this.cpHandler.completedCopy();
            CheckpointerDataCopyEndedRequest request = new CheckpointerDataCopyEndedRequest(CheckpointRecord.this, this.cdvi);
            String dataRenaming = this.cdvi.getVersion().getDataInstanceId().getRenaming();
            CheckpointRecord.this.cpUser.addCheckpointRequest((APRequest)request, "checkpoint copy completion notification for data " + dataRenaming);
        }

        public void notifyFailure(DataOperation fOp, Exception e) {
            CheckpointRecord.this.cpHandler.completedCopy();
            CheckpointerDataCopyFailedRequest request = new CheckpointerDataCopyFailedRequest(CheckpointRecord.this, this.cdvi);
            String dataRenaming = this.cdvi.getVersion().getDataInstanceId().getRenaming();
            CheckpointRecord.this.cpUser.addCheckpointRequest((APRequest)request, "checkpoint copy failure notification for data " + dataRenaming);
        }
    }
}

