/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.checkpoint.types.request.ap;

import es.bsc.compss.checkpoint.CheckpointRecord;
import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.TaskAnalyser;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.types.request.ap.APRequest;
import es.bsc.compss.types.request.exceptions.ShutdownException;
import es.bsc.compss.types.tracing.TraceEvent;
import es.bsc.compss.types.tracing.TraceEventType;
import es.bsc.compss.util.Tracer;
import es.bsc.compss.worker.COMPSsException;

public abstract class CheckpointerRequest
extends APRequest {
    private final CheckpointRecord cp;

    public CheckpointerRequest(CheckpointRecord cp) {
        this.cp = cp;
    }

    public TraceEvent getEvent() {
        return TraceEvent.AP_CHECKPOINT_REQUEST;
    }

    public abstract TraceEvent getCheckpointEvent();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(AccessProcessor ap, TaskAnalyser ta, TaskDispatcher td) throws ShutdownException, COMPSsException {
        if (Tracer.isActivated()) {
            Tracer.emitEvent((TraceEvent)this.getCheckpointEvent());
        }
        try {
            this.process(ap, ta, td, this.cp);
        }
        finally {
            if (Tracer.isActivated()) {
                Tracer.emitEventEnd((TraceEventType)TraceEventType.CHECKPOINT_EVENTS_TYPE);
            }
        }
    }

    public abstract void process(AccessProcessor var1, TaskAnalyser var2, TaskDispatcher var3, CheckpointRecord var4) throws ShutdownException, COMPSsException;
}

