/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.checkpoint.types;

import es.bsc.compss.checkpoint.types.CheckpointTask;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.info.DataVersion;
import java.util.LinkedList;
import java.util.List;

public class CheckpointDataVersion {
    private final DataVersion dataVersion;
    private String location;
    private DataType type;
    private Boolean checkpointRequested = false;
    private boolean checkpointed = false;
    private final CheckpointTask producer;
    private final List<CheckpointTask> readers;

    public CheckpointDataVersion(DataVersion dataVersion, CheckpointTask producer) {
        this.dataVersion = dataVersion;
        this.producer = producer;
        this.readers = new LinkedList<CheckpointTask>();
    }

    public CheckpointDataVersion(String location, DataType type, Boolean checkpointed) {
        this.location = location;
        this.type = type;
        this.producer = null;
        this.readers = new LinkedList<CheckpointTask>();
        this.dataVersion = null;
        this.checkpointRequested = checkpointed;
        this.checkpointed = checkpointed;
    }

    public boolean valueCheckpointed() {
        if (!this.checkpointed) {
            this.checkpointed = true;
            return true;
        }
        return false;
    }

    public boolean readerCheckpointed(CheckpointTask reader) {
        this.readers.remove(reader);
        if (!this.checkpointed && this.readers.isEmpty()) {
            return this.valueCheckpointed();
        }
        return false;
    }

    public void generatedData(String location, DataType type) {
        this.location = location;
        this.type = type;
    }

    public void addReader(CheckpointTask ctl) {
        this.readers.add(ctl);
    }

    public DataVersion getVersion() {
        return this.dataVersion;
    }

    public CheckpointTask getProducer() {
        return this.producer;
    }

    public String getLocation() {
        return this.location;
    }

    public DataType getType() {
        return this.type;
    }

    public int getDataId() {
        return this.dataVersion.getDataInstanceId().getDataId();
    }

    public Boolean getCheckpointRequested() {
        return this.checkpointRequested;
    }

    public void setCheckpointRequested() {
        this.checkpointRequested = true;
    }

    public Boolean isCheckpointed() {
        return this.checkpointed;
    }

    public Boolean areReadersEmpty() {
        return this.readers.isEmpty();
    }
}

