/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.checkpoint.types;

import es.bsc.compss.checkpoint.CheckpointGroup;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.data.info.DataVersion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CheckpointGroupImpl
implements CheckpointGroup {
    private final String name;
    private GroupState state;
    private final HashMap<Integer, DataVersion> outputData;
    private final Set<Task> finishedTasks;
    private final Set<Task> tasks;

    public CheckpointGroupImpl(String name) {
        this.name = name;
        this.state = GroupState.OPEN;
        this.tasks = new HashSet<Task>();
        this.outputData = new HashMap();
        this.finishedTasks = new HashSet<Task>();
    }

    public void producesData(DataVersion dv) {
        DataVersion dataId = this.outputData.get(dv.getDataInstanceId().getDataId());
        if (dataId != null) {
            if (dv.getDataInstanceId().getVersionId() > dataId.getDataInstanceId().getVersionId()) {
                this.outputData.put(dv.getDataInstanceId().getDataId(), dv);
            }
        } else {
            this.outputData.put(dv.getDataInstanceId().getDataId(), dv);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.tasks.size();
    }

    public GroupState getState() {
        return this.state;
    }

    public void close() {
        this.state = GroupState.CLOSED;
    }

    public void addTask(Task task) {
        this.tasks.add(task);
    }

    public Set<Task> getFinishedTasks() {
        return this.finishedTasks;
    }

    public void addFinishedTask(Task task) {
        this.finishedTasks.add(task);
    }

    public List<DataVersion> getOutputData() {
        return new ArrayList<DataVersion>(this.outputData.values());
    }

    public static enum GroupState {
        OPEN,
        CLOSED;

    }
}

