/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types.implementations;

import integratedtoolkit.ITConstants;
import integratedtoolkit.types.annotations.parameter.DataType;
import integratedtoolkit.types.implementations.Implementation;
import integratedtoolkit.types.parameter.Parameter;
import integratedtoolkit.types.resources.MethodResourceDescription;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class AbstractMethodImplementation
extends Implementation
implements Externalizable {
    private static final ITConstants.Lang LANG;

    public AbstractMethodImplementation() {
    }

    public AbstractMethodImplementation(Integer coreId, Integer implementationId, MethodResourceDescription annot) {
        super(coreId, implementationId, annot);
    }

    public static String getSignature(String declaringClass, String methodName, boolean hasTarget, boolean hasReturn, Parameter[] parameters) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(methodName).append("(");
        switch (LANG) {
            case JAVA: 
            case C: {
                int numPars = parameters.length;
                if (hasTarget) {
                    --numPars;
                }
                if (hasReturn) {
                    --numPars;
                }
                if (numPars <= 0) break;
                DataType type = parameters[0].getType();
                type = type == DataType.PSCO_T ? DataType.OBJECT_T : type;
                buffer.append(type);
                for (int i = 1; i < numPars; ++i) {
                    type = parameters[i].getType();
                    type = type == DataType.PSCO_T ? DataType.OBJECT_T : type;
                    buffer.append(",").append(type);
                }
                break;
            }
        }
        buffer.append(")").append(declaringClass);
        return buffer.toString();
    }

    @Override
    public Implementation.TaskType getTaskType() {
        return Implementation.TaskType.METHOD;
    }

    public abstract MethodType getMethodType();

    public abstract String getMethodDefinition();

    @Override
    public MethodResourceDescription getRequirements() {
        return (MethodResourceDescription)this.requirements;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
    }

    static {
        ITConstants.Lang l = ITConstants.Lang.JAVA;
        String langProperty = System.getProperty("it.lang");
        if (langProperty != null) {
            if (langProperty.equalsIgnoreCase("python")) {
                l = ITConstants.Lang.PYTHON;
            } else if (langProperty.equalsIgnoreCase("c")) {
                l = ITConstants.Lang.C;
            }
        }
        LANG = l;
    }

    public static enum MethodType {
        METHOD,
        MPI,
        OMPSS,
        OPENCL,
        BINARY,
        DECAF;

    }
}

