/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types.implementations;

import integratedtoolkit.types.implementations.AbstractMethodImplementation;
import integratedtoolkit.types.resources.MethodResourceDescription;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class BinaryImplementation
extends AbstractMethodImplementation
implements Externalizable {
    private String binary;
    private String workingDir;

    public BinaryImplementation() {
    }

    public BinaryImplementation(String binary, String workingDir, Integer coreId, Integer implementationId, MethodResourceDescription annot) {
        super(coreId, implementationId, annot);
        this.binary = binary;
        this.workingDir = workingDir;
    }

    public String getBinary() {
        return this.binary;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    @Override
    public AbstractMethodImplementation.MethodType getMethodType() {
        return AbstractMethodImplementation.MethodType.BINARY;
    }

    @Override
    public String getMethodDefinition() {
        StringBuilder sb = new StringBuilder();
        sb.append("[BINARY=").append(this.binary);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String toString() {
        return super.toString() + " Binary Method with binary " + this.binary;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.binary = (String)in.readObject();
        this.workingDir = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.binary);
        out.writeObject(this.workingDir);
    }
}

