/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.util;

import integratedtoolkit.types.exceptions.NonInstantiableException;
import integratedtoolkit.types.implementations.Implementation;
import integratedtoolkit.types.resources.ResourceDescription;
import integratedtoolkit.util.ErrorManager;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CoreManager {
    private static final Logger LOGGER = LogManager.getLogger((String)"integratedtoolkit.Components.TaskDispatcher");
    private static final String ERROR_INVALID_SIGNATURE = "Invalid signature. Skipping addition";
    private static final String ERROR_UNREGISTERED_CORE_ELEMENT = "Unregistered CoreElement. Skipping addition of ";
    private static final String ERROR_INVALID_IMPLS_SIGNS = "Attempting to register a different number of implementations and signatures. Skipping addition";
    private static final String WARN_REGISTERED_CORE_ELEMENT = "Already registered CoreElement. Skipping addition of ";
    private static final String WARN_UNREGISTERED_IMPL = "Unregistered implementation. Skipping addition";
    private static final List<List<Implementation>> IMPLEMENTATIONS = new LinkedList<List<Implementation>>();
    private static final List<List<String>> SIGNATURES = new LinkedList<List<String>>();
    private static final Map<String, Integer> SIGNATURE_TO_CORE_ID = new LinkedHashMap<String, Integer>();
    private static int coreCount = 0;

    private CoreManager() {
        throw new NonInstantiableException("CoreManager");
    }

    public static int getCoreCount() {
        return coreCount;
    }

    public static Integer registerNewCoreElement(String signature) {
        if (signature == null || signature.isEmpty()) {
            LOGGER.warn(ERROR_INVALID_SIGNATURE);
            return null;
        }
        Integer methodId = SIGNATURE_TO_CORE_ID.get(signature);
        if (methodId != null) {
            LOGGER.warn(WARN_REGISTERED_CORE_ELEMENT + signature);
            return null;
        }
        methodId = coreCount;
        ++coreCount;
        LinkedList impls = new LinkedList();
        IMPLEMENTATIONS.add(impls);
        LinkedList<String> signs = new LinkedList<String>();
        signs.add(signature);
        SIGNATURES.add(signs);
        SIGNATURE_TO_CORE_ID.put(signature, methodId);
        return methodId;
    }

    public static void registerNewImplementations(int coreId, List<Implementation> impls, List<String> signs) {
        if (coreId < 0 || coreId >= coreCount) {
            ErrorManager.error(ERROR_UNREGISTERED_CORE_ELEMENT + coreId);
            return;
        }
        if (impls.size() != signs.size()) {
            ErrorManager.error(ERROR_INVALID_IMPLS_SIGNS);
            return;
        }
        for (String signature : signs) {
            if (signature != null && !signature.isEmpty()) continue;
            ErrorManager.error(ERROR_INVALID_SIGNATURE);
            return;
        }
        List<Implementation> coreImplementations = IMPLEMENTATIONS.get(coreId);
        coreImplementations.addAll(impls);
        IMPLEMENTATIONS.set(coreId, coreImplementations);
        List<String> coreSignatures = SIGNATURES.get(coreId);
        coreSignatures.addAll(signs);
        SIGNATURES.set(coreId, coreSignatures);
        for (String signature : signs) {
            SIGNATURE_TO_CORE_ID.put(signature, coreId);
        }
    }

    public static Integer getCoreId(String signature) {
        if (signature == null || signature.isEmpty()) {
            ErrorManager.error(ERROR_INVALID_SIGNATURE);
            return null;
        }
        Integer methodId = SIGNATURE_TO_CORE_ID.get(signature);
        if (methodId == null) {
            ErrorManager.error(ERROR_UNREGISTERED_CORE_ELEMENT + signature);
            return null;
        }
        return methodId;
    }

    public static String getSignature(int coreId, int implId) {
        if (coreId < 0 || coreId >= coreCount) {
            LOGGER.warn(ERROR_UNREGISTERED_CORE_ELEMENT);
            return null;
        }
        List<String> coreSignatures = SIGNATURES.get(coreId);
        int implSignaturePosition = implId + 1;
        if (implSignaturePosition < 0 || implSignaturePosition >= coreSignatures.size()) {
            LOGGER.warn(WARN_UNREGISTERED_IMPL);
            return null;
        }
        return coreSignatures.get(implSignaturePosition);
    }

    public static Map<String, Integer> getSignaturesToId() {
        return SIGNATURE_TO_CORE_ID;
    }

    public static void clear() {
        IMPLEMENTATIONS.clear();
        SIGNATURES.clear();
        SIGNATURE_TO_CORE_ID.clear();
        coreCount = 0;
    }

    public static List<Implementation> getCoreImplementations(int coreId) {
        if (coreId < 0 || coreId >= coreCount) {
            ErrorManager.error(ERROR_UNREGISTERED_CORE_ELEMENT);
            return null;
        }
        return IMPLEMENTATIONS.get(coreId);
    }

    public static int getNumberCoreImplementations(int coreId) {
        if (coreId < 0 || coreId >= coreCount) {
            ErrorManager.error(ERROR_UNREGISTERED_CORE_ELEMENT);
            return -1;
        }
        return IMPLEMENTATIONS.get(coreId).size();
    }

    public static List<Integer> findExecutableCores(ResourceDescription rd) {
        LinkedList<Integer> executableList = new LinkedList<Integer>();
        block0: for (int coreId = 0; coreId < coreCount; ++coreId) {
            for (Implementation impl : IMPLEMENTATIONS.get(coreId)) {
                if (!rd.canHost(impl)) continue;
                executableList.add(coreId);
                continue block0;
            }
        }
        return executableList;
    }

    public static String debugString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Core Count: ").append(coreCount).append("\n");
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            sb.append("\tCore ").append(coreId).append(":\n");
            for (Implementation impl : IMPLEMENTATIONS.get(coreId)) {
                sb.append("\t\t -").append(impl.toString()).append("\n");
            }
        }
        return sb.toString();
    }

    public static String debugSignaturesString() {
        StringBuilder sb = new StringBuilder();
        sb.append("REGISTERED SIGNATURES: \n");
        for (Map.Entry<String, Integer> entry : SIGNATURE_TO_CORE_ID.entrySet()) {
            sb.append("Signature: ").append(entry.getKey());
            sb.append(" with MethodId ").append(entry.getValue());
            sb.append("\n");
        }
        return sb.toString();
    }
}

