/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.util;

import integratedtoolkit.util.ErrorManager;
import java.io.File;

public class EnvironmentLoader {
    private static final String PREFIX_ENV_VAR = "$";
    private static final String BEGIN_ENV_VAR = "}";
    private static final String END_ENV_VAR = "}";
    private static final String PREFIX_ENV_VAR_SCAPED = "\\$";
    private static final String BEGIN_ENV_VAR_SCAPED = "\\{";
    private static final String END_ENV_VAR_SCAPED = "\\}";

    public static String loadFromEnvironment(String expression) {
        String expressionValue = expression;
        while (expressionValue != null && expressionValue.contains(PREFIX_ENV_VAR)) {
            int endIndex;
            int beginIndex = expressionValue.indexOf(PREFIX_ENV_VAR);
            if (beginIndex + 1 < expressionValue.length()) {
                if (expressionValue.substring(beginIndex, beginIndex + 1).equals("}")) {
                    endIndex = expressionValue.indexOf("}", beginIndex) + 1;
                } else {
                    endIndex = expressionValue.indexOf(File.separator, beginIndex);
                    if (endIndex == -1) {
                        endIndex = expressionValue.length();
                    }
                }
            } else {
                endIndex = expressionValue.length();
            }
            String variableFullName = expressionValue.substring(beginIndex, endIndex);
            String variableLoadName = variableFullName.replaceAll(PREFIX_ENV_VAR_SCAPED, "");
            variableLoadName = variableLoadName.replaceAll(BEGIN_ENV_VAR_SCAPED, "");
            variableLoadName = variableLoadName.replaceAll(END_ENV_VAR_SCAPED, "");
            String variableValue = System.getenv(variableLoadName);
            if (variableValue != null) {
                expressionValue = expressionValue.replace(variableFullName, variableValue);
                continue;
            }
            ErrorManager.warn("[WARNING] Null value obtained while loading " + variableLoadName + " from environment");
            expressionValue = expressionValue.replace(variableFullName, "");
        }
        return expressionValue;
    }
}

