/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.util;

import java.util.LinkedList;
import java.util.List;

public class RequestQueue<T> {
    private final LinkedList<T> queue = new LinkedList();
    private int waiting = 0;

    public synchronized void enqueue(T request) {
        this.queue.add(request);
        this.notify();
    }

    public synchronized T dequeue() {
        while (this.queue.isEmpty()) {
            ++this.waiting;
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                return null;
            }
            --this.waiting;
        }
        return this.queue.poll();
    }

    public synchronized void remove(T request) {
        this.queue.remove(request);
    }

    public synchronized void addToFront(T request) {
        this.queue.addFirst(request);
        this.notify();
    }

    public synchronized int getNumRequests() {
        return this.queue.size();
    }

    public synchronized List<T> getQueue() {
        return this.queue;
    }

    public synchronized boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public synchronized int getWaiting() {
        return this.waiting;
    }

    public synchronized void clear() {
        this.queue.clear();
    }

    public void wakeUpAll() {
        this.notifyAll();
    }
}

