/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.util;

import integratedtoolkit.ITConstants;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

public class RuntimeConfigManager {
    private final PropertiesConfiguration config;

    public RuntimeConfigManager(String pathToConfigFile) throws ConfigurationException {
        this.config = new PropertiesConfiguration(pathToConfigFile);
    }

    public RuntimeConfigManager(URL pathToConfigFile) throws ConfigurationException {
        this.config = new PropertiesConfiguration(pathToConfigFile);
    }

    public RuntimeConfigManager(InputStream stream) throws ConfigurationException {
        this.config = new PropertiesConfiguration();
        this.config.load(stream);
    }

    public RuntimeConfigManager(File file) throws ConfigurationException {
        this.config = new PropertiesConfiguration(file);
    }

    public String getDeploymentId() {
        return this.config.getString("it.uuid", ITConstants.DEFAULT_DEPLOYMENT_ID);
    }

    public void setDeploymentId(String uuid) {
        this.config.setProperty("it.uuid", (Object)uuid);
    }

    public String getMasterName() {
        return this.config.getString("it.masterName");
    }

    public void setMasterName(String name) {
        this.config.setProperty("it.masterName", (Object)name);
    }

    public String getMasterPort() {
        return this.config.getString("it.masterPort");
    }

    public void setMasterPort(String port) {
        this.config.setProperty("it.masterPort", (Object)port);
    }

    public String getAppName() {
        return this.config.getString("it.appName");
    }

    public void setAppName(String name) {
        this.config.setProperty("it.appName", (Object)name);
    }

    public String getTaskSummary() {
        return this.config.getString("it.summary");
    }

    public void setTaskSummary(String value) {
        this.config.setProperty("it.summary", (Object)value);
    }

    public String getCOMPSsBaseLogDir() {
        return this.config.getString("it.baseLogDir");
    }

    public String getSpecificLogDir() {
        return this.config.getString("it.specificLogDir");
    }

    public String getProjectFile() {
        return this.config.getString("it.project.file");
    }

    public void setProjectFile(String location) {
        this.config.setProperty("it.project.file", (Object)location);
    }

    public String getProjectSchema() {
        return this.config.getString("it.project.schema");
    }

    public void setProjectSchema(String location) {
        this.config.setProperty("it.project.schema", (Object)location);
    }

    public String getResourcesFile() {
        return this.config.getString("it.resources.file");
    }

    public void setResourcesFile(String location) {
        this.config.setProperty("it.resources.file", (Object)location);
    }

    public String getResourcesSchema() {
        return this.config.getString("it.resources.schema");
    }

    public void setResourcesSchema(String location) {
        this.config.setProperty("it.resources.schema", (Object)location);
    }

    public String getScheduler() {
        return this.config.getString("it.scheduler");
    }

    public void setScheduler(String implementingClass) {
        this.config.setProperty("it.scheduler", (Object)implementingClass);
    }

    public String getLog4jConfiguration() {
        return this.config.getString("log4j.configurationFile");
    }

    public void setLog4jConfiguration(String location) {
        this.config.setProperty("log4j.configurationFile", (Object)location);
    }

    public String getCommAdaptor() {
        return this.config.getString("it.comm");
    }

    public void setCommAdaptor(String adaptor) {
        this.config.setProperty("it.comm", (Object)adaptor);
    }

    public String getConn() {
        return this.config.getString("it.conn");
    }

    public void setConn(String connector) {
        this.config.setProperty("it.conn", (Object)connector);
    }

    public String getContext() {
        return this.config.getString("it.context");
    }

    public void setContext(String context) {
        this.config.setProperty("it.context", (Object)context);
    }

    public String getGATAdaptor() {
        return this.config.getString("gat.adaptor.path", ITConstants.DEFAULT_GAT_ADAPTOR_LOCATION);
    }

    public void setGATAdaptor(String adaptorPath) {
        this.config.setProperty("gat.adaptor.path", (Object)adaptorPath);
    }

    public boolean isGATDebug() {
        return this.config.getBoolean("gat.debug", false);
    }

    public void setGATDebug(boolean debug) {
        this.config.setProperty("gat.debug", (Object)debug);
    }

    public String getGATBrokerAdaptor() {
        return this.config.getString("it.gat.broker.adaptor");
    }

    public void setGATBrokerAdaptor(String adaptor) {
        this.config.setProperty("it.gat.broker.adaptor", (Object)adaptor);
    }

    public String getGATFileAdaptor() {
        return this.config.getString("it.gat.file.adaptor");
    }

    public void setGATFileAdaptor(String adaptor) {
        this.config.setProperty("it.gat.file.adaptor", (Object)adaptor);
    }

    public void setWorkerCPUAffinity(boolean isAffinityEnabled) {
        this.config.setProperty("it.worker.cpu_affinity", (Object)isAffinityEnabled);
    }

    public boolean isWorkerCPUAffinityEnabled() {
        return this.config.getBoolean("it.worker.cpu_affinity", false);
    }

    public void setWorkerGPUAffinity(boolean isAffinityEnabled) {
        this.config.setProperty("it.worker.gpu_affinity", (Object)isAffinityEnabled);
    }

    public boolean isWorkerGPUAffinityEnabled() {
        return this.config.getBoolean("it.worker.gpu_affinity", false);
    }

    public boolean isGraph() {
        return this.config.getBoolean("it.graph", false);
    }

    public void setGraph(boolean graph) {
        this.config.setProperty("it.graph", (Object)graph);
    }

    public int getTracing() {
        return this.config.getInt("it.tracing", 0);
    }

    public void setTracing(int tracing) {
        this.config.setProperty("it.tracing", (Object)tracing);
    }

    public String getCustomExtraeFile() {
        return this.config.getString("it.extrae.file", "null");
    }

    public void setCustomExtraeFile(String extraeFilePath) {
        this.config.setProperty("it.extrae.file", (Object)extraeFilePath);
    }

    public long getMonitorInterval() {
        return this.config.getLong("it.monitor", 0L);
    }

    public void setMonitorInterval(long seconds) {
        this.config.setProperty("it.monitor", (Object)seconds);
    }

    public String getLang() {
        return this.config.getString("it.lang", ITConstants.Lang.JAVA.name());
    }

    public void setLang(String lang) {
        this.config.setProperty("it.lang", (Object)lang);
    }

    public String getWorkerCP() {
        return this.config.getString("it.worker.cp");
    }

    public void setWorkerCP(String classpath) {
        this.config.setProperty("it.worker.cp", (Object)classpath);
    }

    public String getServiceName() {
        return this.config.getString("it.serviceName");
    }

    public void setServiceName(String serviceName) {
        this.config.setProperty("it.serviceName", (Object)serviceName);
    }

    public String getWorkerJVMOpts() {
        return this.config.getString("it.worker.jvm_opts");
    }

    public void setWorkerJVMOpts(String jvmOpts) {
        this.config.setProperty("it.worker.jvm_opts", (Object)jvmOpts);
    }

    public void save() throws ConfigurationException {
        this.config.save();
    }

    public boolean isToFile() {
        return this.config.getBoolean("it.to.file", false);
    }

    public String getProperty(String propertyName) {
        Object prop = this.config.getProperty(propertyName);
        if (prop != null) {
            return prop.toString();
        }
        return null;
    }
}

