/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.apache.logging.log4j.Logger;

public class StreamGobbler
extends Thread {
    private static final int BUFFER_SIZE = 4096;
    private final InputStream in;
    private final PrintStream out;
    private final Logger logger;

    public StreamGobbler(InputStream in, PrintStream out, Logger logger) {
        this.setName("Stream Gobbler");
        this.in = in;
        this.out = out;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            int nRead;
            byte[] buffer = new byte[4096];
            while ((nRead = this.in.read(buffer, 0, buffer.length)) != -1) {
                byte[] readData = new byte[nRead];
                System.arraycopy(buffer, 0, readData, 0, nRead);
                this.out.print(new String(readData));
            }
        }
        catch (IOException ioe) {
            this.logger.error("Exception during reading/writing in output Stream", (Throwable)ioe);
        }
        finally {
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException ioe) {
                    this.logger.warn("Exception closing IN InputStream", (Throwable)ioe);
                }
            }
            if (this.out != null) {
                this.out.flush();
                this.out.close();
            }
        }
    }
}

