/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.resources;

import es.bsc.compss.types.annotations.Constraints;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.types.resources.components.Processor;
import es.bsc.compss.util.EnvironmentLoader;
import es.bsc.compss.util.ErrorManager;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class MethodResourceDescription
extends WorkerResourceDescription {
    private static final int DIFFERENCE_WEIGHT = 10000;
    private static final int OTHER_PROC_DIFFERENCE_WEIGHT = 1000;
    public static final MethodResourceDescription EMPTY_FOR_RESOURCE = new MethodResourceDescription();
    public static final MethodResourceDescription EMPTY_FOR_CONSTRAINTS = new MethodResourceDescription(1);
    private static final String PROC_NAME = "processorname";
    private static final String COMPUTING_UNITS = "computingunits";
    private static final String PROC_SPEED = "processorspeed";
    private static final String PROC_ARCH = "processorarchitecture";
    private static final String PROC_TYPE = "processortype";
    private static final String PROC_MEM_SIZE = "processorinternalmemorysize";
    private static final String PROC_PROP_NAME = "processorpropertyname";
    private static final String PROC_PROP_VALUE = "processorpropertyvalue";
    private static final String MEM_SIZE = "memorysize";
    private static final String MEM_TYPE = "memorytype";
    private static final String STORAGE_SIZE = "storagesize";
    private static final String STORAGE_TYPE = "storagetype";
    private static final String OS_TYPE = "operatingsystemtype";
    private static final String OS_DISTRIBUTION = "operatingsystemdistribution";
    private static final String OS_VERSION = "operatingsystemversion";
    private static final String APP_SOFTWARE = "appsoftware";
    private static final String HOST_QUEUES = "hostqueues";
    private static final String WALL_CLOCK_LIMIT = "wallclocklimit";
    protected List<Processor> processors = new LinkedList<Processor>();
    protected int totalCPUComputingUnits = 0;
    protected int totalCPUs = 0;
    protected int totalGPUComputingUnits = 0;
    protected int totalGPUs = 0;
    protected int totalFPGAComputingUnits = 0;
    protected int totalFPGAs = 0;
    protected int totalOTHERComputingUnits = 0;
    protected int totalOTHERs = 0;
    protected float memorySize = -1.0f;
    protected String memoryType = "[unassigned]";
    protected float storageSize = -1.0f;
    protected String storageType = "[unassigned]";
    protected String operatingSystemType = "[unassigned]";
    protected String operatingSystemDistribution = "[unassigned]";
    protected String operatingSystemVersion = "[unassigned]";
    protected List<String> appSoftware = new LinkedList<String>();
    protected List<String> hostQueues = new LinkedList<String>();
    protected int priceTimeUnit = -1;
    protected float pricePerUnit = -1.0f;
    protected int wallClockLimit = -1;
    protected Float value = Float.valueOf(0.0f);

    public MethodResourceDescription() {
    }

    private MethodResourceDescription(int initialCUs) {
        Processor p = new Processor();
        p.setComputingUnits(initialCUs);
        this.addProcessor(p);
    }

    public MethodResourceDescription(Constraints constraints) {
        int wallClockLimit;
        float storageSize;
        float memorySize;
        Processor p;
        if (constraints == null) {
            Processor p2 = new Processor();
            p2.setComputingUnits(1);
            this.addProcessor(p2);
            return;
        }
        es.bsc.compss.types.annotations.Processor[] processorsConstraints = constraints.processors();
        if (processorsConstraints != null && processorsConstraints.length > 0) {
            for (es.bsc.compss.types.annotations.Processor pC : processorsConstraints) {
                this.addProcessor(this.getProcessorFromProcessorsConstraint(pC));
            }
        }
        if (this.containsProcessorsProperties(constraints)) {
            float internalMemory;
            float speed;
            int cu;
            p = new Processor();
            String procName = constraints.processorName();
            if ((procName = EnvironmentLoader.loadFromEnvironment(procName)) != null && !procName.equals("[unassigned]")) {
                p.setName(procName);
            }
            String cuSTR = constraints.computingUnits();
            int n = cu = (cuSTR = EnvironmentLoader.loadFromEnvironment(cuSTR)) != null && !cuSTR.isEmpty() && !cuSTR.equals("[unassigned]") ? Integer.valueOf(cuSTR) : 1;
            if (cu > 1) {
                p.setComputingUnits(cu);
            } else {
                p.setComputingUnits(1);
            }
            String speedSTR = constraints.processorSpeed();
            speedSTR = EnvironmentLoader.loadFromEnvironment(speedSTR);
            float f = speed = speedSTR != null && !speedSTR.isEmpty() && !speedSTR.equals("[unassigned]") ? Float.valueOf(speedSTR).floatValue() : -1.0f;
            if (speed != -1.0f) {
                p.setSpeed(speed);
            }
            String arch = constraints.processorArchitecture();
            if ((arch = EnvironmentLoader.loadFromEnvironment(arch)) != null && !arch.equals("[unassigned]")) {
                p.setArchitecture(arch);
            }
            String type = constraints.processorType();
            if ((type = EnvironmentLoader.loadFromEnvironment(type)) != null) {
                p.setType(type);
            }
            String internalMemorySTR = constraints.processorInternalMemorySize();
            float f2 = internalMemory = (internalMemorySTR = EnvironmentLoader.loadFromEnvironment(internalMemorySTR)) != null && !internalMemorySTR.isEmpty() && !internalMemorySTR.equals("[unassigned]") ? Float.valueOf(internalMemorySTR).floatValue() : -1.0f;
            if (internalMemory != -1.0f) {
                p.setInternalMemory(internalMemory);
            }
            String propName = constraints.processorPropertyName();
            if ((propName = EnvironmentLoader.loadFromEnvironment(propName)) != null && !propName.equals("[unassigned]")) {
                p.setPropName(propName);
            }
            String propvalue = constraints.processorPropertyValue();
            if ((propvalue = EnvironmentLoader.loadFromEnvironment(propvalue)) != null && !propvalue.equals("[unassigned]")) {
                p.setPropValue(propvalue);
            }
            this.addProcessor(p);
        }
        if (this.totalCPUs == 0) {
            p = new Processor();
            p.setComputingUnits(1);
            this.addProcessor(p);
        }
        String software = constraints.appSoftware();
        if ((software = EnvironmentLoader.loadFromEnvironment(software)) != null && !software.equals("[unassigned]")) {
            for (String value : software.split(",")) {
                this.appSoftware.add(value.trim().toUpperCase());
            }
        }
        String queues = constraints.hostQueues();
        if ((queues = EnvironmentLoader.loadFromEnvironment(queues)) != null && !queues.equals("[unassigned]")) {
            for (String value : queues.split(",")) {
                this.hostQueues.add(value.trim().toUpperCase());
            }
        }
        String memorySizeSTR = constraints.memorySize();
        float f = memorySize = (memorySizeSTR = EnvironmentLoader.loadFromEnvironment(memorySizeSTR)) != null && !memorySizeSTR.isEmpty() && !memorySizeSTR.equals("[unassigned]") ? Float.valueOf(memorySizeSTR).floatValue() : -1.0f;
        if (memorySize != -1.0f) {
            this.memorySize = memorySize;
        }
        String memoryType = constraints.memoryType();
        if ((memoryType = EnvironmentLoader.loadFromEnvironment(memoryType)) != null && !memoryType.equals("[unassigned]")) {
            this.memoryType = memoryType;
        }
        String storageSizeSTR = constraints.storageSize();
        float f3 = storageSize = (storageSizeSTR = EnvironmentLoader.loadFromEnvironment(storageSizeSTR)) != null && !storageSizeSTR.isEmpty() && !storageSizeSTR.equals("[unassigned]") ? Float.valueOf(storageSizeSTR).floatValue() : -1.0f;
        if (storageSize != -1.0f) {
            this.storageSize = storageSize;
        }
        String storageType = constraints.storageType();
        if ((storageType = EnvironmentLoader.loadFromEnvironment(storageType)) != null && !storageType.equals("[unassigned]")) {
            this.storageType = storageType;
        }
        String operatingSystemType = constraints.operatingSystemType();
        if ((operatingSystemType = EnvironmentLoader.loadFromEnvironment(operatingSystemType)) != null && !operatingSystemType.equals("[unassigned]")) {
            this.operatingSystemType = operatingSystemType;
        }
        String operatingSystemDistribution = constraints.operatingSystemDistribution();
        if ((operatingSystemDistribution = EnvironmentLoader.loadFromEnvironment(operatingSystemDistribution)) != null && !operatingSystemDistribution.equals("[unassigned]")) {
            this.operatingSystemDistribution = operatingSystemDistribution;
        }
        String operatingSystemVersion = constraints.operatingSystemVersion();
        if ((operatingSystemVersion = EnvironmentLoader.loadFromEnvironment(operatingSystemVersion)) != null && !operatingSystemVersion.equals("[unassigned]")) {
            this.operatingSystemVersion = operatingSystemVersion;
        }
        String wallClockLimitSTR = constraints.wallClockLimit();
        int n = wallClockLimit = (wallClockLimitSTR = EnvironmentLoader.loadFromEnvironment(wallClockLimitSTR)) != null && !wallClockLimitSTR.isEmpty() && !wallClockLimitSTR.equals("[unassigned]") ? Integer.valueOf(wallClockLimitSTR) : -1;
        if (wallClockLimit != -1) {
            this.wallClockLimit = wallClockLimit;
        }
    }

    private boolean containsProcessorsProperties(Constraints constraints) {
        return !constraints.processorName().equals("[unassigned]") || !constraints.processorArchitecture().equals("[unassigned]") || !constraints.processorType().equals("CPU") || !constraints.processorSpeed().equals("[unassigned]") || !constraints.processorInternalMemorySize().equals("[unassigned]") || !constraints.processorPropertyName().equals("CPU") || !constraints.processorPropertyValue().equals("CPU");
    }

    private Processor getProcessorFromProcessorsConstraint(es.bsc.compss.types.annotations.Processor processorConstraints) {
        float internalMemory;
        float speed;
        int cu;
        Processor p = new Processor();
        String procName = processorConstraints.name();
        if (procName != null && !procName.equals("[unassigned]")) {
            procName = EnvironmentLoader.loadFromEnvironment(procName);
            p.setName(procName);
        }
        String cuSTR = processorConstraints.computingUnits();
        int n = cu = (cuSTR = EnvironmentLoader.loadFromEnvironment(cuSTR)) != null && !cuSTR.isEmpty() && !cuSTR.equals("[unassigned]") ? Integer.valueOf(cuSTR) : 1;
        if (cu > 1) {
            p.setComputingUnits(cu);
        } else {
            p.setComputingUnits(1);
        }
        String speedSTR = processorConstraints.speed();
        speedSTR = EnvironmentLoader.loadFromEnvironment(speedSTR);
        float f = speed = speedSTR != null && !speedSTR.isEmpty() && !speedSTR.equals("[unassigned]") ? Float.valueOf(speedSTR).floatValue() : -1.0f;
        if (speed != -1.0f) {
            p.setSpeed(speed);
        }
        String arch = processorConstraints.architecture();
        if ((arch = EnvironmentLoader.loadFromEnvironment(arch)) != null && !arch.equals("[unassigned]")) {
            p.setArchitecture(arch);
        }
        String type = processorConstraints.type();
        if ((type = EnvironmentLoader.loadFromEnvironment(type)) != null) {
            p.setType(type);
        }
        String internalMemorySTR = processorConstraints.internalMemorySize();
        float f2 = internalMemory = (internalMemorySTR = EnvironmentLoader.loadFromEnvironment(internalMemorySTR)) != null && !internalMemorySTR.isEmpty() && !internalMemorySTR.equals("[unassigned]") ? Float.valueOf(internalMemorySTR).floatValue() : -1.0f;
        if (internalMemory != -1.0f) {
            p.setInternalMemory(internalMemory);
        }
        String propName = processorConstraints.propertyName();
        if ((propName = EnvironmentLoader.loadFromEnvironment(propName)) != null && !propName.equals("[unassigned]")) {
            p.setPropName(propName);
        }
        String propvalue = processorConstraints.propertyValue();
        if ((propvalue = EnvironmentLoader.loadFromEnvironment(propvalue)) != null && !propvalue.equals("[unassigned]")) {
            p.setPropValue(propvalue);
        }
        return p;
    }

    public MethodResourceDescription(String description) {
        Processor proc = new Processor();
        proc.setComputingUnits(1);
        if (description != null && !description.isEmpty()) {
            String[] constraints;
            for (String c : constraints = description.split(";")) {
                String key = c.split(":")[0].trim();
                String val = c.split(":")[1].trim();
                this.addConstraints(key, val, proc);
            }
        }
        this.addProcessor(proc);
    }

    public MethodResourceDescription(String[] constraints, String processorString) {
        String val;
        String key;
        Processor proc = new Processor();
        if (processorString != null && !processorString.isEmpty()) {
            String[] processors = StringUtils.split((String)processorString, (String)"@");
            for (int i = 0; i < processors.length; ++i) {
                processors[i] = processors[i].replace("Processor(", "");
                processors[i] = processors[i].replaceAll("[,()]", "");
                String[] processorConstraints = processors[i].split(" ");
                proc = new Processor();
                for (int j = 0; j < processorConstraints.length; ++j) {
                    key = processorConstraints[j].split("=")[0].trim();
                    val = processorConstraints[j].split("=")[1].trim();
                    this.addConstraints(key, val, proc);
                }
                this.addProcessor(proc);
            }
        } else {
            proc.setComputingUnits(1);
        }
        if (constraints.length != 1 || !"".equals(constraints[0])) {
            for (String c : constraints) {
                key = c.split("=")[0].trim();
                val = c.split("=")[1].trim();
                this.addConstraints(key, val, proc);
            }
        }
        if (processorString == null || processorString.isEmpty()) {
            this.addProcessor(proc);
        }
        if (this.totalCPUs == 0) {
            Processor p = new Processor();
            p.setComputingUnits(1);
            this.addProcessor(p);
        }
    }

    private void addConstraints(String key, String val, Processor proc) {
        if ((val = EnvironmentLoader.loadFromEnvironment(val)) != null && !val.isEmpty()) {
            switch (key.toLowerCase()) {
                case "processorname": {
                    proc.setName(val);
                    break;
                }
                case "processorspeed": {
                    proc.setSpeed(Float.valueOf(val).floatValue());
                    break;
                }
                case "processorarchitecture": {
                    proc.setArchitecture(val);
                    break;
                }
                case "processortype": {
                    proc.setType(val);
                    break;
                }
                case "processorpropertyname": {
                    proc.setPropName(val);
                    break;
                }
                case "processorpropertyvalue": {
                    proc.setPropValue(val);
                    break;
                }
                case "processorinternalmemorysize": {
                    proc.setInternalMemory(Float.valueOf(val).floatValue());
                    break;
                }
                case "computingunits": {
                    proc.setComputingUnits(Integer.valueOf(val));
                    break;
                }
                case "memorysize": {
                    this.memorySize = Float.valueOf(val).floatValue();
                    break;
                }
                case "memorytype": {
                    this.memoryType = val;
                    break;
                }
                case "storagesize": {
                    this.storageSize = Float.valueOf(val).floatValue();
                    break;
                }
                case "storagetype": {
                    this.storageType = val;
                    break;
                }
                case "operatingsystemtype": {
                    this.operatingSystemType = val;
                    break;
                }
                case "operatingsystemdistribution": {
                    this.operatingSystemDistribution = val;
                    break;
                }
                case "operatingsystemversion": {
                    this.operatingSystemVersion = val;
                    break;
                }
                case "appsoftware": {
                    if (val.compareTo("[unassigned]") == 0) break;
                    for (String app : val.split(",")) {
                        this.appSoftware.add(app.trim().toUpperCase());
                    }
                    break;
                }
                case "hostqueues": {
                    if (val.compareTo("[unassigned]") == 0) break;
                    for (String app : val.split(",")) {
                        this.hostQueues.add(app.trim().toUpperCase());
                    }
                    break;
                }
                case "wallclocklimit": {
                    this.wallClockLimit = Integer.valueOf(val);
                    break;
                }
                default: {
                    ErrorManager.warn("WARN: Unrecognised constraint " + key + ". Skipping constraint");
                }
            }
        }
    }

    public MethodResourceDescription(MethodResourceDescription clone) {
        super(clone);
        this.initProcessorCounters();
        for (Processor p : clone.processors) {
            Processor newP = new Processor(p);
            this.addProcessor(newP);
        }
        this.memorySize = clone.memorySize;
        this.memoryType = clone.memoryType;
        this.storageSize = clone.storageSize;
        this.storageType = clone.storageType;
        this.operatingSystemType = clone.operatingSystemType;
        this.operatingSystemDistribution = clone.operatingSystemDistribution;
        this.operatingSystemVersion = clone.operatingSystemVersion;
        for (String app : clone.appSoftware) {
            this.appSoftware.add(app);
        }
        for (String queue : clone.hostQueues) {
            this.hostQueues.add(queue);
        }
        this.priceTimeUnit = clone.priceTimeUnit;
        this.pricePerUnit = clone.pricePerUnit;
        this.wallClockLimit = clone.wallClockLimit;
        this.value = clone.value;
    }

    private void initProcessorCounters() {
        this.totalCPUComputingUnits = 0;
        this.totalCPUs = 0;
        this.totalGPUComputingUnits = 0;
        this.totalGPUs = 0;
        this.totalFPGAComputingUnits = 0;
        this.totalFPGAs = 0;
        this.totalOTHERComputingUnits = 0;
        this.totalOTHERs = 0;
    }

    @Override
    public MethodResourceDescription copy() {
        return new MethodResourceDescription(this);
    }

    public List<Processor> getProcessors() {
        return this.processors;
    }

    public void setProcessors(List<Processor> processors) {
        this.processors = processors;
        this.initProcessorCounters();
        for (Processor p : this.processors) {
            this.updateCounters(p);
        }
    }

    public void resetProcessors() {
        this.processors = new LinkedList<Processor>();
        this.initProcessorCounters();
    }

    public void addProcessor(Processor p) {
        this.processors.add(p);
        this.updateCounters(p);
    }

    private void updateCounters(Processor p) {
        String type = p.getType();
        int cu = p.getComputingUnits();
        if (type.equals("CPU")) {
            this.totalCPUComputingUnits = cu > 0 ? (this.totalCPUComputingUnits += cu) : ++this.totalCPUComputingUnits;
            ++this.totalCPUs;
        } else if (type.equals("GPU")) {
            this.totalGPUComputingUnits = cu > 0 ? (this.totalGPUComputingUnits += cu) : ++this.totalGPUComputingUnits;
            ++this.totalGPUs;
        } else if (type.equals("FPGA")) {
            this.totalFPGAComputingUnits = cu > 0 ? (this.totalFPGAComputingUnits += cu) : ++this.totalFPGAComputingUnits;
            ++this.totalFPGAs;
        } else {
            this.totalOTHERComputingUnits = cu > 0 ? (this.totalOTHERComputingUnits += cu) : ++this.totalOTHERComputingUnits;
            ++this.totalOTHERs;
        }
    }

    public void addProcessor(String procName, int computingUnits, String architecture, float speed, String type, float internalMemory, String propName, String propValue) {
        Processor p = new Processor();
        if (procName != null && !procName.isEmpty()) {
            p.setName(procName);
        }
        if (computingUnits > 0) {
            p.setComputingUnits(computingUnits);
        }
        if (architecture != null && !architecture.isEmpty()) {
            p.setArchitecture(architecture);
        }
        if (speed > 0.0f) {
            p.setSpeed(speed);
        }
        if (type != null && !type.isEmpty()) {
            p.setType(type);
        }
        if (internalMemory > 0.0f) {
            p.setInternalMemory(internalMemory);
        }
        if (propName != null && !propName.isEmpty()) {
            p.setPropName(propName);
        }
        if (propValue != null && !propValue.isEmpty()) {
            p.setPropValue(propValue);
        }
        this.addProcessor(p);
    }

    public List<String> getArchitectures() {
        LinkedList<String> architectures = new LinkedList<String>();
        for (Processor p : this.processors) {
            String arch = p.getArchitecture();
            if (!arch.equals("[unassigned]")) {
                architectures.add(arch);
                continue;
            }
            if (architectures.contains("[unassigned]")) continue;
            architectures.add("[unassigned]");
        }
        return architectures;
    }

    public int getTotalCPUComputingUnits() {
        return this.totalCPUComputingUnits;
    }

    public int getTotalGPUComputingUnits() {
        return this.totalGPUComputingUnits;
    }

    public int getTotalFPGAComputingUnits() {
        return this.totalFPGAComputingUnits;
    }

    public int getTotalOTHERComputingUnits() {
        return this.totalOTHERComputingUnits;
    }

    public float getMemorySize() {
        return this.memorySize;
    }

    public void setMemorySize(float memorySize) {
        if (memorySize > 0.0f) {
            this.memorySize = memorySize;
        }
    }

    public String getMemoryType() {
        return this.memoryType;
    }

    public void setMemoryType(String memoryType) {
        if (memoryType != null && !memoryType.isEmpty()) {
            this.memoryType = memoryType;
        }
    }

    public float getStorageSize() {
        return this.storageSize;
    }

    public void setStorageSize(float storageSize) {
        if (storageSize > 0.0f) {
            this.storageSize = storageSize;
        }
    }

    public String getStorageType() {
        return this.storageType;
    }

    public void setStorageType(String storageType) {
        if (storageType != null && !storageType.isEmpty()) {
            this.storageType = storageType;
        }
    }

    public String getOperatingSystemType() {
        return this.operatingSystemType;
    }

    public void setOperatingSystemType(String operatingSystemType) {
        if (operatingSystemType != null && !operatingSystemType.isEmpty()) {
            this.operatingSystemType = operatingSystemType;
        }
    }

    public String getOperatingSystemDistribution() {
        return this.operatingSystemDistribution;
    }

    public void setOperatingSystemDistribution(String operatingSystemDistribution) {
        if (operatingSystemDistribution != null && !operatingSystemDistribution.isEmpty()) {
            this.operatingSystemDistribution = operatingSystemDistribution;
        }
    }

    public String getOperatingSystemVersion() {
        return this.operatingSystemVersion;
    }

    public void setOperatingSystemVersion(String operatingSystemVersion) {
        if (operatingSystemVersion != null && !operatingSystemVersion.isEmpty()) {
            this.operatingSystemVersion = operatingSystemVersion;
        }
    }

    public List<String> getAppSoftware() {
        return this.appSoftware;
    }

    public void setAppSoftware(List<String> appSoftware) {
        if (appSoftware != null) {
            this.appSoftware = appSoftware;
        }
    }

    public void resetAppSoftware() {
        this.appSoftware = new LinkedList<String>();
    }

    public void addApplication(String application) {
        if (application != null && !application.isEmpty()) {
            this.appSoftware.add(application.toUpperCase());
        }
    }

    public List<String> getHostQueues() {
        return this.hostQueues;
    }

    public void setHostQueues(List<String> hostQueues) {
        if (hostQueues != null) {
            this.hostQueues = hostQueues;
        }
    }

    public void resetHostQueues() {
        this.hostQueues = new LinkedList<String>();
    }

    public void addHostQueue(String queue) {
        if (queue != null && !queue.isEmpty()) {
            this.hostQueues.add(queue.toUpperCase());
        }
    }

    public int getPriceTimeUnit() {
        return this.priceTimeUnit;
    }

    public void setPriceTimeUnit(int priceTimeUnit) {
        if (priceTimeUnit > 0) {
            this.priceTimeUnit = priceTimeUnit;
        }
    }

    public float getPricePerUnit() {
        return this.pricePerUnit;
    }

    public void setPricePerUnit(float pricePerUnit) {
        if ((float)this.priceTimeUnit > 0.0f) {
            this.pricePerUnit = pricePerUnit;
        }
    }

    public int getWallClockLimit() {
        return this.wallClockLimit;
    }

    public void setWallClockLimit(int wallClockLimit) {
        if (wallClockLimit > 0) {
            this.wallClockLimit = wallClockLimit;
        }
    }

    public Float getValue() {
        return this.value;
    }

    public void setValue(Float value) {
        this.value = value;
    }

    public boolean containsCPU() {
        return this.getTotalCPUComputingUnits() > 0;
    }

    public boolean containsGPU() {
        return this.getTotalGPUComputingUnits() > 0;
    }

    public boolean containsFPGA() {
        return this.getTotalFPGAComputingUnits() > 0;
    }

    public boolean containsOthers() {
        return this.getTotalOTHERComputingUnits() > 0;
    }

    public void mergeMultiConstraints(MethodResourceDescription mr2) {
        for (Processor pmr2 : mr2.processors) {
            String type = pmr2.getType();
            Processor pthis = this.lookForProcessorType(type);
            if (pthis != null) {
                if (pthis.getComputingUnits() <= 1) {
                    int newCus = pmr2.getComputingUnits();
                    int currentCUs = pthis.getComputingUnits();
                    pthis.setComputingUnits(newCus);
                    if (type.equals("CPU")) {
                        this.totalCPUComputingUnits += newCus - currentCUs;
                    } else if (type.equals("GPU")) {
                        this.totalGPUComputingUnits += newCus - currentCUs;
                    } else if (type.equals("FPGA")) {
                        this.totalFPGAComputingUnits += newCus - currentCUs;
                    } else {
                        this.totalOTHERComputingUnits += newCus - currentCUs;
                    }
                }
                if (pthis.getSpeed() == -1.0f) {
                    pthis.setSpeed(pmr2.getSpeed());
                }
                if (pthis.getInternalMemory() == -1.0f) {
                    pthis.setInternalMemory(pmr2.getInternalMemory());
                }
                if (pthis.getName().equals("[unassigned]")) {
                    pthis.setName(pmr2.getName());
                }
                if (pthis.getArchitecture().equals("[unassigned]")) {
                    pthis.setArchitecture(pmr2.getArchitecture());
                }
                if (pthis.getPropName().equals("[unassigned]")) {
                    pthis.setPropName(pmr2.getPropName());
                }
                if (!pthis.getPropValue().equals("[unassigned]")) continue;
                pthis.setPropValue(pmr2.getPropValue());
                continue;
            }
            this.addProcessor(pmr2);
        }
        if (this.memorySize == -1.0f) {
            this.setMemorySize(mr2.getMemorySize());
        }
        if (this.memoryType.equals("[unassigned]")) {
            this.setMemoryType(mr2.getMemoryType());
        }
        if (this.storageSize == -1.0f) {
            this.setStorageSize(mr2.getStorageSize());
        }
        if (this.storageType.equals("[unassigned]")) {
            this.setStorageType(mr2.getStorageType());
        }
        if (this.operatingSystemType.equals("[unassigned]")) {
            this.setOperatingSystemType(mr2.getOperatingSystemType());
        }
        if (this.operatingSystemDistribution.equals("[unassigned]")) {
            this.setOperatingSystemDistribution(mr2.getOperatingSystemDistribution());
        }
        if (this.operatingSystemVersion.equals("[unassigned]")) {
            this.setOperatingSystemVersion(mr2.getOperatingSystemVersion());
        }
        for (String app : mr2.appSoftware) {
            if (this.appSoftware.contains(app)) continue;
            this.appSoftware.add(app);
        }
        for (String queue : mr2.hostQueues) {
            if (this.hostQueues.contains(queue)) continue;
            this.hostQueues.add(queue);
        }
        if (this.pricePerUnit == -1.0f && mr2.pricePerUnit > 0.0f) {
            this.pricePerUnit = mr2.pricePerUnit;
        }
        if (this.priceTimeUnit == -1 && mr2.priceTimeUnit > 0) {
            this.priceTimeUnit = mr2.priceTimeUnit;
        }
        if (this.wallClockLimit == -1) {
            this.setWallClockLimit(mr2.getWallClockLimit());
        }
        this.value = mr2.value;
    }

    private Processor lookForProcessorType(String type) {
        for (Processor p : this.processors) {
            if (!p.getType().equals(type)) continue;
            return p;
        }
        return null;
    }

    public float difference(MethodResourceDescription mr2) {
        float processorDif = this.getTotalCPUComputingUnits() - mr2.getTotalCPUComputingUnits();
        float otherProcessorsDif = this.getTotalGPUComputingUnits() + this.getTotalFPGAComputingUnits() + this.getTotalOTHERComputingUnits() - (mr2.getTotalGPUComputingUnits() + mr2.getTotalFPGAComputingUnits() + mr2.getTotalOTHERComputingUnits());
        float memoryDif = this.memorySize - mr2.memorySize;
        return processorDif * 10000.0f + otherProcessorsDif * 1000.0f + memoryDif;
    }

    public boolean contains(MethodResourceDescription rc2) {
        boolean contained = this.checkCompatibility(this.operatingSystemType, rc2.operatingSystemType);
        contained = contained && this.checkCompatibility(this.operatingSystemDistribution, rc2.operatingSystemDistribution);
        contained = contained && this.checkCompatibility(this.operatingSystemVersion, rc2.operatingSystemVersion);
        contained = contained && this.hostQueues.containsAll(rc2.hostQueues);
        contained = contained && this.appSoftware.containsAll(rc2.appSoftware);
        contained = contained && this.checkProcessors(rc2);
        contained = contained && this.checkMemory(rc2);
        contained = contained && this.checkStorage(rc2);
        return contained;
    }

    public boolean containsDynamic(MethodResourceDescription rc2) {
        boolean contained = this.checkProcessors(rc2);
        contained = contained && this.checkMemory(rc2);
        return contained;
    }

    private boolean checkProcessors(MethodResourceDescription rc2) {
        for (Processor p : rc2.processors) {
            if (this.checkProcessor(p)) continue;
            return false;
        }
        return true;
    }

    private boolean checkProcessor(Processor p) {
        for (Processor pThis : this.processors) {
            if (!this.checkProcessorContains(pThis, p)) continue;
            return true;
        }
        return false;
    }

    private boolean checkProcessorContains(Processor pThis, Processor pRc2) {
        boolean contains = this.checkProcessorCompatibility(pThis, pRc2) && this.checkInclusion(pThis.getComputingUnits(), pRc2.getComputingUnits());
        return contains;
    }

    private boolean checkProcessorCompatibility(Processor pThis, Processor pRc2) {
        boolean compatible = this.checkCompatibility(pThis.getName(), pRc2.getName());
        compatible = compatible && this.checkCompatibility(pThis.getArchitecture(), pRc2.getArchitecture());
        compatible = compatible && this.checkInclusion(pThis.getSpeed(), pRc2.getSpeed());
        compatible = compatible && this.checkCompatibility(pThis.getType(), pRc2.getType());
        compatible = compatible && this.checkInclusion(pThis.getInternalMemory(), pRc2.getInternalMemory());
        compatible = compatible && this.checkCompatibility(pThis.getPropName(), pRc2.getPropName());
        compatible = compatible && this.checkCompatibility(pThis.getPropValue(), pRc2.getPropValue());
        return compatible;
    }

    private boolean checkMemory(MethodResourceDescription rc2) {
        return this.checkInclusion(this.memorySize, rc2.memorySize) && this.checkCompatibility(this.memoryType, rc2.memoryType);
    }

    private boolean checkStorage(MethodResourceDescription rc2) {
        return this.checkInclusion(this.storageSize, rc2.storageSize) && this.checkCompatibility(this.storageType, rc2.storageType);
    }

    private boolean checkCompatibility(String value1, String value2) {
        return value1.equals(value2) || value1.equals("[unassigned]") || value2.equals("[unassigned]");
    }

    private boolean checkInclusion(int value1, int value2) {
        return value1 >= value2 || value2 == -1;
    }

    private boolean checkInclusion(float value1, float value2) {
        return value1 >= value2 || value1 == -1.0f || value2 == -1.0f;
    }

    public Integer canHostSimultaneously(MethodResourceDescription rc2) {
        float ratio;
        int min = Integer.MAX_VALUE;
        if (rc2.getTotalCPUComputingUnits() >= 1) {
            ratio = (float)this.getTotalCPUComputingUnits() / (float)rc2.getTotalCPUComputingUnits();
            min = (int)ratio;
        }
        if (rc2.getTotalGPUComputingUnits() >= 1) {
            ratio = (float)this.getTotalGPUComputingUnits() / (float)rc2.getTotalGPUComputingUnits();
            min = (int)ratio;
        }
        if (rc2.getTotalFPGAComputingUnits() >= 1) {
            ratio = (float)this.getTotalFPGAComputingUnits() / (float)rc2.getTotalFPGAComputingUnits();
            min = (int)ratio;
        }
        for (Processor p : rc2.processors) {
            for (Processor pThis : this.processors) {
                if (!this.checkProcessorCompatibility(pThis, p)) continue;
                float ratio2 = pThis.getComputingUnits() / p.getComputingUnits();
                min = Math.min(min, (int)ratio2);
            }
        }
        if (this.memorySize != -1.0f && rc2.memorySize != -1.0f && rc2.memorySize > 0.0f) {
            float ratio3 = this.memorySize / rc2.memorySize;
            min = Math.min(min, (int)ratio3);
        }
        return min;
    }

    public MethodResourceDescription multiply(int amount) {
        MethodResourceDescription rd = new MethodResourceDescription();
        for (Processor p : this.processors) {
            Processor new_p = new Processor(p);
            new_p.multiply(amount);
            rd.addProcessor(new_p);
        }
        rd.memorySize = this.memorySize * (float)amount;
        rd.storageSize = this.storageSize * (float)amount;
        return rd;
    }

    @Override
    public void increase(ResourceDescription rd2) {
        MethodResourceDescription mrd2 = (MethodResourceDescription)rd2;
        this.increaseDynamic(rd2);
        this.storageSize = Math.max(this.storageSize, mrd2.storageSize);
        if (this.storageType.equals("[unassigned]") && mrd2.storageType != null && !mrd2.storageType.isEmpty()) {
            this.storageType = mrd2.storageType;
        }
        if (this.operatingSystemType.equals("[unassigned]") && mrd2.operatingSystemType != null && !mrd2.operatingSystemType.isEmpty()) {
            this.operatingSystemType = mrd2.operatingSystemType;
        }
        if (this.operatingSystemDistribution.equals("[unassigned]") && mrd2.operatingSystemDistribution != null && !mrd2.operatingSystemDistribution.isEmpty()) {
            this.operatingSystemDistribution = mrd2.operatingSystemDistribution;
        }
        if (this.operatingSystemVersion.equals("[unassigned]") && mrd2.memoryType != null && !mrd2.memoryType.isEmpty()) {
            this.operatingSystemVersion = mrd2.operatingSystemVersion;
        }
        for (String app : mrd2.appSoftware) {
            if (this.appSoftware.contains(app)) continue;
            this.appSoftware.add(app);
        }
        for (String queue : mrd2.hostQueues) {
            if (this.hostQueues.contains(queue)) continue;
            this.hostQueues.add(queue);
        }
        if (this.pricePerUnit == -1.0f && mrd2.pricePerUnit > 0.0f) {
            this.pricePerUnit = mrd2.pricePerUnit;
        }
        if (this.priceTimeUnit == -1 && mrd2.priceTimeUnit > 0) {
            this.priceTimeUnit = mrd2.priceTimeUnit;
        }
        this.wallClockLimit = Math.max(this.wallClockLimit, mrd2.wallClockLimit);
        this.value = Float.valueOf(Math.max(this.value.floatValue(), mrd2.value.floatValue()));
    }

    @Override
    public void reduce(ResourceDescription rd2) {
        MethodResourceDescription mrd2 = (MethodResourceDescription)rd2;
        this.reduceDynamic(rd2);
        this.storageSize = Math.min(this.storageSize, mrd2.storageSize);
        if (this.storageType.equals("[unassigned]") && mrd2.storageType != null && !mrd2.storageType.isEmpty()) {
            this.storageType = mrd2.storageType;
        }
        if (this.operatingSystemType.equals("[unassigned]") && mrd2.operatingSystemType != null && !mrd2.operatingSystemType.isEmpty()) {
            this.operatingSystemType = mrd2.operatingSystemType;
        }
        if (this.operatingSystemDistribution.equals("[unassigned]") && mrd2.operatingSystemDistribution != null && !mrd2.operatingSystemDistribution.isEmpty()) {
            this.operatingSystemDistribution = mrd2.operatingSystemDistribution;
        }
        if (this.operatingSystemVersion.equals("[unassigned]") && mrd2.memoryType != null && !mrd2.memoryType.isEmpty()) {
            this.operatingSystemVersion = mrd2.operatingSystemVersion;
        }
        for (String app : mrd2.appSoftware) {
            if (!this.appSoftware.contains(app)) continue;
            this.appSoftware.remove(app);
        }
        for (String queue : mrd2.hostQueues) {
            if (!this.hostQueues.contains(queue)) continue;
            this.hostQueues.remove(queue);
        }
        if (this.pricePerUnit == -1.0f) {
            if (mrd2.pricePerUnit > 0.0f) {
                this.pricePerUnit = mrd2.pricePerUnit;
            }
        } else if (mrd2.pricePerUnit > 0.0f && mrd2.pricePerUnit < this.pricePerUnit) {
            this.pricePerUnit = mrd2.pricePerUnit;
        }
        if (this.priceTimeUnit == -1) {
            if (mrd2.priceTimeUnit > 0) {
                this.priceTimeUnit = mrd2.priceTimeUnit;
            }
        } else if (mrd2.priceTimeUnit > 0 && mrd2.priceTimeUnit < this.priceTimeUnit) {
            this.priceTimeUnit = mrd2.priceTimeUnit;
        }
        this.wallClockLimit = Math.min(this.wallClockLimit, mrd2.wallClockLimit);
        this.value = Float.valueOf(Math.min(this.value.floatValue(), mrd2.value.floatValue()));
    }

    @Override
    public void increaseDynamic(ResourceDescription rd2) {
        MethodResourceDescription mrd2 = (MethodResourceDescription)rd2;
        for (Processor p : mrd2.processors) {
            boolean processorMerged = false;
            for (Processor pThis : this.processors) {
                if (!this.checkProcessorCompatibility(pThis, p)) continue;
                processorMerged = true;
                int cus = p.getComputingUnits();
                pThis.addComputingUnits(cus);
                this.increaseComputingUnits(pThis.getType(), cus);
                break;
            }
            if (processorMerged) continue;
            Processor newProc = new Processor(p);
            this.addProcessor(newProc);
        }
        if (this.memorySize != -1.0f && mrd2.memorySize != -1.0f) {
            this.memorySize += mrd2.memorySize;
        }
    }

    @Override
    public ResourceDescription reduceDynamic(ResourceDescription rd2) {
        MethodResourceDescription mrd2 = (MethodResourceDescription)rd2;
        MethodResourceDescription reduced = new MethodResourceDescription();
        for (Processor p : mrd2.processors) {
            boolean processorMerged = false;
            for (Processor pThis : this.processors) {
                if (!this.checkProcessorCompatibility(pThis, p)) continue;
                processorMerged = true;
                int cus = p.getComputingUnits();
                Processor p_reduced = new Processor(pThis);
                p_reduced.setComputingUnits(cus);
                reduced.addProcessor(p_reduced);
                pThis.removeComputingUnits(cus);
                this.decreaseComputingUnits(pThis.getType(), cus);
                break;
            }
            if (processorMerged) continue;
            return null;
        }
        if (this.checkMemory(mrd2)) {
            reduced.setMemoryType(this.memoryType);
            if (mrd2.memorySize == -1.0f || this.memorySize == -1.0f) {
                reduced.setMemorySize(-1.0f);
            } else {
                this.memorySize -= mrd2.memorySize;
                reduced.setMemorySize(mrd2.memorySize);
            }
        } else {
            return null;
        }
        return reduced;
    }

    private void increaseComputingUnits(String type, int cus) {
        if (type.equals("CPU")) {
            this.totalCPUComputingUnits += cus;
        } else if (type.equals("GPU")) {
            this.totalGPUComputingUnits += cus;
        } else if (type.equals("FPGA")) {
            this.totalFPGAComputingUnits += cus;
        } else {
            this.totalOTHERComputingUnits += cus;
        }
    }

    private void decreaseComputingUnits(String type, int cus) {
        if (type.equals("CPU")) {
            this.totalCPUComputingUnits -= cus;
        } else if (type.equals("GPU")) {
            this.totalGPUComputingUnits -= cus;
        } else if (type.equals("FPGA")) {
            this.totalFPGAComputingUnits -= cus;
        } else {
            this.totalOTHERComputingUnits -= cus;
        }
    }

    @Override
    public ResourceDescription getDynamicCommons(ResourceDescription other) {
        MethodResourceDescription otherMRD = (MethodResourceDescription)other;
        MethodResourceDescription common = new MethodResourceDescription();
        for (Processor p : otherMRD.getProcessors()) {
            boolean isProcessorCompatible = false;
            for (int i = 0; i < this.processors.size() && !isProcessorCompatible; ++i) {
                Processor pThis = this.processors.get(i);
                if (!this.checkProcessorCompatibility(pThis, p)) continue;
                isProcessorCompatible = true;
                Processor commonProcessor = this.getDynamicCommonsProcessor(pThis, p);
                if (commonProcessor.getComputingUnits() <= 0) continue;
                common.addProcessor(commonProcessor);
            }
        }
        if (this.checkCompatibility(this.memoryType, otherMRD.memoryType)) {
            common.setMemoryType(this.getMemoryType());
            common.setMemorySize(Math.min(this.memorySize, otherMRD.getMemorySize()));
        }
        return common;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.processors = (List)in.readObject();
        this.totalCPUComputingUnits = in.readInt();
        this.totalCPUs = in.readInt();
        this.totalGPUComputingUnits = in.readInt();
        this.totalGPUs = in.readInt();
        this.totalFPGAComputingUnits = in.readInt();
        this.totalFPGAs = in.readInt();
        this.totalOTHERComputingUnits = in.readInt();
        this.totalOTHERs = in.readInt();
        this.memorySize = in.readFloat();
        this.memoryType = (String)in.readObject();
        this.storageSize = in.readFloat();
        this.storageType = (String)in.readObject();
        this.operatingSystemType = (String)in.readObject();
        this.operatingSystemDistribution = (String)in.readObject();
        this.operatingSystemVersion = (String)in.readObject();
        this.appSoftware = (List)in.readObject();
        this.hostQueues = (List)in.readObject();
        this.priceTimeUnit = in.readInt();
        this.pricePerUnit = in.readFloat();
        this.wallClockLimit = in.readInt();
        this.value = Float.valueOf(in.readFloat());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.processors);
        out.writeInt(this.totalCPUComputingUnits);
        out.writeInt(this.totalCPUs);
        out.writeInt(this.totalGPUComputingUnits);
        out.writeInt(this.totalGPUs);
        out.writeInt(this.totalFPGAComputingUnits);
        out.writeInt(this.totalFPGAs);
        out.writeInt(this.totalOTHERComputingUnits);
        out.writeInt(this.totalOTHERs);
        out.writeFloat(this.memorySize);
        out.writeObject(this.memoryType);
        out.writeFloat(this.storageSize);
        out.writeObject(this.storageType);
        out.writeObject(this.operatingSystemType);
        out.writeObject(this.operatingSystemDistribution);
        out.writeObject(this.operatingSystemVersion);
        out.writeObject(this.appSoftware);
        out.writeObject(this.hostQueues);
        out.writeInt(this.priceTimeUnit);
        out.writeFloat(this.pricePerUnit);
        out.writeInt(this.wallClockLimit);
        out.writeFloat(this.value.floatValue());
    }

    private Processor getDynamicCommonsProcessor(Processor pThis, Processor p) {
        Processor common = new Processor(pThis);
        int cus = Math.min(pThis.getComputingUnits(), p.getComputingUnits());
        common.setComputingUnits(cus);
        return common;
    }

    @Override
    public boolean isDynamicUseless() {
        return (double)this.getMemorySize() <= 0.0 && this.totalCPUComputingUnits < 1;
    }

    @Override
    public boolean isDynamicConsuming() {
        return (double)this.getMemorySize() > 0.0 || this.totalCPUComputingUnits > 0;
    }

    @Override
    public boolean canHost(Implementation impl) {
        if (impl.getTaskType() == Implementation.TaskType.METHOD) {
            MethodResourceDescription wd = (MethodResourceDescription)impl.getRequirements();
            return this.contains(wd);
        }
        return false;
    }

    @Override
    public boolean canHostDynamic(Implementation impl) {
        if (impl.getTaskType() == Implementation.TaskType.METHOD) {
            MethodResourceDescription wd = (MethodResourceDescription)impl.getRequirements();
            return this.containsDynamic(wd);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[DESCRIPTION");
        for (Processor p : this.processors) {
            sb.append(" [PROCESSOR ").append(p.getName());
            sb.append(" TYPE=").append(p.getType());
            sb.append(" COMPUTING_UNITS=").append(p.getComputingUnits());
            sb.append(" SPEED=").append(p.getSpeed());
            sb.append(" INTERNAL_MEMORY=").append(p.getInternalMemory());
            sb.append(" ARCHITECTURE=").append(p.getArchitecture());
            sb.append(" PROP_NAME=").append(p.getPropName());
            sb.append(" PROP_VALUE=").append(p.getPropValue());
            sb.append("]");
        }
        sb.append("[GENERAL_COUNTS");
        sb.append(" TOTAL_CPUs=").append(this.totalCPUs);
        sb.append(" TOTAL_CPU_CU=").append(this.totalCPUComputingUnits);
        sb.append(" TOTAL_GPUs=").append(this.totalGPUs);
        sb.append(" TOTAL_GPU_CU=").append(this.totalGPUComputingUnits);
        sb.append(" TOTAL_FPGAs=").append(this.totalFPGAs);
        sb.append(" TOTAL_FPGA_CU=").append(this.totalFPGAComputingUnits);
        sb.append(" TOTAL_OTHERs=").append(this.totalOTHERs);
        sb.append(" TOTAL_OTHER_CU=").append(this.totalOTHERComputingUnits);
        sb.append("]");
        sb.append(" [MEMORY");
        sb.append(" SIZE=").append(this.memorySize);
        sb.append(" TYPE=").append(this.memoryType);
        sb.append("]");
        sb.append(" [STORAGE");
        sb.append(" SIZE=").append(this.storageSize);
        sb.append(" TYPE=").append(this.storageType);
        sb.append("]");
        sb.append(" [OPERATING_SYSTEM");
        sb.append(" TYPE=").append(this.operatingSystemType);
        sb.append(" DISTRIBUTION=").append(this.operatingSystemDistribution);
        sb.append(" VERSION=").append(this.operatingSystemVersion);
        sb.append("]");
        sb.append(" [SOFTWARE ");
        for (String app : this.appSoftware) {
            sb.append(app).append(", ");
        }
        sb.append("]");
        sb.append(" [HOST_QUEUES ");
        for (String queue : this.hostQueues) {
            sb.append(queue).append(", ");
        }
        sb.append("]");
        sb.append(" [PRICE");
        sb.append(" TIME_UNIT=").append(this.priceTimeUnit);
        sb.append(" PRICE_PER_TIME=").append(this.pricePerUnit);
        sb.append("]");
        sb.append(" [WALLCLOCK=").append(this.wallClockLimit).append("]");
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String getDynamicDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append(" Processor: ");
        for (Processor pThis : this.processors) {
            sb.append(pThis.getComputingUnits() + " " + pThis.getArchitecture() + " cores");
        }
        sb.append(" Memory: ");
        if (this.memorySize != -1.0f) {
            sb.append(this.memorySize);
        } else {
            sb.append("Unassigned");
        }
        return sb.toString();
    }
}

