/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.exceptions.LangNotDefinedException;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.resources.MethodResourceDescription;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class AbstractMethodImplementation
extends Implementation
implements Externalizable {
    private static final COMPSsConstants.Lang LANG;

    public AbstractMethodImplementation() {
    }

    public AbstractMethodImplementation(Integer coreId, Integer implementationId, MethodResourceDescription annot) {
        super(coreId, implementationId, annot);
    }

    public static String getSignature(String declaringClass, String methodName, boolean hasTarget, int numReturns, Parameter[] parameters) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(methodName).append("(");
        switch (LANG) {
            case JAVA: 
            case C: {
                int numPars = parameters.length;
                if (hasTarget) {
                    --numPars;
                }
                if ((numPars -= numReturns) <= 0) break;
                DataType type = parameters[0].getType();
                type = type == DataType.PSCO_T ? DataType.OBJECT_T : type;
                buffer.append(type);
                for (int i = 1; i < numPars; ++i) {
                    type = parameters[i].getType();
                    type = type == DataType.PSCO_T ? DataType.OBJECT_T : type;
                    buffer.append(",").append(type);
                }
                break;
            }
            case PYTHON: {
                break;
            }
            case UNKNOWN: {
                throw new LangNotDefinedException();
            }
        }
        buffer.append(")").append(declaringClass);
        return buffer.toString();
    }

    @Override
    public Implementation.TaskType getTaskType() {
        return Implementation.TaskType.METHOD;
    }

    public abstract MethodType getMethodType();

    public abstract String getMethodDefinition();

    @Override
    public MethodResourceDescription getRequirements() {
        return (MethodResourceDescription)this.requirements;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
    }

    static {
        COMPSsConstants.Lang l = COMPSsConstants.Lang.JAVA;
        String langProperty = System.getProperty("compss.lang");
        if (langProperty != null) {
            if (langProperty.equalsIgnoreCase("python")) {
                l = COMPSsConstants.Lang.PYTHON;
            } else if (langProperty.equalsIgnoreCase("c")) {
                l = COMPSsConstants.Lang.C;
            }
        }
        LANG = l;
    }

    public static enum MethodType {
        METHOD,
        BINARY,
        MPI,
        COMPSs,
        DECAF,
        MULTI_NODE,
        OMPSS,
        OPENCL;

    }
}

