/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types;

import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.ServiceImplementation;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.util.CoreManager;
import es.bsc.compss.util.ErrorManager;
import java.io.Serializable;

public class TaskDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Implementation.TaskType type;
    private final String signature;
    private final Integer coreId;
    private final boolean priority;
    private final int numNodes;
    private final boolean mustReplicate;
    private final boolean mustDistribute;
    private final Parameter[] parameters;
    private final boolean hasTarget;
    private final boolean hasReturn;
    private final int numReturns;

    public TaskDescription(String signature, boolean isPrioritary, int numNodes, boolean isReplicated, boolean isDistributed, boolean hasTarget, boolean hasReturn, int numReturns, Parameter[] parameters) {
        this.type = Implementation.TaskType.METHOD;
        this.signature = signature;
        this.coreId = CoreManager.getCoreId(signature);
        this.priority = isPrioritary;
        this.numNodes = numNodes;
        this.mustReplicate = isReplicated;
        this.mustDistribute = isDistributed;
        this.hasTarget = hasTarget;
        this.parameters = parameters;
        this.hasReturn = hasReturn;
        this.numReturns = numReturns;
        if (this.numNodes < 1) {
            ErrorManager.error("Invalid number of nodes " + this.numNodes + " on executeTask " + this.signature);
        }
    }

    public TaskDescription(String namespace, String service, String port, String operation, boolean isPrioritary, boolean hasTarget, boolean hasReturn, int numReturns, Parameter[] parameters) {
        this.type = Implementation.TaskType.SERVICE;
        this.priority = isPrioritary;
        this.numNodes = 1;
        this.mustReplicate = Boolean.parseBoolean("false");
        this.mustDistribute = Boolean.parseBoolean("false");
        this.hasTarget = hasTarget;
        this.hasReturn = hasReturn;
        this.numReturns = numReturns;
        this.parameters = parameters;
        this.signature = ServiceImplementation.getSignature(namespace, service, port, operation, hasTarget, hasReturn, parameters);
        this.coreId = CoreManager.getCoreId(this.signature);
    }

    public Integer getId() {
        return this.coreId;
    }

    public String getName() {
        String methodName = this.signature;
        int endIndex = methodName.indexOf(40);
        if (endIndex >= 0) {
            methodName = methodName.substring(0, endIndex);
        }
        return methodName;
    }

    public boolean hasPriority() {
        return this.priority;
    }

    public int getNumNodes() {
        return this.numNodes;
    }

    public boolean isSingleNode() {
        return this.numNodes == 1;
    }

    public boolean isReplicated() {
        return this.mustReplicate;
    }

    public boolean isDistributed() {
        return this.mustDistribute;
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public boolean hasTargetObject() {
        return this.hasTarget;
    }

    public boolean hasReturnValue() {
        return this.hasReturn;
    }

    public int getNumReturns() {
        return this.numReturns;
    }

    public Implementation.TaskType getType() {
        return this.type;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[Core id: ").append(this.coreId).append("]");
        buffer.append(", [Priority: ").append(this.priority).append("]");
        buffer.append(", [NumNodes: ").append(this.numNodes).append("]");
        buffer.append(", [MustReplicate: ").append(this.mustReplicate).append("]");
        buffer.append(", [MustDistribute: ").append(this.mustDistribute).append("]");
        buffer.append(", [").append(this.getName()).append("(");
        int numParams = this.parameters.length;
        if (this.hasTarget) {
            --numParams;
        }
        if (this.hasReturn) {
            --numParams;
        }
        if (numParams > 0) {
            buffer.append(this.parameters[0].getType());
            for (int i = 1; i < numParams; ++i) {
                buffer.append(", ").append(this.parameters[i].getType());
            }
        }
        buffer.append(")]");
        return buffer.toString();
    }
}

