/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations;

import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.MethodType;
import es.bsc.compss.types.resources.MethodResourceDescription;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class MPIImplementation
extends AbstractMethodImplementation
implements Externalizable {
    private static final long serialVersionUID = 1L;
    public static final int NUM_PARAMS = 3;
    private String mpiRunner;
    private String binary;
    private String workingDir;

    public MPIImplementation() {
    }

    public MPIImplementation(String binary, String workingDir, String mpiRunner, Integer coreId, Integer implementationId, String signature, MethodResourceDescription annot) {
        super(coreId, implementationId, signature, annot);
        this.mpiRunner = mpiRunner;
        this.workingDir = workingDir;
        this.binary = binary;
    }

    public String getBinary() {
        return this.binary;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public String getMpiRunner() {
        return this.mpiRunner;
    }

    @Override
    public MethodType getMethodType() {
        return MethodType.MPI;
    }

    @Override
    public String getMethodDefinition() {
        StringBuilder sb = new StringBuilder();
        sb.append("[MPI RUNNER=").append(this.mpiRunner);
        sb.append(", BINARY=").append(this.binary);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String toString() {
        return super.toString() + " MPI Method with binary " + this.binary + " and MPIrunner " + this.mpiRunner;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.mpiRunner = (String)in.readObject();
        this.binary = (String)in.readObject();
        this.workingDir = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.mpiRunner);
        out.writeObject(this.binary);
        out.writeObject(this.workingDir);
    }
}

