/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations;

import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.implementations.definition.ImplementationDefinition;
import es.bsc.compss.types.implementations.definition.ServiceDefinition;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.resources.ServiceResourceDescription;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;

public class ServiceImplementation
extends Implementation
implements Externalizable {
    private static final long serialVersionUID = 1L;
    public static final int NUM_PARAMS = 4;
    private String operation;

    public ServiceImplementation() {
    }

    public ServiceImplementation(Integer coreId, String namespace, String service, String port, String operation, String signature) {
        super(coreId, 0, signature, null);
        this.requirements = new ServiceResourceDescription(service, namespace, port, 1);
        this.operation = operation;
    }

    public String getOperation() {
        return this.operation;
    }

    public static String getSignature(String namespace, String serviceName, String portName, String operation, boolean hasTarget, int numReturns, List<Parameter> parameters) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(operation).append("(");
        int numPars = parameters.size();
        if (hasTarget) {
            --numPars;
        }
        if ((numPars -= numReturns) > 0) {
            buffer.append(parameters.get(0).getType());
            for (int i = 1; i < numPars; ++i) {
                buffer.append(",").append(parameters.get(i).getType());
            }
        }
        buffer.append(")").append(namespace).append(',').append(serviceName).append(',').append(portName);
        return buffer.toString();
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.SERVICE;
    }

    @Override
    public ServiceResourceDescription getRequirements() {
        return (ServiceResourceDescription)this.requirements;
    }

    public ImplementationDefinition<ServiceResourceDescription> getDefinition() {
        String namespace = this.getRequirements().getNamespace();
        String serviceName = this.getRequirements().getServiceName();
        String port = this.getRequirements().getPort();
        return new ServiceDefinition(this.signature, namespace, serviceName, this.operation, port);
    }

    @Override
    public String toString() {
        ServiceResourceDescription description = (ServiceResourceDescription)this.requirements;
        return super.toString() + " Service in namespace " + description.getNamespace() + " with name " + description.getPort() + " on port " + description.getPort() + "and operation " + this.operation;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.operation = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.operation);
    }
}

