/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util.parsers;

import es.bsc.compss.types.CoreElementDefinition;
import es.bsc.compss.types.annotations.Constraints;
import es.bsc.compss.types.annotations.Parameter;
import es.bsc.compss.types.annotations.SchedulerHints;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.annotations.parameter.StdIOStream;
import es.bsc.compss.types.annotations.parameter.Type;
import es.bsc.compss.types.annotations.task.Binary;
import es.bsc.compss.types.annotations.task.COMPSs;
import es.bsc.compss.types.annotations.task.Container;
import es.bsc.compss.types.annotations.task.Decaf;
import es.bsc.compss.types.annotations.task.HTTP;
import es.bsc.compss.types.annotations.task.MPI;
import es.bsc.compss.types.annotations.task.Method;
import es.bsc.compss.types.annotations.task.MultiNode;
import es.bsc.compss.types.annotations.task.OmpSs;
import es.bsc.compss.types.annotations.task.OpenCL;
import es.bsc.compss.types.annotations.task.Service;
import es.bsc.compss.types.annotations.task.repeatables.Binaries;
import es.bsc.compss.types.annotations.task.repeatables.Containers;
import es.bsc.compss.types.annotations.task.repeatables.Decafs;
import es.bsc.compss.types.annotations.task.repeatables.MPIs;
import es.bsc.compss.types.annotations.task.repeatables.Methods;
import es.bsc.compss.types.annotations.task.repeatables.MultiCOMPSs;
import es.bsc.compss.types.annotations.task.repeatables.MultiMultiNode;
import es.bsc.compss.types.annotations.task.repeatables.MultiOmpSs;
import es.bsc.compss.types.annotations.task.repeatables.OpenCLs;
import es.bsc.compss.types.annotations.task.repeatables.Services;
import es.bsc.compss.types.implementations.ImplementationDescription;
import es.bsc.compss.types.implementations.MethodType;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.implementations.definition.ContainerDefinition;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.util.EnvironmentLoader;
import es.bsc.compss.util.ErrorManager;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ITFParser {
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Components.TaskDispatcher.TaskScheduler");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();

    public static List<CoreElementDefinition> parseITFMethods(Class<?> annotItfClass) {
        LinkedList<CoreElementDefinition> updatedMethods = new LinkedList<CoreElementDefinition>();
        int coreCount = annotItfClass.getDeclaredMethods().length;
        if (DEBUG) {
            LOGGER.debug("Detected methods " + coreCount);
        }
        for (java.lang.reflect.Method m : annotItfClass.getDeclaredMethods()) {
            LOGGER.debug("Method = " + m);
            CoreElementDefinition ced = ITFParser.parseITFMethod(m);
            if (ced.getImplementations().isEmpty()) continue;
            updatedMethods.add(ced);
        }
        Collections.sort(updatedMethods);
        return updatedMethods;
    }

    private static CoreElementDefinition parseITFMethod(java.lang.reflect.Method m) {
        LOGGER.info("Evaluating method " + m.getName());
        StringBuilder calleeMethodSignature = new StringBuilder();
        String methodName = m.getName();
        calleeMethodSignature.append(methodName).append("(");
        ITFParser.checkMethodAnnotation(m);
        boolean hasNonNative = ITFParser.checkNonNativeAnnotation(m);
        boolean[] hasAnnotations = ITFParser.constructSignatureAndCheckParameters(m, hasNonNative, calleeMethodSignature);
        boolean hasStreams = hasAnnotations[0];
        boolean hasPrefixes = hasAnnotations[1];
        if (DEBUG) {
            LOGGER.debug("   * Method method " + methodName + " has " + m.getAnnotations().length + " annotations");
        }
        CoreElementDefinition ced = new CoreElementDefinition();
        ITFParser.checkDefinedImplementations(m, calleeMethodSignature, hasStreams, hasPrefixes, ced);
        ced.setCeSignature(calleeMethodSignature.toString());
        return ced;
    }

    private static void checkMethodAnnotation(java.lang.reflect.Method m) {
        for (Annotation annot : m.getAnnotations()) {
            if (annot.annotationType().getName().equals(Constraints.class.getName()) || annot.annotationType().getName().equals(Method.class.getName()) || annot.annotationType().getName().equals(Service.class.getName()) || annot.annotationType().getName().equals(HTTP.class.getName()) || annot.annotationType().getName().equals(Binary.class.getName()) || annot.annotationType().getName().equals(Container.class.getName()) || annot.annotationType().getName().equals(MPI.class.getName()) || annot.annotationType().getName().equals(Decaf.class.getName()) || annot.annotationType().getName().equals(COMPSs.class.getName()) || annot.annotationType().getName().equals(MultiNode.class.getName()) || annot.annotationType().getName().equals(OmpSs.class.getName()) || annot.annotationType().getName().equals(OpenCL.class.getName()) || annot.annotationType().getName().equals(Methods.class.getName()) || annot.annotationType().getName().equals(Services.class.getName()) || annot.annotationType().getName().equals(Binaries.class.getName()) || annot.annotationType().getName().equals(Containers.class.getName()) || annot.annotationType().getName().equals(MPIs.class.getName()) || annot.annotationType().getName().equals(Decafs.class.getName()) || annot.annotationType().getName().equals(MultiCOMPSs.class.getName()) || annot.annotationType().getName().equals(MultiMultiNode.class.getName()) || annot.annotationType().getName().equals(MultiOmpSs.class.getName()) || annot.annotationType().getName().equals(OpenCLs.class.getName()) || annot.annotationType().getName().equals(SchedulerHints.class.getName())) continue;
            ErrorManager.warn("Unrecognised annotation " + annot.annotationType().getName() + " . SKIPPING");
        }
    }

    private static boolean checkNonNativeAnnotation(java.lang.reflect.Method m) {
        for (Annotation annot : m.getAnnotations()) {
            if (!annot.annotationType().getName().equals(Binary.class.getName()) && !annot.annotationType().getName().equals(Container.class.getName()) && !annot.annotationType().getName().equals(MPI.class.getName()) && !annot.annotationType().getName().equals(Decaf.class.getName()) && !annot.annotationType().getName().equals(COMPSs.class.getName()) && !annot.annotationType().getName().equals(MultiNode.class.getName()) && !annot.annotationType().getName().equals(OmpSs.class.getName()) && !annot.annotationType().getName().equals(OpenCL.class.getName()) && !annot.annotationType().getName().equals(Binaries.class.getName()) && !annot.annotationType().getName().equals(Containers.class.getName()) && !annot.annotationType().getName().equals(MPIs.class.getName()) && !annot.annotationType().getName().equals(Decafs.class.getName()) && !annot.annotationType().getName().equals(MultiCOMPSs.class.getName()) && !annot.annotationType().getName().equals(MultiMultiNode.class.getName()) && !annot.annotationType().getName().equals(MultiOmpSs.class.getName()) && !annot.annotationType().getName().equals(OpenCLs.class.getName())) continue;
            return true;
        }
        return false;
    }

    private static boolean[] constructSignatureAndCheckParameters(java.lang.reflect.Method m, boolean hasNonNative, StringBuilder calleeMethodSignature) {
        boolean hasStreams = false;
        boolean hasPrefixes = false;
        String methodName = m.getName();
        boolean hasSTDIN = false;
        boolean hasSTDOUT = false;
        boolean hasSTDERR = false;
        int numPars = m.getParameterAnnotations().length;
        if (numPars > 0) {
            for (int i = 0; i < numPars; ++i) {
                Parameter par = (Parameter)m.getParameterAnnotations()[i][0];
                Class<?> parType = m.getParameterTypes()[i];
                Type annotType = par.type();
                String type = ITFParser.inferType(parType, annotType);
                if (i >= 1) {
                    calleeMethodSignature.append(",");
                }
                calleeMethodSignature.append(type);
                switch (par.stream()) {
                    case STDIN: {
                        if (hasSTDIN) {
                            ErrorManager.error("Method " + methodName + " has more than one parameter annotated has Stream.STDIN");
                        }
                        hasSTDIN = true;
                        break;
                    }
                    case STDOUT: {
                        if (hasSTDOUT) {
                            ErrorManager.error("Method " + methodName + " has more than one parameter annotated has Stream.STDOUT");
                        }
                        hasSTDOUT = true;
                        break;
                    }
                    case STDERR: {
                        if (hasSTDERR) {
                            ErrorManager.error("Method " + methodName + " has more than one parameter annotated has Stream.STDERR");
                        }
                        hasSTDERR = true;
                        break;
                    }
                }
                hasStreams = hasStreams || !par.stream().equals((Object)StdIOStream.UNSPECIFIED);
                hasPrefixes = hasPrefixes || !par.prefix().equals("null");
                ITFParser.checkParameterAnnotation(m, par, i, hasNonNative);
            }
        }
        calleeMethodSignature.append(")");
        boolean[] hasAnnotation = new boolean[]{hasStreams, hasPrefixes};
        return hasAnnotation;
    }

    private static String inferType(Class<?> formalType, Type annotType) {
        if (annotType.equals((Object)Type.UNSPECIFIED)) {
            if (formalType.isPrimitive()) {
                if (formalType.equals(Boolean.TYPE)) {
                    return "BOOLEAN_T";
                }
                if (formalType.equals(Character.TYPE)) {
                    return "CHAR_T";
                }
                if (formalType.equals(Byte.TYPE)) {
                    return "BYTE_T";
                }
                if (formalType.equals(Short.TYPE)) {
                    return "SHORT_T";
                }
                if (formalType.equals(Integer.TYPE)) {
                    return "INT_T";
                }
                if (formalType.equals(Long.TYPE)) {
                    return "LONG_T";
                }
                if (formalType.equals(Float.TYPE)) {
                    return "FLOAT_T";
                }
                return "DOUBLE_T";
            }
            return "OBJECT_T";
        }
        return annotType + "_T";
    }

    private static void checkParameterAnnotation(java.lang.reflect.Method m, Parameter par, int i, boolean hasNonNative) {
        String warningLocation = "In parameter number " + (i + 1) + " of method '" + m.getName() + "' in interface '" + m.getDeclaringClass().toString().replace("interface ", "") + "'.";
        Type annotType = par.type();
        Direction annotDirection = par.direction();
        StdIOStream stream = par.stream();
        boolean isOut = annotDirection.equals((Object)Direction.OUT);
        boolean isInOut = annotDirection.equals((Object)Direction.INOUT);
        if (annotType.equals((Object)Type.STRING)) {
            if (isOut || isInOut) {
                ErrorManager.warn("Can't specify a String with direction OUT/INOUT since they are immutable.\r\n" + warningLocation + "\r\n" + "Using direction=IN instead.");
            }
        } else if (m.getParameterTypes()[i].isPrimitive()) {
            if (isOut || isInOut) {
                String primType = m.getParameterTypes()[i].getName();
                ErrorManager.warn("Can't specify a primitive type ('" + primType + "') with direction OUT/INOUT, since they are always passed by value. " + "\r\n" + warningLocation + "\r\n" + "Using direction=IN instead.");
            }
        } else if (annotType.equals((Object)Type.OBJECT) && isOut) {
            ErrorManager.warn("Can't specify an Object with direction OUT.\r\n" + warningLocation + "\r\n" + "Using direction=INOUT instead.");
        }
        if (hasNonNative && !annotType.equals((Object)Type.FILE) && !annotType.equals((Object)Type.STREAM) && (isOut || isInOut)) {
            ErrorManager.error("Non-Native tasks only supports " + annotType.name() + " types in mode IN" + "\r\n" + warningLocation);
        }
        if (!stream.equals((Object)StdIOStream.UNSPECIFIED)) {
            if (!annotType.equals((Object)Type.FILE)) {
                ErrorManager.error("Can't specify an Stream with type different than File.\r\n" + warningLocation);
            }
            switch (stream) {
                case STDIN: {
                    if (!isOut && !isInOut) break;
                    ErrorManager.error("Stream STDIN must have direction IN\r\n" + warningLocation);
                    break;
                }
                case STDOUT: {
                    if (isOut || isInOut) break;
                    ErrorManager.error("Stream STDOUT must have direction OUT or INOUT\r\n" + warningLocation);
                    break;
                }
                case STDERR: {
                    if (isOut || isInOut) break;
                    ErrorManager.error("Stream STDERR must have direction OUT or INOUT\r\n" + warningLocation);
                    break;
                }
            }
        }
    }

    private static void checkDefinedImplementations(java.lang.reflect.Method m, StringBuilder calleeMethodSignature, boolean hasStreams, boolean hasPrefixes, CoreElementDefinition ced) {
        ImplementationDescription implDef;
        MethodResourceDescription implConstraints;
        String failByEVstr;
        String workingDir;
        String binary;
        String methodSignature;
        String declaringClass;
        MethodResourceDescription defaultConstraints = MethodResourceDescription.EMPTY_FOR_CONSTRAINTS.copy();
        if (m.isAnnotationPresent(Constraints.class)) {
            defaultConstraints = new MethodResourceDescription(m.getAnnotation(Constraints.class));
        }
        String methodName = m.getName();
        for (Method method : (Method[])m.getAnnotationsByType(Method.class)) {
            LOGGER.debug("   * Processing @Method annotation");
            if (hasStreams) {
                ErrorManager.warn("Java method " + methodName + " does not support stream annotations. SKIPPING stream annotation");
            }
            if (hasPrefixes) {
                ErrorManager.warn("Java method " + methodName + " does not support prefix annotations. SKIPPING prefix annotation");
            }
            declaringClass = method.declaringClass();
            methodSignature = calleeMethodSignature.toString() + declaringClass;
            MethodResourceDescription implConstraints3 = defaultConstraints;
            if (method.constraints() != null) {
                implConstraints3 = new MethodResourceDescription(method.constraints());
                implConstraints3.mergeMultiConstraints(defaultConstraints);
            }
            ImplementationDescription implDef3 = null;
            try {
                implDef3 = ImplementationDescription.defineImplementation(MethodType.METHOD.toString(), methodSignature, implConstraints3, declaringClass, methodName);
            }
            catch (Exception e) {
                ErrorManager.error(e.getMessage());
            }
            ced.addImplementation(implDef3);
        }
        for (Method method : (Service[])m.getAnnotationsByType(Service.class)) {
            LOGGER.debug("   * Processing @Service annotation");
            if (hasStreams) {
                ErrorManager.warn("Java service " + methodName + " does not support stream annotations. SKIPPING stream annotation");
            }
            calleeMethodSignature.append(method.namespace()).append(',');
            calleeMethodSignature.append(method.name()).append(',');
            calleeMethodSignature.append(method.port());
            String serviceSignature = calleeMethodSignature.toString();
            ImplementationDescription implDef4 = null;
            try {
                implDef4 = ImplementationDescription.defineImplementation(TaskType.SERVICE.toString(), serviceSignature, null, method.namespace(), method.name(), method.operation(), method.port());
            }
            catch (Exception e) {
                ErrorManager.error(e.getMessage());
            }
            ced.addImplementation(implDef4);
        }
        for (Method method : (HTTP[])m.getAnnotationsByType(HTTP.class)) {
            LOGGER.debug("   * Processing @HTTP annotation");
            if (hasStreams) {
                ErrorManager.warn("Java HTTP " + methodName + " does not support stream annotations. SKIPPING stream annotation");
            }
            calleeMethodSignature.insert(0, method.declaringClass() + ".");
            ImplementationDescription implDef5 = null;
            try {
                implDef5 = ImplementationDescription.defineImplementation(TaskType.HTTP.toString(), calleeMethodSignature.toString(), null, method.serviceName(), method.resource(), method.request(), method.payload(), method.payloadType(), method.produces());
            }
            catch (Exception e) {
                ErrorManager.error(e.getMessage());
            }
            ced.addImplementation(implDef5);
        }
        for (Method method : (Container[])m.getAnnotationsByType(Container.class)) {
            String engine = EnvironmentLoader.loadFromEnvironment(method.engine());
            String image = EnvironmentLoader.loadFromEnvironment(method.image());
            String internalExecutionTypeStr = EnvironmentLoader.loadFromEnvironment(method.executionType());
            String internalBinary = EnvironmentLoader.loadFromEnvironment(method.binary());
            String internalFunc = EnvironmentLoader.loadFromEnvironment(method.function());
            String hostDir = EnvironmentLoader.loadFromEnvironment(method.workingDir());
            String containerFailByExitValue = EnvironmentLoader.loadFromEnvironment(method.failByExitValue());
            if (image == null || image.isEmpty() || image.equals("[unassigned]")) {
                ErrorManager.error("Empty image annotation for method " + m.getName());
            }
            internalExecutionTypeStr = internalExecutionTypeStr.toUpperCase();
            ContainerDefinition.ContainerExecutionType internalExecutionType = null;
            try {
                internalExecutionType = ContainerDefinition.ContainerExecutionType.valueOf(internalExecutionTypeStr);
            }
            catch (IllegalArgumentException iae) {
                ErrorManager.error("Invalid container internal execution type for method " + m.getName());
            }
            switch (internalExecutionType) {
                case CET_BINARY: {
                    if (internalBinary != null && !internalBinary.isEmpty() && !internalBinary.equals("[unassigned]")) break;
                    ErrorManager.error("Empty binary annotation for method " + m.getName());
                    break;
                }
                case CET_PYTHON: {
                    if (internalFunc != null && !internalFunc.isEmpty() && !internalFunc.equals("[unassigned]")) break;
                    ErrorManager.error("Empty function annotation for method " + m.getName());
                }
            }
            String containerSignature = calleeMethodSignature.toString() + "container.CONTAINER";
            MethodResourceDescription implConstraints4 = defaultConstraints;
            if (method.constraints() != null) {
                implConstraints4 = new MethodResourceDescription(method.constraints());
                implConstraints4.mergeMultiConstraints(defaultConstraints);
            }
            ImplementationDescription implDef6 = null;
            try {
                implDef6 = ImplementationDescription.defineImplementation(MethodType.CONTAINER.toString(), containerSignature, implConstraints4, engine, image, internalExecutionTypeStr, internalBinary, internalFunc, hostDir, containerFailByExitValue);
            }
            catch (Exception e) {
                ErrorManager.error(e.getMessage());
            }
            ced.addImplementation(implDef6);
        }
        for (Method method : (Binary[])m.getAnnotationsByType(Binary.class)) {
            binary = EnvironmentLoader.loadFromEnvironment(method.binary());
            workingDir = EnvironmentLoader.loadFromEnvironment(method.workingDir());
            String failByEVstr2 = EnvironmentLoader.loadFromEnvironment(method.failByExitValue());
            if (binary == null || binary.isEmpty() || binary.equals("[unassigned]")) {
                ErrorManager.error("Empty binary annotation for method " + m.getName());
            }
            String binarySignature = calleeMethodSignature.toString() + "binary.BINARY";
            MethodResourceDescription implConstraints2 = defaultConstraints;
            if (method.constraints() != null) {
                implConstraints2 = new MethodResourceDescription(method.constraints());
                implConstraints2.mergeMultiConstraints(defaultConstraints);
            }
            ImplementationDescription implDef2 = null;
            try {
                implDef2 = ImplementationDescription.defineImplementation(MethodType.BINARY.toString(), binarySignature, implConstraints2, binary, workingDir, failByEVstr2);
            }
            catch (Exception e) {
                ErrorManager.error(e.getMessage(), e);
            }
            ced.addImplementation(implDef2);
        }
        for (Method method : (MPI[])m.getAnnotationsByType(MPI.class)) {
            LOGGER.debug("   * Processing @MPI annotation");
            binary = EnvironmentLoader.loadFromEnvironment(method.binary());
            workingDir = EnvironmentLoader.loadFromEnvironment(method.workingDir());
            String mpiRunner = EnvironmentLoader.loadFromEnvironment(method.mpiRunner());
            String mpiFlags = EnvironmentLoader.loadFromEnvironment(method.mpiFlags());
            String scaleByCUStr = Boolean.toString(method.scaleByCU());
            failByEVstr = Boolean.toString(method.failByExitValue());
            if (mpiRunner == null || mpiRunner.isEmpty()) {
                ErrorManager.error("Empty mpiRunner annotation for method " + m.getName());
            }
            if (binary == null || binary.isEmpty()) {
                ErrorManager.error("Empty binary annotation for method " + m.getName());
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Binary: " + binary);
                LOGGER.debug("mpiRunner: " + mpiRunner);
            }
            String mpiSignature = calleeMethodSignature.toString() + "mpi.MPI";
            implConstraints = defaultConstraints;
            if (method.constraints() != null) {
                implConstraints = new MethodResourceDescription(method.constraints());
                implConstraints.mergeMultiConstraints(defaultConstraints);
            }
            implDef = null;
            try {
                implDef = ImplementationDescription.defineImplementation(MethodType.MPI.toString(), mpiSignature, implConstraints, binary, workingDir, mpiRunner, mpiFlags, scaleByCUStr, failByEVstr);
            }
            catch (Exception e) {
                ErrorManager.error(e.getMessage());
            }
            ced.addImplementation(implDef);
        }
        for (Method method : (Decaf[])m.getAnnotationsByType(Decaf.class)) {
            LOGGER.debug("   * Processing @DECAF annotation");
            String dfScript = EnvironmentLoader.loadFromEnvironment(method.dfScript());
            String dfExecutor = EnvironmentLoader.loadFromEnvironment(method.dfExecutor());
            String dfLib = EnvironmentLoader.loadFromEnvironment(method.dfLib());
            String workingDir2 = EnvironmentLoader.loadFromEnvironment(method.workingDir());
            String mpiRunner = EnvironmentLoader.loadFromEnvironment(method.mpiRunner());
            failByEVstr = Boolean.toString(method.failByExitValue());
            if (mpiRunner == null || mpiRunner.isEmpty()) {
                ErrorManager.error("Empty mpiRunner annotation for method " + m.getName());
            }
            if (dfScript == null || dfScript.isEmpty()) {
                ErrorManager.error("Empty binary annotation for method " + m.getName());
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("DF Script: " + dfScript);
                LOGGER.debug("DF Executor: " + dfExecutor);
                LOGGER.debug("DF Lib: " + dfLib);
                LOGGER.debug("mpiRunner: " + mpiRunner);
            }
            String decafSignature = calleeMethodSignature.toString() + "decaf.DECAF";
            implConstraints = defaultConstraints;
            if (method.constraints() != null) {
                implConstraints = new MethodResourceDescription(method.constraints());
                implConstraints.mergeMultiConstraints(defaultConstraints);
            }
            implDef = null;
            try {
                implDef = ImplementationDescription.defineImplementation(MethodType.DECAF.toString(), decafSignature, implConstraints, dfScript, dfExecutor, dfLib, workingDir2, mpiRunner, failByEVstr);
            }
            catch (Exception e) {
                ErrorManager.error(e.getMessage());
            }
            ced.addImplementation(implDef);
        }
        for (Method method : (COMPSs[])m.getAnnotationsByType(COMPSs.class)) {
            LOGGER.debug("   * Processing @COMPSs annotation");
            String runcompss = EnvironmentLoader.loadFromEnvironment(method.runcompss());
            String flags = EnvironmentLoader.loadFromEnvironment(method.flags());
            String workerInMaster = EnvironmentLoader.loadFromEnvironment(method.workerInMaster());
            String appName = EnvironmentLoader.loadFromEnvironment(method.appName());
            String workingDir3 = EnvironmentLoader.loadFromEnvironment(method.workingDir());
            failByEVstr = Boolean.toString(method.failByExitValue());
            if (appName == null || appName.isEmpty()) {
                ErrorManager.error("Empty appName in COMPSs annotation for method " + m.getName());
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("runcompss: " + runcompss);
                LOGGER.debug("flags: " + flags);
                LOGGER.debug("workerInMaster: " + workerInMaster);
                LOGGER.debug("appName: " + appName);
            }
            String compssSignature = calleeMethodSignature.toString() + "compss.NESTED";
            implConstraints = defaultConstraints;
            if (method.constraints() != null) {
                implConstraints = new MethodResourceDescription(method.constraints());
                implConstraints.mergeMultiConstraints(defaultConstraints);
            }
            implDef = null;
            try {
                implDef = ImplementationDescription.defineImplementation(MethodType.COMPSs.toString(), compssSignature, implConstraints, runcompss, flags, appName, workerInMaster, workingDir3, failByEVstr);
            }
            catch (Exception e) {
                ErrorManager.error(e.getMessage());
            }
            ced.addImplementation(implDef);
        }
        for (Method method : (MultiNode[])m.getAnnotationsByType(MultiNode.class)) {
            LOGGER.debug("   * Processing @MultiNode annotation");
            if (hasStreams) {
                ErrorManager.warn("Java multi-node method " + methodName + " does not support stream annotations. SKIPPING stream annotation");
            }
            if (hasPrefixes) {
                ErrorManager.warn("Java multi-node method " + methodName + " does not support prefix annotations. SKIPPING prefix annotation");
            }
            declaringClass = method.declaringClass();
            methodSignature = calleeMethodSignature.toString() + declaringClass;
            MethodResourceDescription implConstraints2 = defaultConstraints;
            if (method.constraints() != null) {
                implConstraints2 = new MethodResourceDescription(method.constraints());
                implConstraints2.mergeMultiConstraints(defaultConstraints);
            }
            ImplementationDescription implDef2 = null;
            try {
                implDef2 = ImplementationDescription.defineImplementation(MethodType.MULTI_NODE.toString(), methodSignature, implConstraints2, declaringClass, methodName);
            }
            catch (Exception e) {
                ErrorManager.error(e.getMessage());
            }
            ced.addImplementation(implDef2);
        }
        for (Method method : (OmpSs[])m.getAnnotationsByType(OmpSs.class)) {
            LOGGER.debug("   * Processing @OmpSs annotation");
            binary = EnvironmentLoader.loadFromEnvironment(method.binary());
            workingDir = EnvironmentLoader.loadFromEnvironment(method.workingDir());
            String failByEVstr2 = Boolean.toString(method.failByExitValue());
            if (binary == null || binary.isEmpty()) {
                ErrorManager.error("Empty binary annotation for method " + m.getName());
            }
            String ompssSignature = calleeMethodSignature.toString() + "ompss.OMPSS";
            MethodResourceDescription implConstraints3 = defaultConstraints;
            if (method.constraints() != null) {
                implConstraints3 = new MethodResourceDescription(method.constraints());
                implConstraints3.mergeMultiConstraints(defaultConstraints);
            }
            ImplementationDescription implDef3 = null;
            try {
                implDef3 = ImplementationDescription.defineImplementation(MethodType.OMPSS.toString(), ompssSignature, implConstraints3, binary, workingDir, failByEVstr2);
            }
            catch (Exception e) {
                ErrorManager.error(e.getMessage());
            }
            ced.addImplementation(implDef3);
        }
        for (Method method : (OpenCL[])m.getAnnotationsByType(OpenCL.class)) {
            LOGGER.debug("   * Processing @OpenCL annotation");
            String kernel = EnvironmentLoader.loadFromEnvironment(method.kernel());
            workingDir = EnvironmentLoader.loadFromEnvironment(method.workingDir());
            if (kernel == null || kernel.isEmpty()) {
                ErrorManager.error("Empty kernel annotation for method " + m.getName());
            }
            String openclSignature = calleeMethodSignature.toString() + "opencl.OPENCL";
            MethodResourceDescription implConstraints5 = defaultConstraints;
            if (method.constraints() != null) {
                implConstraints5 = new MethodResourceDescription(method.constraints());
                implConstraints5.mergeMultiConstraints(defaultConstraints);
            }
            ImplementationDescription implDef7 = null;
            try {
                implDef7 = ImplementationDescription.defineImplementation(MethodType.OPENCL.toString(), openclSignature, implConstraints5, kernel, workingDir);
            }
            catch (Exception e) {
                ErrorManager.error(e.getMessage());
            }
            ced.addImplementation(implDef7);
        }
    }
}

