/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util.parsers;

import es.bsc.compss.types.CoreElementDefinition;
import es.bsc.compss.types.annotations.Constraints;
import es.bsc.compss.types.annotations.Epilog;
import es.bsc.compss.types.annotations.Parameter;
import es.bsc.compss.types.annotations.Prolog;
import es.bsc.compss.types.annotations.SchedulerHints;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.annotations.parameter.StdIOStream;
import es.bsc.compss.types.annotations.parameter.Type;
import es.bsc.compss.types.annotations.task.Binary;
import es.bsc.compss.types.annotations.task.COMPSs;
import es.bsc.compss.types.annotations.task.Container;
import es.bsc.compss.types.annotations.task.Decaf;
import es.bsc.compss.types.annotations.task.HTTP;
import es.bsc.compss.types.annotations.task.MPI;
import es.bsc.compss.types.annotations.task.Method;
import es.bsc.compss.types.annotations.task.MultiNode;
import es.bsc.compss.types.annotations.task.OmpSs;
import es.bsc.compss.types.annotations.task.OpenCL;
import es.bsc.compss.types.annotations.task.Service;
import es.bsc.compss.types.annotations.task.repeatables.Binaries;
import es.bsc.compss.types.annotations.task.repeatables.Containers;
import es.bsc.compss.types.annotations.task.repeatables.Decafs;
import es.bsc.compss.types.annotations.task.repeatables.MPIs;
import es.bsc.compss.types.annotations.task.repeatables.Methods;
import es.bsc.compss.types.annotations.task.repeatables.MultiCOMPSs;
import es.bsc.compss.types.annotations.task.repeatables.MultiMultiNode;
import es.bsc.compss.types.annotations.task.repeatables.MultiOmpSs;
import es.bsc.compss.types.annotations.task.repeatables.OpenCLs;
import es.bsc.compss.types.annotations.task.repeatables.Services;
import es.bsc.compss.types.implementations.ExecType;
import es.bsc.compss.types.implementations.ExecutionOrder;
import es.bsc.compss.types.implementations.ImplementationDescription;
import es.bsc.compss.types.implementations.MethodType;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.implementations.definition.ContainerDefinition;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.util.EnvironmentLoader;
import es.bsc.compss.util.ErrorManager;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ITFParser {
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Components.TaskDispatcher.TaskScheduler");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();

    public static List<CoreElementDefinition> parseITFMethods(Class<?> annotItfClass) {
        LinkedList<CoreElementDefinition> updatedMethods = new LinkedList<CoreElementDefinition>();
        int coreCount = annotItfClass.getDeclaredMethods().length;
        if (DEBUG) {
            LOGGER.debug("Detected methods " + coreCount);
        }
        for (java.lang.reflect.Method m : annotItfClass.getDeclaredMethods()) {
            LOGGER.debug("Method = " + m);
            CoreElementDefinition ced = ITFParser.parseITFMethod(m);
            if (ced.getImplementations().isEmpty()) continue;
            updatedMethods.add(ced);
        }
        Collections.sort(updatedMethods);
        return updatedMethods;
    }

    private static CoreElementDefinition parseITFMethod(java.lang.reflect.Method m) {
        LOGGER.info("Evaluating method " + m.getName());
        StringBuilder calleeMethodSignature = new StringBuilder();
        String methodName = m.getName();
        calleeMethodSignature.append(methodName).append("(");
        ITFParser.checkMethodAnnotation(m);
        boolean hasNonNative = ITFParser.checkNonNativeAnnotation(m);
        boolean[] hasAnnotations = ITFParser.constructSignatureAndCheckParameters(m, hasNonNative, calleeMethodSignature);
        boolean hasStreams = hasAnnotations[0];
        boolean hasPrefixes = hasAnnotations[1];
        if (DEBUG) {
            LOGGER.debug("   * Method method " + methodName + " has " + m.getAnnotations().length + " annotations");
        }
        CoreElementDefinition ced = new CoreElementDefinition();
        ITFParser.checkDefinedImplementations(m, calleeMethodSignature, hasStreams, hasPrefixes, ced);
        ced.setCeSignature(calleeMethodSignature.toString());
        return ced;
    }

    private static void checkMethodAnnotation(java.lang.reflect.Method m) {
        for (Annotation annot : m.getAnnotations()) {
            if (annot.annotationType().getName().equals(Constraints.class.getName()) || annot.annotationType().getName().equals(Method.class.getName()) || annot.annotationType().getName().equals(Service.class.getName()) || annot.annotationType().getName().equals(HTTP.class.getName()) || annot.annotationType().getName().equals(Binary.class.getName()) || annot.annotationType().getName().equals(Container.class.getName()) || annot.annotationType().getName().equals(MPI.class.getName()) || annot.annotationType().getName().equals(Decaf.class.getName()) || annot.annotationType().getName().equals(COMPSs.class.getName()) || annot.annotationType().getName().equals(MultiNode.class.getName()) || annot.annotationType().getName().equals(OmpSs.class.getName()) || annot.annotationType().getName().equals(OpenCL.class.getName()) || annot.annotationType().getName().equals(Methods.class.getName()) || annot.annotationType().getName().equals(Services.class.getName()) || annot.annotationType().getName().equals(Binaries.class.getName()) || annot.annotationType().getName().equals(Containers.class.getName()) || annot.annotationType().getName().equals(MPIs.class.getName()) || annot.annotationType().getName().equals(Decafs.class.getName()) || annot.annotationType().getName().equals(MultiCOMPSs.class.getName()) || annot.annotationType().getName().equals(MultiMultiNode.class.getName()) || annot.annotationType().getName().equals(MultiOmpSs.class.getName()) || annot.annotationType().getName().equals(OpenCLs.class.getName()) || annot.annotationType().getName().equals(SchedulerHints.class.getName())) continue;
            ErrorManager.warn("Unrecognised annotation " + annot.annotationType().getName() + " . SKIPPING");
        }
    }

    private static boolean checkNonNativeAnnotation(java.lang.reflect.Method m) {
        for (Annotation annot : m.getAnnotations()) {
            if (!annot.annotationType().getName().equals(Binary.class.getName()) && !annot.annotationType().getName().equals(Container.class.getName()) && !annot.annotationType().getName().equals(MPI.class.getName()) && !annot.annotationType().getName().equals(Decaf.class.getName()) && !annot.annotationType().getName().equals(COMPSs.class.getName()) && !annot.annotationType().getName().equals(MultiNode.class.getName()) && !annot.annotationType().getName().equals(OmpSs.class.getName()) && !annot.annotationType().getName().equals(OpenCL.class.getName()) && !annot.annotationType().getName().equals(Binaries.class.getName()) && !annot.annotationType().getName().equals(Containers.class.getName()) && !annot.annotationType().getName().equals(MPIs.class.getName()) && !annot.annotationType().getName().equals(Decafs.class.getName()) && !annot.annotationType().getName().equals(MultiCOMPSs.class.getName()) && !annot.annotationType().getName().equals(MultiMultiNode.class.getName()) && !annot.annotationType().getName().equals(MultiOmpSs.class.getName()) && !annot.annotationType().getName().equals(OpenCLs.class.getName())) continue;
            return true;
        }
        return false;
    }

    private static boolean[] constructSignatureAndCheckParameters(java.lang.reflect.Method m, boolean hasNonNative, StringBuilder calleeMethodSignature) {
        boolean hasStreams = false;
        boolean hasPrefixes = false;
        String methodName = m.getName();
        boolean hasSTDIN = false;
        boolean hasSTDOUT = false;
        boolean hasSTDERR = false;
        int numPars = m.getParameterAnnotations().length;
        if (numPars > 0) {
            for (int i = 0; i < numPars; ++i) {
                Parameter par = (Parameter)m.getParameterAnnotations()[i][0];
                Class<?> parType = m.getParameterTypes()[i];
                Type annotType = par.type();
                String type = ITFParser.inferType(parType, annotType);
                if (i >= 1) {
                    calleeMethodSignature.append(",");
                }
                calleeMethodSignature.append(type);
                switch (par.stream()) {
                    case STDIN: {
                        if (hasSTDIN) {
                            ErrorManager.error("Method " + methodName + " has more than one parameter annotated has Stream.STDIN");
                        }
                        hasSTDIN = true;
                        break;
                    }
                    case STDOUT: {
                        if (hasSTDOUT) {
                            ErrorManager.error("Method " + methodName + " has more than one parameter annotated has Stream.STDOUT");
                        }
                        hasSTDOUT = true;
                        break;
                    }
                    case STDERR: {
                        if (hasSTDERR) {
                            ErrorManager.error("Method " + methodName + " has more than one parameter annotated has Stream.STDERR");
                        }
                        hasSTDERR = true;
                        break;
                    }
                }
                hasStreams = hasStreams || !par.stream().equals((Object)StdIOStream.UNSPECIFIED);
                hasPrefixes = hasPrefixes || !par.prefix().equals("null");
                ITFParser.checkParameterAnnotation(m, par, i, hasNonNative);
            }
        }
        calleeMethodSignature.append(")");
        boolean[] hasAnnotation = new boolean[]{hasStreams, hasPrefixes};
        return hasAnnotation;
    }

    private static String inferType(Class<?> formalType, Type annotType) {
        if (annotType.equals((Object)Type.UNSPECIFIED)) {
            if (formalType.isPrimitive()) {
                if (formalType.equals(Boolean.TYPE)) {
                    return "BOOLEAN_T";
                }
                if (formalType.equals(Character.TYPE)) {
                    return "CHAR_T";
                }
                if (formalType.equals(Byte.TYPE)) {
                    return "BYTE_T";
                }
                if (formalType.equals(Short.TYPE)) {
                    return "SHORT_T";
                }
                if (formalType.equals(Integer.TYPE)) {
                    return "INT_T";
                }
                if (formalType.equals(Long.TYPE)) {
                    return "LONG_T";
                }
                if (formalType.equals(Float.TYPE)) {
                    return "FLOAT_T";
                }
                return "DOUBLE_T";
            }
            return "OBJECT_T";
        }
        return annotType + "_T";
    }

    private static void checkParameterAnnotation(java.lang.reflect.Method m, Parameter par, int i, boolean hasNonNative) {
        String warningLocation = "In parameter number " + (i + 1) + " of method '" + m.getName() + "' in interface '" + m.getDeclaringClass().toString().replace("interface ", "") + "'.";
        Type annotType = par.type();
        Direction annotDirection = par.direction();
        StdIOStream stream = par.stream();
        boolean isOut = annotDirection.equals((Object)Direction.OUT);
        boolean isInOut = annotDirection.equals((Object)Direction.INOUT);
        if (annotType.equals((Object)Type.STRING)) {
            if (isOut || isInOut) {
                ErrorManager.warn("Can't specify a String with direction OUT/INOUT since they are immutable.\r\n" + warningLocation + "\r\n" + "Using direction=IN instead.");
            }
        } else if (m.getParameterTypes()[i].isPrimitive()) {
            if (isOut || isInOut) {
                String primType = m.getParameterTypes()[i].getName();
                ErrorManager.warn("Can't specify a primitive type ('" + primType + "') with direction OUT/INOUT, since they are always passed by value. " + "\r\n" + warningLocation + "\r\n" + "Using direction=IN instead.");
            }
        } else if (annotType.equals((Object)Type.OBJECT) && isOut) {
            ErrorManager.warn("Can't specify an Object with direction OUT.\r\n" + warningLocation + "\r\n" + "Using direction=INOUT instead.");
        }
        if (hasNonNative && !annotType.equals((Object)Type.FILE) && !annotType.equals((Object)Type.STREAM) && (isOut || isInOut)) {
            ErrorManager.error("Non-Native tasks only supports " + annotType.name() + " types in mode IN" + "\r\n" + warningLocation);
        }
        if (!stream.equals((Object)StdIOStream.UNSPECIFIED)) {
            if (!annotType.equals((Object)Type.FILE)) {
                ErrorManager.error("Can't specify an Stream with type different than File.\r\n" + warningLocation);
            }
            switch (stream) {
                case STDIN: {
                    if (!isOut && !isInOut) break;
                    ErrorManager.error("Stream STDIN must have direction IN\r\n" + warningLocation);
                    break;
                }
                case STDOUT: {
                    if (isOut || isInOut) break;
                    ErrorManager.error("Stream STDOUT must have direction OUT or INOUT\r\n" + warningLocation);
                    break;
                }
                case STDERR: {
                    if (isOut || isInOut) break;
                    ErrorManager.error("Stream STDERR must have direction OUT or INOUT\r\n" + warningLocation);
                    break;
                }
            }
        }
    }

    private static void checkDefinedImplementations(java.lang.reflect.Method m, StringBuilder calleeMethodSignature, boolean hasStreams, boolean hasPrefixes, CoreElementDefinition ced) {
        ImplementationDescription implDef;
        Constraints implConstraintsAnnot;
        MethodResourceDescription implConstraints;
        String failByEVstr;
        String workingDir;
        String binary;
        boolean implProcessLocal;
        String methodSignature;
        String declaringClass;
        MethodResourceDescription defaultConstraints = MethodResourceDescription.EMPTY_FOR_CONSTRAINTS.copy();
        boolean processLocalGeneral = false;
        if (m.isAnnotationPresent(Constraints.class)) {
            Constraints generalConstraints = m.getAnnotation(Constraints.class);
            processLocalGeneral = generalConstraints.isLocal();
            defaultConstraints = new MethodResourceDescription(generalConstraints);
        }
        ExecType prolog = null;
        if (m.isAnnotationPresent(Prolog.class)) {
            Prolog pAnnot = m.getAnnotation(Prolog.class);
            prolog = new ExecType(ExecutionOrder.PROLOG, pAnnot.binary(), pAnnot.params(), pAnnot.failByExitValue());
        }
        ExecType epilog = null;
        if (m.isAnnotationPresent(Epilog.class)) {
            Epilog eAnnot = m.getAnnotation(Epilog.class);
            epilog = new ExecType(ExecutionOrder.EPILOG, eAnnot.binary(), eAnnot.params(), eAnnot.failByExitValue());
        }
        String methodName = m.getName();
        for (Method method : (Method[])m.getAnnotationsByType(Method.class)) {
            LOGGER.debug("   * Processing @Method annotation");
            if (hasStreams) {
                ErrorManager.warn("Java method " + methodName + " does not support stream annotations. SKIPPING stream annotation");
            }
            if (hasPrefixes) {
                ErrorManager.warn("Java method " + methodName + " does not support prefix annotations. SKIPPING prefix annotation");
            }
            declaringClass = method.declaringClass();
            methodSignature = calleeMethodSignature.toString() + declaringClass;
            MethodResourceDescription implConstraints3 = defaultConstraints;
            boolean implProcessLocal2 = processLocalGeneral;
            if (method.constraints() != null) {
                Constraints implConstraintsAnnot3 = method.constraints();
                implProcessLocal2 = processLocalGeneral || implConstraintsAnnot3.isLocal();
                implConstraints3 = new MethodResourceDescription(implConstraintsAnnot3);
                implConstraints3.mergeMultiConstraints(defaultConstraints);
            }
            ImplementationDescription implDef3 = null;
            try {
                implDef3 = ImplementationDescription.defineImplementation(MethodType.METHOD.toString(), methodSignature, implProcessLocal2, implConstraints3, prolog, epilog, declaringClass, methodName);
            }
            catch (Exception e) {
                ErrorManager.error(e.getMessage());
            }
            ced.addImplementation(implDef3);
        }
        for (Method method : (Service[])m.getAnnotationsByType(Service.class)) {
            LOGGER.debug("   * Processing @Service annotation");
            if (hasStreams) {
                ErrorManager.warn("Java service " + methodName + " does not support stream annotations. SKIPPING stream annotation");
            }
            calleeMethodSignature.append(method.namespace()).append(',');
            calleeMethodSignature.append(method.name()).append(',');
            calleeMethodSignature.append(method.port());
            String serviceSignature = calleeMethodSignature.toString();
            ImplementationDescription implDef4 = null;
            try {
                implDef4 = ImplementationDescription.defineImplementation(TaskType.SERVICE.toString(), serviceSignature, false, null, prolog, epilog, method.namespace(), method.name(), method.operation(), method.port());
            }
            catch (Exception e) {
                ErrorManager.error(e.getMessage());
            }
            ced.addImplementation(implDef4);
        }
        for (Method method : (HTTP[])m.getAnnotationsByType(HTTP.class)) {
            LOGGER.debug("   * Processing @HTTP annotation");
            if (hasStreams) {
                ErrorManager.warn("Java HTTP " + methodName + " does not support stream annotations. SKIPPING stream annotation");
            }
            calleeMethodSignature.insert(0, method.declaringClass() + ".");
            ImplementationDescription implDef5 = null;
            try {
                implDef5 = ImplementationDescription.defineImplementation(TaskType.HTTP.toString(), calleeMethodSignature.toString(), false, null, prolog, epilog, method.serviceName(), method.resource(), method.request(), method.payload(), method.payloadType(), method.produces(), method.updates());
            }
            catch (Exception e) {
                ErrorManager.error(e.getMessage());
            }
            ced.addImplementation(implDef5);
        }
        for (Method method : (Container[])m.getAnnotationsByType(Container.class)) {
            String engine = EnvironmentLoader.loadFromEnvironment(method.engine());
            String image = EnvironmentLoader.loadFromEnvironment(method.image());
            String internalExecutionTypeStr = EnvironmentLoader.loadFromEnvironment(method.executionType());
            String internalBinary = EnvironmentLoader.loadFromEnvironment(method.binary());
            String internalFunc = EnvironmentLoader.loadFromEnvironment(method.function());
            String hostDir = EnvironmentLoader.loadFromEnvironment(method.workingDir());
            String containerFailByExitValue = EnvironmentLoader.loadFromEnvironment(method.failByExitValue());
            if (image == null || image.isEmpty() || image.equals("[unassigned]")) {
                ErrorManager.error("Empty image annotation for method " + m.getName());
            }
            internalExecutionTypeStr = internalExecutionTypeStr.toUpperCase();
            ContainerDefinition.ContainerExecutionType internalExecutionType = null;
            try {
                internalExecutionType = ContainerDefinition.ContainerExecutionType.valueOf(internalExecutionTypeStr);
            }
            catch (IllegalArgumentException iae) {
                ErrorManager.error("Invalid container internal execution type for method " + m.getName());
            }
            switch (internalExecutionType) {
                case CET_BINARY: {
                    if (internalBinary != null && !internalBinary.isEmpty() && !internalBinary.equals("[unassigned]")) break;
                    ErrorManager.error("Empty binary annotation for method " + m.getName());
                    break;
                }
                case CET_PYTHON: {
                    if (internalFunc != null && !internalFunc.isEmpty() && !internalFunc.equals("[unassigned]")) break;
                    ErrorManager.error("Empty function annotation for method " + m.getName());
                }
            }
            String containerSignature = calleeMethodSignature.toString() + "container.CONTAINER";
            MethodResourceDescription implConstraints2 = defaultConstraints;
            implProcessLocal = processLocalGeneral;
            if (method.constraints() != null) {
                Constraints implConstraintsAnnot2 = method.constraints();
                implProcessLocal = processLocalGeneral || implConstraintsAnnot2.isLocal();
                implConstraints2 = new MethodResourceDescription(implConstraintsAnnot2);
                implConstraints2.mergeMultiConstraints(defaultConstraints);
            }
            ImplementationDescription implDef2 = null;
            try {
                implDef2 = ImplementationDescription.defineImplementation(MethodType.CONTAINER.toString(), containerSignature, implProcessLocal, implConstraints2, prolog, epilog, engine, image, internalExecutionTypeStr, internalBinary, internalFunc, hostDir, containerFailByExitValue);
            }
            catch (Exception e) {
                ErrorManager.error(e.getMessage());
            }
            ced.addImplementation(implDef2);
        }
        for (Method method : (Binary[])m.getAnnotationsByType(Binary.class)) {
            binary = EnvironmentLoader.loadFromEnvironment(method.binary());
            workingDir = EnvironmentLoader.loadFromEnvironment(method.workingDir());
            String params = EnvironmentLoader.loadFromEnvironment(method.params());
            String failByEVstr2 = EnvironmentLoader.loadFromEnvironment(method.failByExitValue());
            if (binary == null || binary.isEmpty() || binary.equals("[unassigned]")) {
                ErrorManager.error("Empty binary annotation for method " + m.getName());
            }
            String binarySignature = calleeMethodSignature.toString() + "binary.BINARY";
            MethodResourceDescription implConstraints4 = defaultConstraints;
            boolean implProcessLocal3 = processLocalGeneral;
            if (method.constraints() != null) {
                Constraints implConstraintsAnnot4 = method.constraints();
                implProcessLocal3 = processLocalGeneral || implConstraintsAnnot4.isLocal();
                implConstraints4 = new MethodResourceDescription(implConstraintsAnnot4);
                implConstraints4.mergeMultiConstraints(defaultConstraints);
            }
            ImplementationDescription implDef6 = null;
            try {
                implDef6 = ImplementationDescription.defineImplementation(MethodType.BINARY.toString(), binarySignature, implProcessLocal3, implConstraints4, prolog, epilog, binary, workingDir, params, failByEVstr2);
            }
            catch (Exception e) {
                ErrorManager.error(e.getMessage(), e);
            }
            ced.addImplementation(implDef6);
        }
        for (Method method : (MPI[])m.getAnnotationsByType(MPI.class)) {
            LOGGER.debug("   * Processing @MPI annotation");
            binary = EnvironmentLoader.loadFromEnvironment(method.binary());
            workingDir = EnvironmentLoader.loadFromEnvironment(method.workingDir());
            String mpiRunner = EnvironmentLoader.loadFromEnvironment(method.mpiRunner());
            String mpiPPN = EnvironmentLoader.loadFromEnvironment(method.processesPerNode());
            String mpiFlags = EnvironmentLoader.loadFromEnvironment(method.mpiFlags());
            String scaleByCUStr = Boolean.toString(method.scaleByCU());
            String params = EnvironmentLoader.loadFromEnvironment(method.params());
            String failByEVstr3 = Boolean.toString(method.failByExitValue());
            if (mpiRunner == null || mpiRunner.isEmpty()) {
                ErrorManager.error("Empty mpiRunner annotation for method " + m.getName());
            }
            if (binary == null || binary.isEmpty()) {
                ErrorManager.error("Empty binary annotation for method " + m.getName());
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Binary: " + binary);
                LOGGER.debug("mpiRunner: " + mpiRunner);
            }
            String mpiSignature = calleeMethodSignature.toString() + "mpi.MPI";
            MethodResourceDescription implConstraints2 = defaultConstraints;
            implProcessLocal = processLocalGeneral;
            if (method.constraints() != null) {
                Constraints implConstraintsAnnot2 = method.constraints();
                implProcessLocal = processLocalGeneral || implConstraintsAnnot2.isLocal();
                implConstraints2 = new MethodResourceDescription(implConstraintsAnnot2);
                implConstraints2.mergeMultiConstraints(defaultConstraints);
            }
            ImplementationDescription implDef2 = null;
            try {
                implDef2 = ImplementationDescription.defineImplementation(MethodType.MPI.toString(), mpiSignature, implProcessLocal, implConstraints2, prolog, epilog, binary, workingDir, mpiRunner, mpiPPN, mpiFlags, scaleByCUStr, params, failByEVstr3);
            }
            catch (Exception e) {
                ErrorManager.error(e.getMessage());
            }
            ced.addImplementation(implDef2);
        }
        for (Method method : (Decaf[])m.getAnnotationsByType(Decaf.class)) {
            LOGGER.debug("   * Processing @DECAF annotation");
            String dfScript = EnvironmentLoader.loadFromEnvironment(method.dfScript());
            String dfExecutor = EnvironmentLoader.loadFromEnvironment(method.dfExecutor());
            String dfLib = EnvironmentLoader.loadFromEnvironment(method.dfLib());
            String workingDir2 = EnvironmentLoader.loadFromEnvironment(method.workingDir());
            String mpiRunner = EnvironmentLoader.loadFromEnvironment(method.mpiRunner());
            failByEVstr = Boolean.toString(method.failByExitValue());
            if (mpiRunner == null || mpiRunner.isEmpty()) {
                ErrorManager.error("Empty mpiRunner annotation for method " + m.getName());
            }
            if (dfScript == null || dfScript.isEmpty()) {
                ErrorManager.error("Empty binary annotation for method " + m.getName());
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("DF Script: " + dfScript);
                LOGGER.debug("DF Executor: " + dfExecutor);
                LOGGER.debug("DF Lib: " + dfLib);
                LOGGER.debug("mpiRunner: " + mpiRunner);
            }
            String decafSignature = calleeMethodSignature.toString() + "decaf.DECAF";
            implConstraints = defaultConstraints;
            boolean implProcessLocal4 = processLocalGeneral;
            if (method.constraints() != null) {
                implConstraintsAnnot = method.constraints();
                implProcessLocal4 = processLocalGeneral || implConstraintsAnnot.isLocal();
                implConstraints = new MethodResourceDescription(implConstraintsAnnot);
                implConstraints.mergeMultiConstraints(defaultConstraints);
            }
            implDef = null;
            try {
                implDef = ImplementationDescription.defineImplementation(MethodType.DECAF.toString(), decafSignature, implProcessLocal4, implConstraints, prolog, epilog, dfScript, dfExecutor, dfLib, workingDir2, mpiRunner, failByEVstr);
            }
            catch (Exception e) {
                ErrorManager.error(e.getMessage());
            }
            ced.addImplementation(implDef);
        }
        for (Method method : (COMPSs[])m.getAnnotationsByType(COMPSs.class)) {
            LOGGER.debug("   * Processing @COMPSs annotation");
            String runcompss = EnvironmentLoader.loadFromEnvironment(method.runcompss());
            String flags = EnvironmentLoader.loadFromEnvironment(method.flags());
            String workerInMaster = EnvironmentLoader.loadFromEnvironment(method.workerInMaster());
            String appName = EnvironmentLoader.loadFromEnvironment(method.appName());
            String workingDir3 = EnvironmentLoader.loadFromEnvironment(method.workingDir());
            failByEVstr = Boolean.toString(method.failByExitValue());
            if (appName == null || appName.isEmpty()) {
                ErrorManager.error("Empty appName in COMPSs annotation for method " + m.getName());
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("runcompss: " + runcompss);
                LOGGER.debug("flags: " + flags);
                LOGGER.debug("workerInMaster: " + workerInMaster);
                LOGGER.debug("appName: " + appName);
            }
            String compssSignature = calleeMethodSignature.toString() + "compss.NESTED";
            implConstraints = defaultConstraints;
            boolean implProcessLocal5 = processLocalGeneral;
            if (method.constraints() != null) {
                implConstraintsAnnot = method.constraints();
                implProcessLocal5 = processLocalGeneral || implConstraintsAnnot.isLocal();
                implConstraints = new MethodResourceDescription(implConstraintsAnnot);
                implConstraints.mergeMultiConstraints(defaultConstraints);
            }
            implDef = null;
            try {
                implDef = ImplementationDescription.defineImplementation(MethodType.COMPSs.toString(), compssSignature, implProcessLocal5, implConstraints, prolog, epilog, runcompss, flags, appName, workerInMaster, workingDir3, failByEVstr);
            }
            catch (Exception e) {
                ErrorManager.error(e.getMessage());
            }
            ced.addImplementation(implDef);
        }
        for (Method method : (MultiNode[])m.getAnnotationsByType(MultiNode.class)) {
            LOGGER.debug("   * Processing @MultiNode annotation");
            if (hasStreams) {
                ErrorManager.warn("Java multi-node method " + methodName + " does not support stream annotations. SKIPPING stream annotation");
            }
            if (hasPrefixes) {
                ErrorManager.warn("Java multi-node method " + methodName + " does not support prefix annotations. SKIPPING prefix annotation");
            }
            declaringClass = method.declaringClass();
            methodSignature = calleeMethodSignature.toString() + declaringClass;
            MethodResourceDescription implConstraints3 = defaultConstraints;
            boolean implProcessLocal6 = processLocalGeneral;
            if (method.constraints() != null) {
                Constraints implConstraintsAnnot3 = method.constraints();
                implProcessLocal6 = processLocalGeneral || implConstraintsAnnot3.isLocal();
                implConstraints3 = new MethodResourceDescription(implConstraintsAnnot3);
                implConstraints3.mergeMultiConstraints(defaultConstraints);
            }
            ImplementationDescription implDef3 = null;
            try {
                implDef3 = ImplementationDescription.defineImplementation(MethodType.MULTI_NODE.toString(), methodSignature, implProcessLocal6, implConstraints3, prolog, epilog, declaringClass, methodName);
            }
            catch (Exception e) {
                ErrorManager.error(e.getMessage());
            }
            ced.addImplementation(implDef3);
        }
        for (Method method : (OmpSs[])m.getAnnotationsByType(OmpSs.class)) {
            LOGGER.debug("   * Processing @OmpSs annotation");
            binary = EnvironmentLoader.loadFromEnvironment(method.binary());
            workingDir = EnvironmentLoader.loadFromEnvironment(method.workingDir());
            String failByEVstr4 = Boolean.toString(method.failByExitValue());
            if (binary == null || binary.isEmpty()) {
                ErrorManager.error("Empty binary annotation for method " + m.getName());
            }
            String ompssSignature = calleeMethodSignature.toString() + "ompss.OMPSS";
            MethodResourceDescription implConstraints5 = defaultConstraints;
            boolean implProcessLocal7 = processLocalGeneral;
            if (method.constraints() != null) {
                Constraints implConstraintsAnnot5 = method.constraints();
                implProcessLocal7 = processLocalGeneral || implConstraintsAnnot5.isLocal();
                implConstraints5 = new MethodResourceDescription(implConstraintsAnnot5);
                implConstraints5.mergeMultiConstraints(defaultConstraints);
            }
            ImplementationDescription implDef7 = null;
            try {
                implDef7 = ImplementationDescription.defineImplementation(MethodType.OMPSS.toString(), ompssSignature, implProcessLocal7, implConstraints5, prolog, epilog, binary, workingDir, failByEVstr4);
            }
            catch (Exception e) {
                ErrorManager.error(e.getMessage());
            }
            ced.addImplementation(implDef7);
        }
        for (Method method : (OpenCL[])m.getAnnotationsByType(OpenCL.class)) {
            LOGGER.debug("   * Processing @OpenCL annotation");
            String kernel = EnvironmentLoader.loadFromEnvironment(method.kernel());
            workingDir = EnvironmentLoader.loadFromEnvironment(method.workingDir());
            if (kernel == null || kernel.isEmpty()) {
                ErrorManager.error("Empty kernel annotation for method " + m.getName());
            }
            String openclSignature = calleeMethodSignature.toString() + "opencl.OPENCL";
            MethodResourceDescription implConstraints6 = defaultConstraints;
            boolean implProcessLocal8 = processLocalGeneral;
            if (method.constraints() != null) {
                Constraints implConstraintsAnnot6 = method.constraints();
                implProcessLocal8 = processLocalGeneral || implConstraintsAnnot6.isLocal();
                implConstraints6 = new MethodResourceDescription(implConstraintsAnnot6);
                implConstraints6.mergeMultiConstraints(defaultConstraints);
            }
            ImplementationDescription implDef8 = null;
            try {
                implDef8 = ImplementationDescription.defineImplementation(MethodType.OPENCL.toString(), openclSignature, implProcessLocal8, implConstraints6, prolog, epilog, kernel, workingDir);
            }
            catch (Exception e) {
                ErrorManager.error(e.getMessage());
            }
            ced.addImplementation(implDef8);
        }
    }
}

