/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.log;

import es.bsc.compss.COMPSsDefaults;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.FileOperations;
import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;

public class LoggerManager {
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.API");
    private static final int MAX_OVERLOAD = 100;
    private static final String ERROR_COMPSS_LOG_BASE_DIR = "ERROR: Cannot create .COMPSs base log directory";
    private static final String ERROR_APP_OVERLOAD = "ERROR: Cannot erase overloaded directory";
    private static final String ERROR_APP_LOG_DIR = "ERROR: Cannot create application log directory";
    private static final String WARN_FOLDER_OVERLOAD = "WARNING: Reached maximum number of executions for this application. To avoid this warning please clean .COMPSs folder";
    private static final String ERROR_JOBS_DIR = "ERROR: Cannot create jobs directory";
    private static final String ERROR_WORKERS_DIR = "ERROR: Cannot create workers directory";
    private static boolean loggerAlreadyLoaded = false;
    private static final String logDir;
    private static final String jobsLogDir;
    private static final String workersLogDir;

    private LoggerManager() {
    }

    public static void init() {
        if (loggerAlreadyLoaded) {
            LOGGER.debug("LoggerManager already initialized, no need for a second initialization");
            return;
        }
        loggerAlreadyLoaded = true;
        System.setProperty("compss.log.dir", logDir);
        ((LoggerContext)LogManager.getContext((boolean)false)).reconfigure();
        if (!new File(jobsLogDir).mkdirs()) {
            ErrorManager.error(ERROR_JOBS_DIR);
        }
        if (!new File(workersLogDir).mkdirs()) {
            ErrorManager.error(ERROR_WORKERS_DIR);
        }
    }

    public static String getLogDir() {
        return logDir;
    }

    public static String getJobsLogDir() {
        return jobsLogDir;
    }

    public static String getWorkersLogDir() {
        return workersLogDir;
    }

    static {
        String log = System.getProperty("compss.log.dir");
        if (log != null && !log.isEmpty()) {
            String string = log = log.endsWith(File.separator) ? log : log + File.separator;
            if (!new File(log).exists() && !new File(log).mkdirs()) {
                ErrorManager.error("ERROR: Cannot create application log directory at " + log);
            }
        } else {
            log = COMPSsDefaults.LOG_DIR;
            if (!new File(log).exists() && !new File(log).mkdirs()) {
                ErrorManager.error("ERROR: Cannot create .COMPSs base log directory at " + log);
            }
            log = log.endsWith(File.separator) ? log : log + File.separator;
            String appName = System.getProperty("compss.serviceName") != null ? System.getProperty("compss.serviceName") : System.getProperty("compss.appName");
            log = log + appName;
            String oldest = null;
            long lastModified = System.currentTimeMillis();
            boolean created = false;
            for (int overloadCode = 1; !created && overloadCode < 100; ++overloadCode) {
                String appLog = log + "_" + String.format("%02d", overloadCode) + File.separator;
                if (new File(appLog).exists()) {
                    long modified = new File(appLog).lastModified();
                    if (lastModified <= modified) continue;
                    oldest = appLog;
                    continue;
                }
                created = new File(appLog).mkdirs();
                log = appLog;
            }
            if (!created) {
                log = oldest;
                System.err.println(WARN_FOLDER_OVERLOAD);
                System.err.println("Overwriting entry: " + log);
                try {
                    File f = new File(log);
                    FileOperations.deleteFile(f, null);
                    if (!f.mkdir()) {
                        ErrorManager.error(ERROR_APP_LOG_DIR);
                    }
                }
                catch (Exception e) {
                    ErrorManager.error(ERROR_APP_OVERLOAD);
                }
            }
        }
        logDir = log;
        jobsLogDir = logDir + "jobs" + File.separator;
        workersLogDir = logDir + "workers" + File.separator;
    }
}

