/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations.definition;

import es.bsc.compss.COMPSsPaths;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommonMPIDefinition {
    protected static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Worker.Executor.Invoker");
    public static final String IB_SUFFIX = "-ib0";
    private static final String ERROR_MPI_RUNNER = "ERROR: Empty runner annotation for MPI method";
    private static final String ERROR_MPI_PPN = "ERROR: Processes per node is lower than 1 for MPI method";
    private static final String DEFAULT_HOSTFILE = "true";
    private static final String DEFAULT_SINGLE_HOST = "true";
    private static final String DEFAULT_HOSTS_FLAG = "-hostfile";
    private static final String DEFAULT_PROCS_SEPARATOR = "";
    private static final String DEFAULT_HOSTS_SEPARATOR = "\n";
    private static final int DEFAULT_PPN = 1;
    protected String mpiRunner;
    protected int ppn = 1;
    protected String mpiFlags;
    protected String workingDir;
    protected boolean scaleByCU;
    protected boolean failByEV;
    private String hostsFlag = "-hostfile";
    private boolean hostfile = Boolean.parseBoolean("true");
    private String processesSeparator = "";
    private String hostsSeparator = "\n";
    private boolean singleHostNoProcesses = Boolean.parseBoolean("true");

    public CommonMPIDefinition() {
    }

    public CommonMPIDefinition(String workingDir, String mpiRunner, int ppn, String mpiFlags, boolean scaleByCU, boolean failByEV) {
        this.mpiRunner = mpiRunner;
        this.mpiFlags = mpiFlags;
        this.workingDir = workingDir;
        this.ppn = ppn;
        this.scaleByCU = scaleByCU;
        this.failByEV = failByEV;
        this.checkArguments();
    }

    public void setRunnerProperties(String installDir) {
        if (this.mpiRunner.endsWith("srun")) {
            this.loadMPIType(installDir + COMPSsPaths.REL_MPI_CFGS_DIR + "slurm.properties");
        } else {
            String type = System.getenv("COMPSS_MPIRUN_TYPE");
            if (type != null && !type.isEmpty()) {
                LOGGER.info("Loading MPIRUN type: " + type);
                if (type.startsWith(File.separator)) {
                    this.loadMPIType(type);
                } else {
                    this.loadMPIType(installDir + COMPSsPaths.REL_MPI_CFGS_DIR + type + ".properties");
                }
            } else {
                LOGGER.warn("Loading default MPIRUN type. You can modify with COMPSS_MPIRUN_TYPE environment variable.");
            }
        }
    }

    private void loadMPIType(String file) {
        try (FileInputStream fis = new FileInputStream(file);){
            Properties props = new Properties();
            props.load(fis);
            this.hostfile = Boolean.parseBoolean(this.loadProperty(props, "hostfile", "true"));
            this.hostsFlag = this.loadProperty(props, "hosts.flag", DEFAULT_HOSTS_FLAG);
            this.processesSeparator = this.loadProperty(props, "processes.separator", DEFAULT_PROCS_SEPARATOR);
            this.hostsSeparator = this.loadProperty(props, "hosts.separator", DEFAULT_HOSTS_SEPARATOR);
            this.singleHostNoProcesses = Boolean.parseBoolean(this.loadProperty(props, "single.hosts.no.processes", "true"));
        }
        catch (Exception e) {
            LOGGER.warn("Can't load MPIRUN type in " + file + ".\nReason: " + e.getMessage());
        }
    }

    protected String loadProperty(Properties props, String key, String defaultValue) {
        String propValue = props.getProperty(key);
        if (propValue == null) {
            LOGGER.warn("Property " + key + " not found setting default value: " + defaultValue);
            propValue = defaultValue;
        }
        return propValue.replaceAll("\"", DEFAULT_PROCS_SEPARATOR);
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public String getMpiRunner() {
        return this.mpiRunner;
    }

    public String getMpiFlags() {
        return this.mpiFlags;
    }

    public boolean getScaleByCU() {
        return this.scaleByCU;
    }

    public boolean isFailByEV() {
        return this.failByEV;
    }

    public String getHostsFlag() {
        return this.hostsFlag;
    }

    public boolean isHostfile() {
        return this.hostfile;
    }

    public String getProcessesSeparator() {
        return this.processesSeparator;
    }

    public String getHostsSeparator() {
        return this.hostsSeparator;
    }

    public int getPPN() {
        return this.ppn;
    }

    public void checkArguments() {
        if (this.mpiRunner == null || this.mpiRunner.isEmpty()) {
            throw new IllegalArgumentException(ERROR_MPI_RUNNER);
        }
        if (this.ppn < 1) {
            throw new IllegalArgumentException(ERROR_MPI_PPN);
        }
    }

    private static String writeHostfile(File taskSandboxWorkingDir, String workers) throws IOException {
        String uuid = UUID.randomUUID().toString();
        String filename = taskSandboxWorkingDir.getAbsolutePath() + File.separator + uuid + ".hostfile";
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(filename));){
            writer.write(workers);
        }
        return filename;
    }

    protected static String writeHostfile(File taskSandboxWorkingDir, List<String> workers, int computingUnits, int ppn, String procSeparator, String hostSeparator, boolean singleHost) throws IOException {
        String workersStr = CommonMPIDefinition.buildHostsString(workers, computingUnits, ppn, procSeparator, hostSeparator, singleHost);
        return CommonMPIDefinition.writeHostfile(taskSandboxWorkingDir, workersStr);
    }

    public String generateHostsDefinition(File taskSandboxWorkingDir, List<String> hostnames, int computingUnits) throws IOException {
        if (this.hostfile) {
            if (this.scaleByCU) {
                return CommonMPIDefinition.writeHostfile(taskSandboxWorkingDir, hostnames, computingUnits, this.ppn, this.processesSeparator, this.hostsSeparator, this.singleHostNoProcesses);
            }
            return CommonMPIDefinition.writeHostfile(taskSandboxWorkingDir, hostnames, 1, this.ppn, this.processesSeparator, this.hostsSeparator, this.singleHostNoProcesses);
        }
        if (this.scaleByCU) {
            return CommonMPIDefinition.buildHostsString(hostnames, computingUnits, this.ppn, this.processesSeparator, this.hostsSeparator, this.singleHostNoProcesses);
        }
        return CommonMPIDefinition.buildHostsString(hostnames, 1, this.ppn, this.processesSeparator, this.hostsSeparator, this.singleHostNoProcesses);
    }

    protected static String buildHostsString(List<String> hostnames, int computingUnits, int ppn, String procSeparator, String hostSeparator, boolean singleHost) {
        HashMap<String, Integer> hosts = new HashMap<String, Integer>();
        for (String hostname : hostnames) {
            if (hostname.endsWith(IB_SUFFIX)) {
                hostname = hostname.substring(0, hostname.lastIndexOf(IB_SUFFIX));
            }
            hosts.put(hostname, hosts.getOrDefault(hostname, 0) + computingUnits * ppn);
        }
        boolean firstElement = true;
        StringBuilder hostnamesSTR = new StringBuilder();
        if (singleHost && hosts.size() == 1) {
            return (String)hosts.keySet().iterator().next();
        }
        for (Map.Entry<String, Integer> entry : hosts.entrySet()) {
            String hostStr = CommonMPIDefinition.genHostString(procSeparator, hostSeparator, entry);
            if (firstElement) {
                firstElement = false;
                hostnamesSTR.append(hostStr);
                continue;
            }
            hostnamesSTR.append(hostSeparator + hostStr);
        }
        return hostnamesSTR.toString();
    }

    private static String genHostString(String procSeparator, String hostSeparator, Map.Entry<String, Integer> e) {
        String hostname = e.getKey();
        StringBuilder hostnameStr = new StringBuilder(hostname);
        if (procSeparator == null || procSeparator.isEmpty()) {
            for (int i = 1; i < e.getValue(); ++i) {
                hostnameStr.append(hostSeparator + hostname);
            }
        } else {
            hostnameStr.append(procSeparator + e.getValue());
        }
        return hostnameStr.toString();
    }

    public String generateNumberOfProcesses(int numWorkers, int computingUnits) {
        if (this.scaleByCU) {
            return String.valueOf(numWorkers * computingUnits);
        }
        if (this.ppn > 1) {
            return String.valueOf(numWorkers * this.ppn);
        }
        return String.valueOf(numWorkers);
    }
}

