/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util.serializers;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import es.bsc.compss.types.exceptions.NonInstantiableException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Base64;

public class PyBindingSerializer {
    private static final String JSON_SERIALIZER_ID = "0004";

    private PyBindingSerializer() {
        throw new NonInstantiableException("Serializer");
    }

    public static void serialize(Object o, String file) throws IOException {
        FileWriter fw = new FileWriter(file);
        fw.write(JSON_SERIALIZER_ID);
        Gson gson = new Gson();
        String json = gson.toJson(o);
        fw.write(json);
        fw.close();
    }

    public static byte[] serialize(Object o) throws IOException {
        Gson gson = new Gson();
        String json = gson.toJson(o);
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(json);
            out.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    public static Object deserialize(String fileName) throws IOException {
        String jsonContent = PyBindingSerializer.getFileContent(fileName).substring(JSON_SERIALIZER_ID.length());
        return PyBindingSerializer.stringToJSON(jsonContent);
    }

    public static Object deserialize(byte[] data) {
        String str = new String(data);
        return PyBindingSerializer.stringToJSON(str);
    }

    private static Object stringToJSON(String in) {
        JsonElement jsonElement = JsonParser.parseString((String)in);
        if (jsonElement.isJsonPrimitive()) {
            return jsonElement.getAsJsonPrimitive().getAsString();
        }
        if (jsonElement.isJsonObject()) {
            return jsonElement.toString();
        }
        if (jsonElement.isJsonArray()) {
            return jsonElement.getAsJsonArray().toString();
        }
        return null;
    }

    private static String getFileContent(String fileName) throws IOException {
        File f = new File(fileName);
        StringBuilder content = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new FileReader(f));){
            String line;
            while ((line = br.readLine()) != null) {
                content.append(line);
            }
        }
        return content.toString();
    }

    private static String decodeBase64(String encoded) {
        byte[] decoded = Base64.getDecoder().decode(encoded);
        return new String(decoded);
    }
}

