/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.connectors.conn.util;

import es.bsc.compss.types.resources.configuration.MethodConfiguration;
import es.bsc.compss.types.resources.description.CloudImageDescription;
import es.bsc.compss.types.resources.description.CloudInstanceTypeDescription;
import es.bsc.compss.types.resources.description.CloudMethodResourceDescription;
import es.bsc.conn.types.HardwareDescription;
import es.bsc.conn.types.InstallationDescription;
import es.bsc.conn.types.Processor;
import es.bsc.conn.types.SoftwareDescription;
import es.bsc.conn.types.VirtualResource;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Converter {
    private Converter() {
    }

    public static HardwareDescription getHardwareDescription(CloudMethodResourceDescription cmrd) {
        List<Processor> processors = Converter.getConnectorProcessors(cmrd.getProcessors());
        int cpuCU = cmrd.getTotalCPUComputingUnits();
        int gpuCU = cmrd.getTotalGPUComputingUnits();
        int fpgaCU = cmrd.getTotalFPGAComputingUnits();
        float memSize = cmrd.getMemorySize();
        String memType = cmrd.getMemoryType();
        float storageSize = cmrd.getStorageSize();
        String storageType = cmrd.getStorageType();
        int timeUnit = cmrd.getPriceTimeUnit();
        float priceUnit = cmrd.getPricePerUnit();
        String imageName = cmrd.getImage().getImageName();
        Map composition = cmrd.getTypeComposition();
        String instanceType = null;
        Iterator iterator = composition.keySet().iterator();
        if (iterator.hasNext()) {
            CloudInstanceTypeDescription type = (CloudInstanceTypeDescription)iterator.next();
            instanceType = type.getName();
        }
        Map imageProp = cmrd.getImage().getProperties();
        return new HardwareDescription(processors, cpuCU, gpuCU, fpgaCU, memSize, memType, storageSize, storageType, timeUnit, priceUnit, imageName, instanceType, imageProp);
    }

    public static SoftwareDescription getSoftwareDescription(CloudMethodResourceDescription cmrd) {
        String osType = cmrd.getOperatingSystemType();
        String osDist = cmrd.getOperatingSystemDistribution();
        String osVersion = cmrd.getOperatingSystemVersion();
        List apps = cmrd.getAppSoftware();
        InstallationDescription installDesc = Converter.getInstallationDescription(cmrd.getImage().getConfig());
        return new SoftwareDescription(osType, osDist, osVersion, apps, installDesc);
    }

    public static VirtualResource getVirtualResource(Object id, CloudMethodResourceDescription cmrd) {
        return new VirtualResource((Object)((String)id), Converter.getHardwareDescription(cmrd), Converter.getSoftwareDescription(cmrd), cmrd.getImage().getProperties());
    }

    private static Processor getConnectorProcessor(es.bsc.compss.types.resources.components.Processor p) {
        return new Processor(p.getName(), p.getComputingUnits(), p.getType().toString(), p.getInternalMemory(), p.getSpeed(), p.getArchitecture(), p.getPropName(), p.getPropValue());
    }

    private static List<Processor> getConnectorProcessors(List<es.bsc.compss.types.resources.components.Processor> processorList) {
        LinkedList<Processor> processors = new LinkedList<Processor>();
        for (es.bsc.compss.types.resources.components.Processor p : processorList) {
            processors.add(Converter.getConnectorProcessor(p));
        }
        return processors;
    }

    private static InstallationDescription getInstallationDescription(MethodConfiguration config) {
        InstallationDescription installDesc = new InstallationDescription(config.getAdaptorName(), config.getMinPort(), config.getMaxPort(), config.getInstallDir(), config.getAppDir(), config.getClasspath(), config.getPythonpath(), config.getLibraryPath(), config.getWorkingDir(), config.getLimitOfTasks());
        return installDesc;
    }

    public static CloudMethodResourceDescription toCloudMethodResourceDescription(VirtualResource vr, CloudMethodResourceDescription requested) {
        CloudMethodResourceDescription cmrd = new CloudMethodResourceDescription();
        cmrd.setName(vr.getIp());
        Converter.setHardwareInResourceDescription(cmrd, vr.getHd(), requested);
        Converter.setSoftwareInResourceDescription(cmrd, vr.getSd(), requested);
        CloudImageDescription cid = Converter.getCloudImageDescription(vr.getHd(), vr.getSd(), requested);
        cmrd.setImage(cid);
        cmrd.getImage().getConfig().setMinPort(vr.getSd().getInstallation().getMinPort());
        cmrd.getImage().getConfig().setMaxPort(vr.getSd().getInstallation().getMaxPort());
        return cmrd;
    }

    private static es.bsc.compss.types.resources.components.Processor getCOMPSsProcessor(Processor p) {
        return new es.bsc.compss.types.resources.components.Processor(p.getName(), p.getComputingUnits(), p.getSpeed(), p.getArchitecture(), p.getType(), p.getInternalMemory(), p.getPropName(), p.getPropValue());
    }

    private static List<es.bsc.compss.types.resources.components.Processor> getCOMPSsProcessors(List<Processor> processorList) {
        LinkedList<es.bsc.compss.types.resources.components.Processor> processors = new LinkedList<es.bsc.compss.types.resources.components.Processor>();
        for (Processor p : processorList) {
            processors.add(Converter.getCOMPSsProcessor(p));
        }
        return processors;
    }

    private static CloudImageDescription getCloudImageDescription(HardwareDescription hd, SoftwareDescription sd, CloudMethodResourceDescription requested) {
        CloudImageDescription from = requested.getImage();
        CloudImageDescription cid = new CloudImageDescription(hd.getImageName(), hd.getImageProperties());
        cid.setOperatingSystemType(sd.getOperatingSystemType());
        cid.setOperatingSystemDistribution(sd.getOperatingSystemDistribution());
        cid.setOperatingSystemVersion(sd.getOperatingSystemVersion());
        cid.setAppSoftware(sd.getAppSoftware());
        cid.setPricePerUnit(hd.getPricePerUnit());
        cid.setPriceTimeUnit(hd.getPriceTimeUnit());
        cid.setConfig(from.getConfig());
        cid.setQueues(from.getQueues());
        cid.setSharedDisks(from.getSharedDisks());
        cid.setPackages(from.getPackages());
        return cid;
    }

    private static void setHardwareInResourceDescription(CloudMethodResourceDescription cmrd, HardwareDescription hd, CloudMethodResourceDescription requested) {
        cmrd.setProcessors(Converter.getCOMPSsProcessors(hd.getProcessors()));
        cmrd.setMemorySize(hd.getMemorySize());
        cmrd.setMemoryType(hd.getMemoryType());
        cmrd.setStorageSize(hd.getStorageSize());
        cmrd.setStorageType(hd.getStorageType());
        cmrd.setPricePerUnit(hd.getPricePerUnit());
        cmrd.setPriceTimeUnit(hd.getPriceTimeUnit());
        for (Map.Entry type : requested.getTypeComposition().entrySet()) {
            cmrd.addInstances((CloudInstanceTypeDescription)type.getKey(), ((int[])type.getValue())[0]);
        }
    }

    private static void setSoftwareInResourceDescription(CloudMethodResourceDescription cmrd, SoftwareDescription sd, CloudMethodResourceDescription requested) {
        cmrd.setOperatingSystemType(sd.getOperatingSystemType());
        cmrd.setOperatingSystemDistribution(sd.getOperatingSystemDistribution());
        cmrd.setOperatingSystemVersion(sd.getOperatingSystemVersion());
        cmrd.setAppSoftware(sd.getAppSoftware());
    }
}

