/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.connectors.conn.util;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.comm.CommAdaptor;
import es.bsc.compss.connectors.ConnectorException;
import es.bsc.conn.Connector;
import es.bsc.conn.exceptions.ConnException;
import es.bsc.conn.types.HardwareDescription;
import es.bsc.conn.types.SoftwareDescription;
import es.bsc.conn.types.StarterCommand;
import es.bsc.conn.types.VirtualResource;
import java.util.Map;

public class ConnectorProxy {
    private static final String ERROR_NO_CONN = "ERROR: Connector specific implementation is null";
    private final Connector connector;

    public ConnectorProxy(Connector conn) throws ConnectorException {
        if (conn == null) {
            throw new ConnectorException(ERROR_NO_CONN);
        }
        this.connector = conn;
    }

    public boolean isAutomaticScalingEnabled() {
        return this.connector.isAutomaticScalingEnabled();
    }

    public Object create(String name, HardwareDescription hd, SoftwareDescription sd, Map<String, String> properties) throws ConnectorException {
        if (this.connector == null) {
            throw new ConnectorException(ERROR_NO_CONN);
        }
        Object created = null;
        try {
            StarterCommand starterCMD = this.getStarterCommand(name, hd, sd);
            created = this.connector.create(name, hd, sd, properties, starterCMD);
        }
        catch (ConnException ce) {
            throw new ConnectorException((Exception)((Object)ce));
        }
        return created;
    }

    private StarterCommand getStarterCommand(String name, HardwareDescription hd, SoftwareDescription sd) {
        String adaptorName = sd.getInstallation().getAdaptorName();
        CommAdaptor adaptor = Comm.getAdaptor((String)adaptorName);
        if (adaptor != null) {
            String hostId = null;
            return adaptor.getStarterCommand(name, sd.getInstallation().getMinPort(), Comm.getAppHost().getName(), sd.getInstallation().getWorkingDir(), sd.getInstallation().getInstallDir(), sd.getInstallation().getAppDir(), sd.getInstallation().getClasspath(), sd.getInstallation().getPythonPath(), sd.getInstallation().getLibraryPath(), sd.getInstallation().getEnvScriptPath(), sd.getInstallation().getPythonInterpreter(), hd.getTotalCPUComputingUnits(), hd.getTotalGPUComputingUnits(), hd.getTotalFPGAComputingUnits(), sd.getInstallation().getLimitOfTasks(), hostId);
        }
        return null;
    }

    public Object createMultiple(int replicas, String name, HardwareDescription hd, SoftwareDescription sd, Map<String, String> properties) throws ConnectorException {
        if (this.connector == null) {
            throw new ConnectorException(ERROR_NO_CONN);
        }
        Object[] created = null;
        try {
            StarterCommand starterCMD = this.getStarterCommand(name, hd, sd);
            created = this.connector.createMultiple(replicas, name, hd, sd, properties, starterCMD);
        }
        catch (ConnException ce) {
            throw new ConnectorException((Exception)((Object)ce));
        }
        return created;
    }

    public void destroy(Object id) throws ConnectorException {
        if (this.connector == null) {
            throw new ConnectorException(ERROR_NO_CONN);
        }
        this.connector.destroy(id);
    }

    public VirtualResource waitUntilCreation(Object id) throws ConnectorException {
        if (this.connector == null) {
            throw new ConnectorException(ERROR_NO_CONN);
        }
        VirtualResource vr = null;
        try {
            vr = this.connector.waitUntilCreation(id);
        }
        catch (ConnException ce) {
            throw new ConnectorException((Exception)((Object)ce));
        }
        return vr;
    }

    public float getPriceSlot(VirtualResource vr, float defaultPrice) {
        if (this.connector == null) {
            return defaultPrice;
        }
        return this.connector.getPriceSlot(vr);
    }

    public long getTimeSlot(long defaultLength) {
        if (this.connector == null) {
            return defaultLength;
        }
        return this.connector.getTimeSlot();
    }

    public void close() {
        this.connector.close();
    }
}

