/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.connectors;

import es.bsc.compss.connectors.AbstractConnector;
import es.bsc.compss.connectors.ConnectorException;
import es.bsc.compss.connectors.conn.util.ConnectorProxy;
import es.bsc.compss.connectors.conn.util.Converter;
import es.bsc.compss.types.CloudProvider;
import es.bsc.compss.types.resources.description.CloudImageDescription;
import es.bsc.compss.types.resources.description.CloudMethodResourceDescription;
import es.bsc.compss.util.Classpath;
import es.bsc.conn.Connector;
import es.bsc.conn.types.VirtualResource;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Constructor;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultNoSSHConnector
extends AbstractConnector {
    private static final String CONNECTORS_REL_PATH = File.separator + "Runtime" + File.separator + "cloud-conn" + File.separator;
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Connectors");
    private static final String WARN_NO_COMPSS_HOME = "WARN: COMPSS_HOME not defined, no default connectors loaded";
    private static final float UNASSIGNED_FLOAT = -1.0f;
    private ConnectorProxy connector;

    public DefaultNoSSHConnector(CloudProvider provider, String connectorJarPath, String connectorMainClass, Map<String, String> connectorProperties) throws ConnectorException {
        super(provider, connectorProperties);
        LOGGER.info("Creating DefaultNoSSHConnector");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("  Detected " + connectorProperties.size() + " Connector properties");
            for (Map.Entry<String, String> prop : connectorProperties.entrySet()) {
                LOGGER.debug("   > ConnectorProperty: " + prop.getKey() + " - " + prop.getValue());
            }
        }
        Connector conn = null;
        LOGGER.debug(" - Loading " + connectorJarPath);
        try {
            String jarPath = connectorJarPath;
            if (!connectorJarPath.startsWith(File.separator)) {
                String compssHome = System.getenv("COMPSS_HOME");
                if (compssHome == null || compssHome.isEmpty()) {
                    LOGGER.warn(WARN_NO_COMPSS_HOME);
                    return;
                }
                jarPath = compssHome + CONNECTORS_REL_PATH + connectorJarPath;
            }
            LOGGER.debug(" - Loading from : " + jarPath);
            Classpath.loadPath((String)jarPath, (Logger)LOGGER);
            LOGGER.debug(" - Using connector " + connectorMainClass);
            Class<?> conClass = Class.forName(connectorMainClass);
            Constructor<?> constructor = conClass.getDeclaredConstructors()[0];
            conn = (Connector)constructor.newInstance(connectorProperties);
            LOGGER.debug("Ending connector creaton handling");
            if (conn == null) {
                LOGGER.fatal("Connector constructor null");
            }
        }
        catch (FileNotFoundException fnfe) {
            LOGGER.error("Specific connector jar file not found", (Throwable)fnfe);
            throw new ConnectorException("Specific Connector jar file (" + connectorJarPath + ") not found", (Exception)fnfe);
        }
        catch (Exception e) {
            LOGGER.error("Exception creating connector", (Throwable)e);
            throw new ConnectorException(e);
        }
        finally {
            if (conn == null) {
                LOGGER.fatal("Connector constructor null");
            }
            this.connector = new ConnectorProxy(conn);
        }
        this.connector = new ConnectorProxy(conn);
    }

    public void destroy(Object id) throws ConnectorException {
        LOGGER.debug("Destroy connection with id " + id);
        this.connector.destroy(id);
    }

    public Object create(String name, CloudMethodResourceDescription cmrd) throws ConnectorException {
        LOGGER.debug("Create connection " + name);
        return this.connector.create(name, Converter.getHardwareDescription(cmrd), Converter.getSoftwareDescription(cmrd), cmrd.getImage().getProperties());
    }

    public CloudMethodResourceDescription waitUntilCreation(Object id, CloudMethodResourceDescription requested) throws ConnectorException {
        LOGGER.debug("Waiting for " + id);
        VirtualResource vr = this.connector.waitUntilCreation(id);
        CloudMethodResourceDescription cmrd = Converter.toCloudMethodResourceDescription(vr, requested);
        LOGGER.debug("Return cloud method resource description " + cmrd.toString());
        return cmrd;
    }

    public float getMachineCostPerTimeSlot(CloudMethodResourceDescription cmrd) {
        return this.connector.getPriceSlot(Converter.getVirtualResource("-1", cmrd), -1.0f);
    }

    public long getTimeSlot() {
        return this.connector.getTimeSlot(120000L);
    }

    protected void close() {
        LOGGER.debug("Close connector");
        this.connector.close();
    }

    public void configureAccess(String IP, String user, String password) throws ConnectorException {
    }

    public void prepareMachine(String IP, CloudImageDescription cid) throws ConnectorException {
    }
}

