/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.conn.clients.mesos.framework;

import java.util.LinkedList;
import java.util.List;
import org.apache.mesos.Protos;

public class MesosOffer {
    private static final int CPUS_WEIGHT = 3;
    private static final int MEM_WEIGHT = 2;
    private static final int DISK_WEIGHT = 1;
    private static final String CPUS_RESOURCE = "cpus";
    private static final String MEM_RESOURCE = "mem";
    private static final String DISK_RESOURCE = "disk";
    private static final String PORTS_RESOURCE = "ports";
    private double cpus = 0.0;
    private double mem = 0.0;
    private double disk = 0.0;
    private List<Protos.Value.Range> ports = new LinkedList<Protos.Value.Range>();
    private Protos.Offer offer = null;

    public MesosOffer() {
    }

    public MesosOffer(Protos.Offer offer) {
        this();
        this.offer = offer;
        this.countResources(offer.getResourcesList());
    }

    public MesosOffer(List<Protos.Resource> resources) {
        this();
        this.countResources(resources);
    }

    public double getCpus() {
        return this.cpus;
    }

    public double getMem() {
        return this.mem;
    }

    public double getDisk() {
        return this.disk;
    }

    public Protos.Offer getOffer() {
        return this.offer;
    }

    public String rangeToString(Protos.Value.Range r) {
        return String.format("(%d-%d)", r.getBegin(), r.getEnd());
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        for (Protos.Value.Range r : this.ports) {
            bld.append(this.rangeToString(r));
        }
        String portsList = "[" + bld.toString() + "]";
        return String.format("Offer: {cpus: %.2f, mem: %.2f, disk: %.2f, ports: %s}", this.cpus, this.mem, this.disk, portsList);
    }

    public int getNumPorts() {
        int portsCount = 0;
        for (Protos.Value.Range portsRange : this.ports) {
            portsCount += (int)(portsRange.getEnd() - portsRange.getBegin()) + 1;
        }
        return portsCount;
    }

    public List<Protos.Value.Range> getPortsList() {
        return this.ports;
    }

    public boolean hasEnoughPorts(int minPorts) {
        return this.getNumPorts() >= minPorts;
    }

    public List<Protos.Value.Range> getMinPorts(int minPorts) {
        LinkedList<Protos.Value.Range> minPortsList = new LinkedList<Protos.Value.Range>();
        int addedPorts = 0;
        for (int i = 0; i < this.ports.size(); ++i) {
            Protos.Value.Range r = this.ports.get(i);
            int range = (int)(r.getEnd() - r.getBegin());
            if (addedPorts + range < minPorts) {
                addedPorts += range;
            } else {
                long end = r.getBegin() + (long)(minPorts - addedPorts) - 1L;
                minPortsList.add(this.buildRange(r.getBegin(), end));
                this.ports.remove(i);
                this.ports.add(i, this.buildRange(end + 1L, r.getEnd()));
                break;
            }
            minPortsList.add(r);
            this.ports.remove(i);
        }
        return minPortsList;
    }

    public double distance(MesosOffer offer) {
        double cpusScore = (offer.cpus - this.cpus) / this.cpus * 3.0;
        double memScore = (offer.mem - this.mem) / this.mem * 2.0;
        double diskScore = (offer.disk - this.disk) / this.disk * 1.0;
        if (cpusScore < 0.0 || memScore < 0.0 || diskScore < 0.0) {
            return -1.0;
        }
        return cpusScore + memScore + diskScore;
    }

    public void removeResourcesFrom(MesosOffer offer) {
        this.cpus = Math.max(this.cpus - offer.getCpus(), 0.0);
        this.mem = Math.max(this.mem - offer.getMem(), 0.0);
        this.disk = Math.max(this.disk - offer.getDisk(), 0.0);
    }

    private void countResources(List<Protos.Resource> resources) {
        for (Protos.Resource resource : resources) {
            switch (resource.getName()) {
                case "cpus": {
                    this.cpus += resource.getScalar().getValue();
                    break;
                }
                case "mem": {
                    this.mem += resource.getScalar().getValue();
                    break;
                }
                case "disk": {
                    this.disk += resource.getScalar().getValue();
                    break;
                }
                case "ports": {
                    this.ports.addAll(resource.getRanges().getRangeList());
                    break;
                }
            }
        }
    }

    private Protos.Value.Range buildRange(long begin, long end) {
        return Protos.Value.Range.newBuilder().setBegin(begin).setEnd(end).build();
    }
}

