/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.domain;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class RegionAndName {
    protected final String region;
    protected final String name;

    public String slashEncode() {
        return this.region + '/' + this.name;
    }

    public RegionAndName(String region, String name) {
        this.region = Preconditions.checkNotNull(region, "region");
        this.name = Preconditions.checkNotNull(name, "name");
    }

    public int hashCode() {
        return Objects.hashCode(this.region, this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegionAndName)) {
            return false;
        }
        RegionAndName other = (RegionAndName)RegionAndName.class.cast(obj);
        return Objects.equal(this.region, other.region) && Objects.equal(this.name, other.name);
    }

    public String getRegion() {
        return this.region;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper("").add("region", this.region).add("name", this.name);
    }

    public static Function<RegionAndName, String> regionFunction() {
        return RegionFunction.INSTANCE;
    }

    public static Function<RegionAndName, String> nameFunction() {
        return NameFunction.INSTANCE;
    }

    private static enum NameFunction implements Function<RegionAndName, String>
    {
        INSTANCE;


        @Override
        public String apply(RegionAndName input) {
            return input.getName();
        }

        public String toString() {
            return "getName()";
        }
    }

    private static enum RegionFunction implements Function<RegionAndName, String>
    {
        INSTANCE;


        @Override
        public String apply(RegionAndName input) {
            return input.getRegion();
        }

        public String toString() {
            return "getRegion()";
        }
    }
}

