/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.functions;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cloudstack.CloudStackApi;
import org.jclouds.cloudstack.domain.FirewallRule;
import org.jclouds.cloudstack.options.ListFirewallRulesOptions;

@Singleton
public class GetFirewallRulesByVirtualMachine
extends CacheLoader<String, Set<FirewallRule>> {
    private final CloudStackApi client;

    @Inject
    public GetFirewallRulesByVirtualMachine(CloudStackApi client) {
        this.client = Preconditions.checkNotNull(client, "client");
    }

    @Override
    public Set<FirewallRule> load(String input) {
        String publicIPId = this.client.getVirtualMachineApi().getVirtualMachine(input).getPublicIPId();
        Set<FirewallRule> rules = this.client.getFirewallApi().listFirewallRules(ListFirewallRulesOptions.Builder.ipAddressId(publicIPId));
        return rules != null ? rules : ImmutableSet.of();
    }
}

