/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.joyent.cloudapi.v6_5.domain.datacenterscoped;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;

public class DatacenterAndName {
    public static final Function<DatacenterAndName, String> NAME_FUNCTION = new Function<DatacenterAndName, String>(){

        @Override
        public String apply(DatacenterAndName input) {
            return input.getName();
        }
    };
    public static final Function<DatacenterAndName, String> DATACENTER_FUNCTION = new Function<DatacenterAndName, String>(){

        @Override
        public String apply(DatacenterAndName input) {
            return input.getDatacenter();
        }
    };
    protected final String datacenterId;
    protected final String name;

    public static DatacenterAndName fromSlashEncoded(String name) {
        Iterable<String> parts = Splitter.on('/').split(Preconditions.checkNotNull(name, "name"));
        Preconditions.checkArgument(Iterables.size(parts) == 2, "name must be in format datacenterId/name");
        return new DatacenterAndName(Iterables.get(parts, 0), Iterables.get(parts, 1));
    }

    public static DatacenterAndName fromDatacenterAndName(String datacenterId, String name) {
        return new DatacenterAndName(datacenterId, name);
    }

    private static String slashEncodeDatacenterAndName(String datacenterId, String name) {
        return Preconditions.checkNotNull(datacenterId, "datacenterId") + "/" + Preconditions.checkNotNull(name, "name");
    }

    public String slashEncode() {
        return DatacenterAndName.slashEncodeDatacenterAndName(this.datacenterId, this.name);
    }

    protected DatacenterAndName(String datacenterId, String name) {
        this.datacenterId = Preconditions.checkNotNull(datacenterId, "datacenterId");
        this.name = Preconditions.checkNotNull(name, "name");
    }

    public String getDatacenter() {
        return this.datacenterId;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatacenterAndName that = (DatacenterAndName)DatacenterAndName.class.cast(o);
        return Objects.equal(this.datacenterId, that.datacenterId) && Objects.equal(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hashCode(this.datacenterId, this.name);
    }

    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper("").add("datacenterId", this.datacenterId).add("name", this.name);
    }
}

