/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.extensions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.domain.Location;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.domain.RegionNameAndIngressRules;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.ec2.domain.SecurityGroup;
import org.jclouds.ec2.domain.UserIdGroupPair;
import org.jclouds.location.Region;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;

public class EC2SecurityGroupExtension
implements SecurityGroupExtension {
    protected final EC2Api client;
    protected final ListeningExecutorService userExecutor;
    protected final Supplier<Set<String>> regions;
    protected final Function<SecurityGroup, org.jclouds.compute.domain.SecurityGroup> groupConverter;
    protected final Supplier<Set<? extends Location>> locations;
    protected final LoadingCache<RegionAndName, String> groupCreator;
    protected final GroupNamingConvention.Factory namingConvention;

    @Inject
    public EC2SecurityGroupExtension(EC2Api client, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, @Region Supplier<Set<String>> regions, Function<SecurityGroup, org.jclouds.compute.domain.SecurityGroup> groupConverter, @Memoized Supplier<Set<? extends Location>> locations, @Named(value="SECURITY") LoadingCache<RegionAndName, String> groupCreator, GroupNamingConvention.Factory namingConvention) {
        this.client = Preconditions.checkNotNull(client, "client");
        this.userExecutor = Preconditions.checkNotNull(userExecutor, "userExecutor");
        this.regions = Preconditions.checkNotNull(regions, "regions");
        this.groupConverter = Preconditions.checkNotNull(groupConverter, "groupConverter");
        this.locations = Preconditions.checkNotNull(locations, "locations");
        this.groupCreator = Preconditions.checkNotNull(groupCreator, "groupCreator");
        this.namingConvention = Preconditions.checkNotNull(namingConvention, "namingConvention");
    }

    @Override
    public Set<org.jclouds.compute.domain.SecurityGroup> listSecurityGroups() {
        Iterable<? extends SecurityGroup> rawGroups = this.pollSecurityGroups();
        Iterable<org.jclouds.compute.domain.SecurityGroup> groups = Iterables.transform(Iterables.filter(rawGroups, Predicates.notNull()), this.groupConverter);
        return ImmutableSet.copyOf(groups);
    }

    @Override
    public Set<org.jclouds.compute.domain.SecurityGroup> listSecurityGroupsInLocation(Location location) {
        String region = AWSUtils.getRegionFromLocationOrNull(location);
        if (region == null) {
            return ImmutableSet.of();
        }
        return this.listSecurityGroupsInLocation(region);
    }

    public Set<org.jclouds.compute.domain.SecurityGroup> listSecurityGroupsInLocation(String region) {
        Iterable<? extends SecurityGroup> rawGroups = this.pollSecurityGroupsByRegion(region);
        Iterable<org.jclouds.compute.domain.SecurityGroup> groups = Iterables.transform(Iterables.filter(rawGroups, Predicates.notNull()), this.groupConverter);
        return ImmutableSet.copyOf(groups);
    }

    @Override
    public Set<org.jclouds.compute.domain.SecurityGroup> listSecurityGroupsForNode(String id) {
        Preconditions.checkNotNull(id, "id");
        String[] parts = AWSUtils.parseHandle(id);
        String region = parts[0];
        String instanceId = parts[1];
        RunningInstance instance = (RunningInstance)Iterables.getOnlyElement(Iterables.concat(this.client.getInstanceApi().get().describeInstancesInRegion(region, instanceId)));
        if (instance == null) {
            return ImmutableSet.of();
        }
        Set<String> groupNames = instance.getGroupNames();
        Set<SecurityGroup> rawGroups = this.client.getSecurityGroupApi().get().describeSecurityGroupsInRegion(region, Iterables.toArray(groupNames, String.class));
        return ImmutableSet.copyOf(Iterables.transform(Iterables.filter(rawGroups, Predicates.notNull()), this.groupConverter));
    }

    @Override
    public org.jclouds.compute.domain.SecurityGroup getSecurityGroupById(String id) {
        Preconditions.checkNotNull(id, "id");
        String[] parts = AWSUtils.parseHandle(id);
        String region = parts[0];
        String groupId = parts[1];
        Set<SecurityGroup> rawGroups = this.client.getSecurityGroupApi().get().describeSecurityGroupsInRegion(region, groupId);
        return Iterables.getOnlyElement(Iterables.transform(Iterables.filter(rawGroups, Predicates.notNull()), this.groupConverter));
    }

    @Override
    public org.jclouds.compute.domain.SecurityGroup createSecurityGroup(String name, Location location) {
        String region = AWSUtils.getRegionFromLocationOrNull(location);
        if (region != null) {
            return this.createSecurityGroup(name, region);
        }
        return null;
    }

    public org.jclouds.compute.domain.SecurityGroup createSecurityGroup(String name, String region) {
        String markerGroup = this.namingConvention.create().sharedNameForGroup(name);
        RegionNameAndIngressRules regionAndName = new RegionNameAndIngressRules(region, markerGroup, new int[0], false);
        this.groupCreator.getUnchecked(regionAndName);
        return this.getSecurityGroupById(regionAndName.slashEncode());
    }

    @Override
    public boolean removeSecurityGroup(String id) {
        Preconditions.checkNotNull(id, "id");
        String[] parts = AWSUtils.parseHandle(id);
        String region = parts[0];
        String groupName = parts[1];
        if (!this.client.getSecurityGroupApi().get().describeSecurityGroupsInRegion(region, groupName).isEmpty()) {
            this.client.getSecurityGroupApi().get().deleteSecurityGroupInRegion(region, groupName);
            this.groupCreator.invalidate(new RegionNameAndIngressRules(region, groupName, null, false));
            return true;
        }
        return false;
    }

    @Override
    public org.jclouds.compute.domain.SecurityGroup addIpPermission(IpPermission ipPermission, org.jclouds.compute.domain.SecurityGroup group) {
        String region = AWSUtils.getRegionFromLocationOrNull(group.getLocation());
        String name = group.getName();
        if (!ipPermission.getCidrBlocks().isEmpty()) {
            for (String cidr : ipPermission.getCidrBlocks()) {
                this.client.getSecurityGroupApi().get().authorizeSecurityGroupIngressInRegion(region, name, ipPermission.getIpProtocol(), ipPermission.getFromPort(), ipPermission.getToPort(), cidr);
            }
        }
        if (!ipPermission.getTenantIdGroupNamePairs().isEmpty()) {
            for (String userId : ipPermission.getTenantIdGroupNamePairs().keySet()) {
                for (String groupName : ipPermission.getTenantIdGroupNamePairs().get(userId)) {
                    this.client.getSecurityGroupApi().get().authorizeSecurityGroupIngressInRegion(region, name, new UserIdGroupPair(userId, groupName));
                }
            }
        }
        return this.getSecurityGroupById(new RegionAndName(region, group.getName()).slashEncode());
    }

    @Override
    public org.jclouds.compute.domain.SecurityGroup addIpPermission(IpProtocol protocol, int startPort, int endPort, Multimap<String, String> tenantIdGroupNamePairs, Iterable<String> ipRanges, Iterable<String> groupIds, org.jclouds.compute.domain.SecurityGroup group) {
        String region = AWSUtils.getRegionFromLocationOrNull(group.getLocation());
        String name = group.getName();
        if (!Iterables.isEmpty(ipRanges)) {
            for (String cidr : ipRanges) {
                this.client.getSecurityGroupApi().get().authorizeSecurityGroupIngressInRegion(region, name, protocol, startPort, endPort, cidr);
            }
        }
        if (!tenantIdGroupNamePairs.isEmpty()) {
            for (String userId : tenantIdGroupNamePairs.keySet()) {
                for (String groupName : tenantIdGroupNamePairs.get(userId)) {
                    this.client.getSecurityGroupApi().get().authorizeSecurityGroupIngressInRegion(region, name, new UserIdGroupPair(userId, groupName));
                }
            }
        }
        return this.getSecurityGroupById(new RegionAndName(region, group.getName()).slashEncode());
    }

    @Override
    public org.jclouds.compute.domain.SecurityGroup removeIpPermission(IpPermission ipPermission, org.jclouds.compute.domain.SecurityGroup group) {
        String region = AWSUtils.getRegionFromLocationOrNull(group.getLocation());
        String name = group.getName();
        if (!ipPermission.getCidrBlocks().isEmpty()) {
            for (String cidr : ipPermission.getCidrBlocks()) {
                this.client.getSecurityGroupApi().get().revokeSecurityGroupIngressInRegion(region, name, ipPermission.getIpProtocol(), ipPermission.getFromPort(), ipPermission.getToPort(), cidr);
            }
        }
        if (!ipPermission.getTenantIdGroupNamePairs().isEmpty()) {
            for (String userId : ipPermission.getTenantIdGroupNamePairs().keySet()) {
                for (String groupName : ipPermission.getTenantIdGroupNamePairs().get(userId)) {
                    this.client.getSecurityGroupApi().get().revokeSecurityGroupIngressInRegion(region, name, new UserIdGroupPair(userId, groupName));
                }
            }
        }
        return this.getSecurityGroupById(new RegionAndName(region, group.getName()).slashEncode());
    }

    @Override
    public org.jclouds.compute.domain.SecurityGroup removeIpPermission(IpProtocol protocol, int startPort, int endPort, Multimap<String, String> tenantIdGroupNamePairs, Iterable<String> ipRanges, Iterable<String> groupIds, org.jclouds.compute.domain.SecurityGroup group) {
        String region = AWSUtils.getRegionFromLocationOrNull(group.getLocation());
        String name = group.getName();
        if (!Iterables.isEmpty(ipRanges)) {
            for (String cidr : ipRanges) {
                this.client.getSecurityGroupApi().get().revokeSecurityGroupIngressInRegion(region, name, protocol, startPort, endPort, cidr);
            }
        }
        if (!tenantIdGroupNamePairs.isEmpty()) {
            for (String userId : tenantIdGroupNamePairs.keySet()) {
                for (String groupName : tenantIdGroupNamePairs.get(userId)) {
                    this.client.getSecurityGroupApi().get().revokeSecurityGroupIngressInRegion(region, name, new UserIdGroupPair(userId, groupName));
                }
            }
        }
        return this.getSecurityGroupById(new RegionAndName(region, group.getName()).slashEncode());
    }

    @Override
    public boolean supportsTenantIdGroupNamePairs() {
        return true;
    }

    @Override
    public boolean supportsTenantIdGroupIdPairs() {
        return false;
    }

    @Override
    public boolean supportsGroupIds() {
        return false;
    }

    @Override
    public boolean supportsPortRangesForGroups() {
        return false;
    }

    @Override
    public boolean supportsExclusionCidrBlocks() {
        return false;
    }

    protected Iterable<? extends SecurityGroup> pollSecurityGroups() {
        Iterable<Set<? extends SecurityGroup>> groups = Iterables.transform((Iterable)this.regions.get(), this.allSecurityGroupsInRegion());
        return Iterables.concat(groups);
    }

    protected Iterable<? extends SecurityGroup> pollSecurityGroupsByRegion(String region) {
        return this.allSecurityGroupsInRegion().apply(region);
    }

    protected Function<String, Set<? extends SecurityGroup>> allSecurityGroupsInRegion() {
        return new Function<String, Set<? extends SecurityGroup>>(){

            @Override
            public Set<? extends SecurityGroup> apply(String from) {
                return EC2SecurityGroupExtension.this.client.getSecurityGroupApi().get().describeSecurityGroupsInRegion(from, new String[0]);
            }
        };
    }

    protected Location findLocationWithId(final String locationId) {
        if (locationId == null) {
            return null;
        }
        try {
            Location location = Iterables.find((Iterable)this.locations.get(), new Predicate<Location>(){

                @Override
                public boolean apply(Location input) {
                    return input.getId().equals(locationId);
                }
            });
            return location;
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }
}

