/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute.config;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Injector;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.config.ComputeServiceAdapterContextModule;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.strategy.impl.CreateNodesWithGroupEncodedIntoNameThenAddToSet;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.googlecomputeengine.compute.GoogleComputeEngineService;
import org.jclouds.googlecomputeengine.compute.GoogleComputeEngineServiceAdapter;
import org.jclouds.googlecomputeengine.compute.domain.NetworkAndAddressRange;
import org.jclouds.googlecomputeengine.compute.functions.CreateNetworkIfNeeded;
import org.jclouds.googlecomputeengine.compute.functions.FindNetworkOrCreate;
import org.jclouds.googlecomputeengine.compute.functions.FirewallTagNamingConvention;
import org.jclouds.googlecomputeengine.compute.functions.GoogleComputeEngineImageToImage;
import org.jclouds.googlecomputeengine.compute.functions.ImageNameToOperatingSystem;
import org.jclouds.googlecomputeengine.compute.functions.InstanceToNodeMetadata;
import org.jclouds.googlecomputeengine.compute.functions.MachineTypeToHardware;
import org.jclouds.googlecomputeengine.compute.functions.OrphanedGroupsFromDeadNodes;
import org.jclouds.googlecomputeengine.compute.functions.Resources;
import org.jclouds.googlecomputeengine.compute.options.GoogleComputeEngineTemplateOptions;
import org.jclouds.googlecomputeengine.compute.predicates.AtomicInstanceVisible;
import org.jclouds.googlecomputeengine.compute.predicates.AtomicOperationDone;
import org.jclouds.googlecomputeengine.compute.predicates.GroupIsEmpty;
import org.jclouds.googlecomputeengine.domain.Image;
import org.jclouds.googlecomputeengine.domain.Instance;
import org.jclouds.googlecomputeengine.domain.MachineType;
import org.jclouds.googlecomputeengine.domain.Network;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.location.suppliers.ImplicitLocationSupplier;
import org.jclouds.location.suppliers.implicit.FirstZone;
import org.jclouds.rest.config.BinderUtils;
import org.jclouds.util.Predicates2;

public final class GoogleComputeEngineServiceContextModule
extends ComputeServiceAdapterContextModule<Instance, MachineType, Image, Location> {
    private static final Map<Instance.Status, NodeMetadata.Status> toPortableNodeStatus = ImmutableMap.builder().put(Instance.Status.PROVISIONING, NodeMetadata.Status.PENDING).put(Instance.Status.STAGING, NodeMetadata.Status.PENDING).put(Instance.Status.RUNNING, NodeMetadata.Status.RUNNING).put(Instance.Status.STOPPING, NodeMetadata.Status.PENDING).put(Instance.Status.STOPPED, NodeMetadata.Status.SUSPENDED).put(Instance.Status.TERMINATED, NodeMetadata.Status.SUSPENDED).build();

    @Override
    protected void configure() {
        super.configure();
        this.bind(ComputeService.class).to(GoogleComputeEngineService.class);
        this.bind(new TypeLiteral<ComputeServiceAdapter<Instance, MachineType, Image, Location>>(){}).to(GoogleComputeEngineServiceAdapter.class);
        this.install(new ComputeServiceAdapterContextModule.LocationsFromComputeServiceAdapterModule<Instance, MachineType, Image, Location>(){});
        this.bind(new TypeLiteral<Function<Location, Location>>(){}).toInstance(Functions.identity());
        this.bind(ImplicitLocationSupplier.class).to(FirstZone.class);
        this.bind(new TypeLiteral<Function<Instance, NodeMetadata>>(){}).to(InstanceToNodeMetadata.class);
        this.bind(new TypeLiteral<Function<MachineType, Hardware>>(){}).to(MachineTypeToHardware.class);
        this.bind(new TypeLiteral<Function<Image, org.jclouds.compute.domain.Image>>(){}).to(GoogleComputeEngineImageToImage.class);
        this.bind(CreateNodesWithGroupEncodedIntoNameThenAddToSet.class).to(org.jclouds.googlecomputeengine.compute.strategy.CreateNodesWithGroupEncodedIntoNameThenAddToSet.class);
        this.bind(TemplateOptions.class).to(GoogleComputeEngineTemplateOptions.class);
        this.bind(new TypeLiteral<Function<Set<? extends NodeMetadata>, Set<String>>>(){}).to(OrphanedGroupsFromDeadNodes.class);
        this.bind(new TypeLiteral<Predicate<String>>(){}).to(GroupIsEmpty.class);
        this.bind(new TypeLiteral<Function<String, OperatingSystem>>(){}).to(ImageNameToOperatingSystem.class);
        this.bind(new TypeLiteral<Function<NetworkAndAddressRange, Network>>(){}).to(CreateNetworkIfNeeded.class);
        this.bind(new TypeLiteral<CacheLoader<NetworkAndAddressRange, Network>>(){}).to(FindNetworkOrCreate.class);
        this.bind(FirewallTagNamingConvention.Factory.class).in(Scopes.SINGLETON);
        BinderUtils.bindHttpApi(this.binder(), Resources.class);
    }

    @Provides
    Predicate<AtomicReference<Operation>> operationDone(AtomicOperationDone input, @Named(value="jclouds.google-compute-engine.operation-complete-timeout") long timeout, @Named(value="jclouds.google-compute-engine.operation-complete-interval") long interval) {
        return Predicates2.retry(input, timeout, interval, TimeUnit.MILLISECONDS);
    }

    @Provides
    Predicate<AtomicReference<Instance>> instanceVisible(AtomicInstanceVisible input, @Named(value="jclouds.google-compute-engine.operation-complete-timeout") long timeout, @Named(value="jclouds.google-compute-engine.operation-complete-interval") long interval) {
        return Predicates2.retry(input, timeout, interval, TimeUnit.MILLISECONDS);
    }

    @Provides
    @Singleton
    Map<URI, URI> diskToSourceImage() {
        return Maps.newConcurrentMap();
    }

    @Provides
    @Singleton
    @Memoized
    Supplier<Map<URI, Hardware>> hardwareByUri(final @Memoized Supplier<Set<? extends Hardware>> hardwareSupplier, @Named(value="jclouds.session-interval") long seconds) {
        return Suppliers.memoizeWithExpiration(new Supplier<Map<URI, Hardware>>(){

            @Override
            public Map<URI, Hardware> get() {
                ImmutableMap.Builder<URI, Hardware> result = ImmutableMap.builder();
                for (Hardware hardware : (Set)hardwareSupplier.get()) {
                    result.put(hardware.getUri(), hardware);
                }
                return result.build();
            }
        }, seconds, TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    @Memoized
    Supplier<Map<URI, Location>> locationsByUri(final @Memoized Supplier<Set<? extends Location>> locations, @Named(value="jclouds.session-interval") long seconds) {
        return Suppliers.memoizeWithExpiration(new Supplier<Map<URI, Location>>(){

            @Override
            public Map<URI, Location> get() {
                ImmutableMap.Builder<URI, Location> result = ImmutableMap.builder();
                for (Location location : (Set)locations.get()) {
                    result.put(URI.create(location.getDescription()), location);
                }
                return result.build();
            }
        }, seconds, TimeUnit.SECONDS);
    }

    @Override
    protected Map<OsFamily, LoginCredentials> osFamilyToCredentials(Injector injector) {
        ImmutableMap.Builder<OsFamily, LoginCredentials> builder = ImmutableMap.builder();
        block4: for (OsFamily family : OsFamily.values()) {
            switch (family) {
                case COREOS: {
                    builder.put(family, LoginCredentials.builder().user("core").build());
                    continue block4;
                }
                case WINDOWS: {
                    builder.put(family, LoginCredentials.builder().user("Administrator").build());
                    continue block4;
                }
                default: {
                    builder.put(family, LoginCredentials.builder().user("jclouds").build());
                }
            }
        }
        return builder.build();
    }

    @Provides
    @Singleton
    LoadingCache<NetworkAndAddressRange, Network> networkMap(CacheLoader<NetworkAndAddressRange, Network> in) {
        return CacheBuilder.newBuilder().build(in);
    }

    @Override
    protected Optional<ImageExtension> provideImageExtension(Injector i) {
        return Optional.absent();
    }

    @Override
    protected Optional<SecurityGroupExtension> provideSecurityGroupExtension(Injector i) {
        return Optional.absent();
    }

    @Provides
    Map<Instance.Status, NodeMetadata.Status> toPortableNodeStatus() {
        return toPortableNodeStatus;
    }
}

