/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.options;

import com.google.common.base.Objects;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import org.jclouds.http.options.HttpRequestOptions;

public class BaseHttpRequestOptions
implements HttpRequestOptions {
    protected final Multimap<String, String> formParameters = LinkedHashMultimap.create();
    protected final Multimap<String, String> queryParameters = LinkedHashMultimap.create();
    protected final Multimap<String, String> headers = LinkedHashMultimap.create();
    protected String payload;
    protected String pathSuffix;

    @Override
    public String buildStringPayload() {
        return this.payload;
    }

    protected String getFirstQueryOrNull(String string) {
        Collection<String> values = this.queryParameters.get(string);
        return values != null && values.size() >= 1 ? values.iterator().next() : null;
    }

    protected String getFirstFormOrNull(String string) {
        Collection<String> values = this.formParameters.get(string);
        return values != null && values.size() >= 1 ? values.iterator().next() : null;
    }

    protected String getFirstHeaderOrNull(String string) {
        Collection<String> values = this.headers.get(string);
        return values != null && values.size() >= 1 ? values.iterator().next() : null;
    }

    protected void replaceHeader(String key, String value) {
        this.headers.removeAll(key);
        this.headers.put(key, value);
    }

    @Override
    public Multimap<String, String> buildRequestHeaders() {
        return this.headers;
    }

    @Override
    public Multimap<String, String> buildQueryParameters() {
        return this.queryParameters;
    }

    @Override
    public String buildPathSuffix() {
        return this.pathSuffix;
    }

    @Override
    public Multimap<String, String> buildFormParameters() {
        return this.formParameters;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.formParameters == null ? 0 : this.formParameters.hashCode());
        result = 31 * result + (this.headers == null ? 0 : this.headers.hashCode());
        result = 31 * result + (this.pathSuffix == null ? 0 : this.pathSuffix.hashCode());
        result = 31 * result + (this.payload == null ? 0 : this.payload.hashCode());
        result = 31 * result + (this.queryParameters == null ? 0 : this.queryParameters.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseHttpRequestOptions other = (BaseHttpRequestOptions)obj;
        if (this.formParameters == null ? other.formParameters != null : !this.formParameters.equals(other.formParameters)) {
            return false;
        }
        if (this.headers == null ? other.headers != null : !this.headers.equals(other.headers)) {
            return false;
        }
        if (this.pathSuffix == null ? other.pathSuffix != null : !this.pathSuffix.equals(other.pathSuffix)) {
            return false;
        }
        if (this.payload == null ? other.payload != null : !this.payload.equals(other.payload)) {
            return false;
        }
        return !(this.queryParameters == null ? other.queryParameters != null : !this.queryParameters.equals(other.queryParameters));
    }

    public String toString() {
        return Objects.toStringHelper(this).omitNullValues().add("formParameters", this.formParameters).add("headers", this.headers).add("pathSuffix", this.pathSuffix).add("payload", this.payload).add("queryParameters", this.queryParameters).toString();
    }
}

