/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.domain.chef;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;

public class RunList {
    private List<String> runlist;

    public static Builder builder() {
        return new Builder();
    }

    protected RunList(List<String> runlist) {
        this.runlist = ImmutableList.copyOf((Collection)Preconditions.checkNotNull(runlist, "runlist must be set"));
    }

    public List<String> getRunlist() {
        return this.runlist;
    }

    public String toString() {
        return "[" + Joiner.on(',').join(Iterables.transform(this.runlist, new Function<String, String>(){

            @Override
            public String apply(String input) {
                return "\"" + input + "\"";
            }
        })) + "]";
    }

    public static class Builder {
        private ImmutableList.Builder<String> runlist = ImmutableList.builder();

        public Builder recipe(String recipe) {
            this.runlist.add((Object)("recipe[" + Preconditions.checkNotNull(recipe, "recipe must be set") + "]"));
            return this;
        }

        public Builder recipes(Iterable<String> recipes) {
            this.runlist.addAll(Lists.newArrayList(Iterables.transform(Preconditions.checkNotNull(recipes, "recipes must be set"), new Function<String, String>(){

                @Override
                public String apply(String input) {
                    return "recipe[" + input + "]";
                }
            })));
            return this;
        }

        public Builder role(String role) {
            this.runlist.add((Object)("role[" + Preconditions.checkNotNull(role, "role must be set") + "]"));
            return this;
        }

        public Builder roles(Iterable<String> roles) {
            this.runlist.addAll(Lists.newArrayList(Iterables.transform(Preconditions.checkNotNull(roles, "roles must be set"), new Function<String, String>(){

                @Override
                public String apply(String input) {
                    return "role[" + input + "]";
                }
            })));
            return this;
        }

        public RunList build() {
            return new RunList((List<String>)((Object)this.runlist.build()));
        }
    }
}

