/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.Constant;
import io.netty.util.internal.ObjectUtil;
import java.util.HashMap;
import java.util.Map;

public abstract class ConstantPool<T extends Constant<T>> {
    private final Map<String, T> constants = new HashMap<String, T>();
    private int nextId = 1;

    public T valueOf(Class<?> firstNameComponent, String secondNameComponent) {
        if (firstNameComponent == null) {
            throw new NullPointerException("firstNameComponent");
        }
        if (secondNameComponent == null) {
            throw new NullPointerException("secondNameComponent");
        }
        return this.valueOf(firstNameComponent.getName() + '#' + secondNameComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T valueOf(String name) {
        Object c;
        Map<String, T> map = this.constants;
        synchronized (map) {
            c = this.exists(name) ? (Constant)this.constants.get(name) : this.newInstance0(name);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String name) {
        this.checkNotNullAndNotEmpty(name);
        Map<String, T> map = this.constants;
        synchronized (map) {
            return this.constants.containsKey(name);
        }
    }

    public T newInstance(String name) {
        if (this.exists(name)) {
            throw new IllegalArgumentException(String.format("'%s' is already in use", name));
        }
        T c = this.newInstance0(name);
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T newInstance0(String name) {
        Map<String, T> map = this.constants;
        synchronized (map) {
            T c = this.newConstant(this.nextId, name);
            this.constants.put(name, c);
            ++this.nextId;
            return c;
        }
    }

    private String checkNotNullAndNotEmpty(String name) {
        ObjectUtil.checkNotNull(name, "name");
        if (name.isEmpty()) {
            throw new IllegalArgumentException("empty name");
        }
        return name;
    }

    protected abstract T newConstant(int var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final int nextId() {
        Map<String, T> map = this.constants;
        synchronized (map) {
            int id = this.nextId++;
            return id;
        }
    }
}

