/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.keyprovider;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.schmizz.sshj.common.Base64;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.userauth.keyprovider.FileKeyProvider;
import net.schmizz.sshj.userauth.password.PasswordFinder;
import net.schmizz.sshj.userauth.password.PasswordUtils;
import net.schmizz.sshj.userauth.password.PrivateKeyFileResource;
import net.schmizz.sshj.userauth.password.PrivateKeyReaderResource;
import net.schmizz.sshj.userauth.password.PrivateKeyStringResource;
import net.schmizz.sshj.userauth.password.Resource;
import org.bouncycastle.util.encoders.Hex;

public class PuTTYKeyFile
implements FileKeyProvider {
    private byte[] privateKey;
    private byte[] publicKey;
    private KeyPair kp;
    protected PasswordFinder pwdf;
    protected Resource<?> resource;
    private Map<String, String> payload = new HashMap<String, String>();
    private final Map<String, String> headers = new HashMap<String, String>();

    @Override
    public void init(Reader location) {
        this.resource = new PrivateKeyReaderResource(location);
    }

    @Override
    public void init(Reader location, PasswordFinder pwdf) {
        this.init(location);
        this.pwdf = pwdf;
    }

    @Override
    public void init(File location) {
        this.resource = new PrivateKeyFileResource(location.getAbsoluteFile());
    }

    @Override
    public void init(File location, PasswordFinder pwdf) {
        this.init(location);
        this.pwdf = pwdf;
    }

    @Override
    public void init(String privateKey, String publicKey) {
        this.resource = new PrivateKeyStringResource(privateKey);
    }

    @Override
    public void init(String privateKey, String publicKey, PasswordFinder pwdf) {
        this.init(privateKey, publicKey);
        this.pwdf = pwdf;
    }

    @Override
    public PrivateKey getPrivate() throws IOException {
        PrivateKey privateKey;
        if (this.kp != null) {
            privateKey = this.kp.getPrivate();
        } else {
            this.kp = this.readKeyPair();
            privateKey = this.kp.getPrivate();
        }
        return privateKey;
    }

    @Override
    public PublicKey getPublic() throws IOException {
        PublicKey publicKey;
        if (this.kp != null) {
            publicKey = this.kp.getPublic();
        } else {
            this.kp = this.readKeyPair();
            publicKey = this.kp.getPublic();
        }
        return publicKey;
    }

    @Override
    public KeyType getType() throws IOException {
        return KeyType.fromString(this.headers.get("PuTTY-User-Key-File-2"));
    }

    public boolean isEncrypted() {
        return "aes256-cbc".equals(this.headers.get("Encryption"));
    }

    protected KeyPair readKeyPair() throws IOException {
        this.parseKeyPair();
        if (KeyType.RSA.equals((Object)this.getType())) {
            KeyFactory factory;
            KeyReader publicKeyReader = new KeyReader(this.publicKey);
            publicKeyReader.skip();
            BigInteger e = publicKeyReader.readInt();
            BigInteger n = publicKeyReader.readInt();
            KeyReader privateKeyReader = new KeyReader(this.privateKey);
            BigInteger d = privateKeyReader.readInt();
            try {
                factory = KeyFactory.getInstance("RSA");
            }
            catch (NoSuchAlgorithmException s) {
                throw new IOException(s.getMessage(), s);
            }
            try {
                return new KeyPair(factory.generatePublic(new RSAPublicKeySpec(n, e)), factory.generatePrivate(new RSAPrivateKeySpec(n, d)));
            }
            catch (InvalidKeySpecException i) {
                throw new IOException(i.getMessage(), i);
            }
        }
        if (KeyType.DSA.equals((Object)this.getType())) {
            KeyFactory factory;
            KeyReader publicKeyReader = new KeyReader(this.publicKey);
            publicKeyReader.skip();
            BigInteger p = publicKeyReader.readInt();
            BigInteger q = publicKeyReader.readInt();
            BigInteger g = publicKeyReader.readInt();
            BigInteger y = publicKeyReader.readInt();
            KeyReader privateKeyReader = new KeyReader(this.privateKey);
            BigInteger x = privateKeyReader.readInt();
            try {
                factory = KeyFactory.getInstance("DSA");
            }
            catch (NoSuchAlgorithmException s) {
                throw new IOException(s.getMessage(), s);
            }
            try {
                return new KeyPair(factory.generatePublic(new DSAPublicKeySpec(y, p, q, g)), factory.generatePrivate(new DSAPrivateKeySpec(x, p, q, g)));
            }
            catch (InvalidKeySpecException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        throw new IOException(String.format("Unknown key type %s", new Object[]{this.getType()}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseKeyPair() throws IOException {
        BufferedReader r = new BufferedReader(this.resource.getReader());
        try {
            String line;
            String headerName = null;
            while ((line = r.readLine()) != null) {
                int idx = line.indexOf(": ");
                if (idx > 0) {
                    headerName = line.substring(0, idx);
                    this.headers.put(headerName, line.substring(idx + 2));
                    continue;
                }
                String s = this.payload.get(headerName);
                s = s == null ? line : s + line;
                this.payload.put(headerName, s);
            }
        }
        finally {
            r.close();
        }
        this.publicKey = Base64.decode(this.payload.get("Public-Lines"));
        if (this.isEncrypted()) {
            char[] passphrase = this.pwdf != null ? this.pwdf.reqPassword(this.resource) : "".toCharArray();
            try {
                this.privateKey = this.decrypt(Base64.decode(this.payload.get("Private-Lines")), new String(passphrase));
                this.verify(new String(passphrase));
            }
            finally {
                PasswordUtils.blankOut(passphrase);
            }
        } else {
            this.privateKey = Base64.decode(this.payload.get("Private-Lines"));
        }
    }

    private byte[] toKey(String passphrase) throws IOException {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(new byte[]{0, 0, 0, 0});
            digest.update(passphrase.getBytes());
            byte[] key1 = digest.digest();
            digest.update(new byte[]{0, 0, 0, 1});
            digest.update(passphrase.getBytes());
            byte[] key2 = digest.digest();
            byte[] r = new byte[32];
            System.arraycopy(key1, 0, r, 0, 20);
            System.arraycopy(key2, 0, r, 20, 12);
            return r;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private void verify(String passphrase) throws IOException {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update("putty-private-key-file-mac-key".getBytes());
            if (passphrase != null) {
                digest.update(passphrase.getBytes());
            }
            byte[] key = digest.digest();
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(new SecretKeySpec(key, 0, 20, mac.getAlgorithm()));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(out);
            data.writeInt(this.getType().toString().length());
            data.writeBytes(this.getType().toString());
            data.writeInt(this.headers.get("Encryption").length());
            data.writeBytes(this.headers.get("Encryption"));
            data.writeInt(this.headers.get("Comment").length());
            data.writeBytes(this.headers.get("Comment"));
            data.writeInt(this.publicKey.length);
            data.write(this.publicKey);
            data.writeInt(this.privateKey.length);
            data.write(this.privateKey);
            String encoded = Hex.toHexString(mac.doFinal(out.toByteArray()));
            String reference = this.headers.get("Private-MAC");
            if (!encoded.equals(reference)) {
                throw new IOException("Invalid passphrase");
            }
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private byte[] decrypt(byte[] key, String passphrase) throws IOException {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            byte[] expanded = this.toKey(passphrase);
            cipher.init(2, (Key)new SecretKeySpec(expanded, 0, 32, "AES"), new IvParameterSpec(new byte[16]));
            return cipher.doFinal(key);
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private static final class KeyReader {
        private final DataInput di;

        public KeyReader(byte[] key) {
            this.di = new DataInputStream(new ByteArrayInputStream(key));
        }

        public void skip() throws IOException {
            int read = this.di.readInt();
            if (read != this.di.skipBytes(read)) {
                throw new IOException(String.format("Failed to skip %d bytes", read));
            }
        }

        private byte[] read() throws IOException {
            int len = this.di.readInt();
            if (len <= 0 || len > 513) {
                throw new IOException(String.format("Invalid length %d", len));
            }
            byte[] r = new byte[len];
            this.di.readFully(r);
            return r;
        }

        public BigInteger readInt() throws IOException {
            return new BigInteger(this.read());
        }
    }

    public static class Factory
    implements Factory.Named<FileKeyProvider> {
        @Override
        public FileKeyProvider create() {
            return new PuTTYKeyFile();
        }

        @Override
        public String getName() {
            return "PuTTY";
        }
    }
}

