/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.functions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.domain.LocationScope;
import org.jclouds.openstack.nova.v2_0.compute.predicates.AllNodesInGroupTerminated;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionAndName;

public class OrphanedGroupsByRegionId
implements Function<Set<? extends NodeMetadata>, Multimap<String, String>> {
    private final Predicate<RegionAndName> allNodesInGroupTerminated;

    @Inject
    protected OrphanedGroupsByRegionId(ComputeService computeService) {
        this(new AllNodesInGroupTerminated(Preconditions.checkNotNull(computeService, "computeService")));
    }

    @VisibleForTesting
    OrphanedGroupsByRegionId(Predicate<RegionAndName> allNodesInGroupTerminated) {
        this.allNodesInGroupTerminated = Preconditions.checkNotNull(allNodesInGroupTerminated, "allNodesInGroupTerminated");
    }

    @Override
    public Multimap<String, String> apply(Set<? extends NodeMetadata> deadNodes) {
        Set<NodeMetadata> nodesWithGroup = Sets.filter(deadNodes, NodePredicates.hasGroup());
        ImmutableSet<RegionAndName> regionAndGroupNames = ImmutableSet.copyOf(Iterables.filter(Iterables.transform(nodesWithGroup, new Function<NodeMetadata, RegionAndName>(){

            @Override
            public RegionAndName apply(NodeMetadata input) {
                String regionId = input.getLocation().getScope() == LocationScope.HOST ? input.getLocation().getParent().getId() : input.getLocation().getId();
                return RegionAndName.fromRegionAndName(regionId, input.getGroup());
            }
        }), this.allNodesInGroupTerminated));
        ListMultimap<String, String> regionToRegionAndGroupNames = Multimaps.transformValues(Multimaps.index(regionAndGroupNames, RegionAndName.REGION_FUNCTION), RegionAndName.NAME_FUNCTION);
        return regionToRegionAndGroupNames;
    }
}

