/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloud.config;

import com.google.common.base.Preconditions;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Qualifier;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
@Qualifier
public @interface CurrentProject {

    public static final class ClientEmail {
        public static final String DESCRIPTION = "client_email which usually looks like project_id@developer.gserviceaccount.com or project_id-extended_uid@developer.gserviceaccount.com";
        private static final Pattern PROJECT_NUMBER_PATTERN = Pattern.compile("^([0-9]+)[@-].*");

        public static String toProjectNumber(String email) {
            Matcher matcher = PROJECT_NUMBER_PATTERN.matcher(email);
            Preconditions.checkArgument(matcher.find(), "Client email %s is malformed. Should be %s", email, DESCRIPTION);
            return matcher.group(1);
        }
    }
}

