/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.conn.dummy;

import es.bsc.conn.Connector;
import es.bsc.conn.exceptions.ConnException;
import es.bsc.conn.types.HardwareDescription;
import es.bsc.conn.types.SoftwareDescription;
import es.bsc.conn.types.StarterCommand;
import es.bsc.conn.types.VirtualResource;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Dummy
extends Connector {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Connectors.Conn.Dummy");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static final String BASE_IP_PREFIX = "127.0.0.";
    private static final int BASE_IP_SUFFIX = 100;
    private static final AtomicInteger NEXT_IP_SUFFIX = new AtomicInteger(100);
    private static final int BASE_PORT = 43100;
    private static final AtomicInteger NEXT_PORT = new AtomicInteger(43100);
    private static final int CREATION_TIME = 15000;
    private final Map<TestMachineId, HardwareDescription> idToHardwareRequest = Collections.synchronizedMap(new HashMap());
    private final Map<TestMachineId, SoftwareDescription> idToSoftwareRequest = Collections.synchronizedMap(new HashMap());

    public Dummy(Map<String, String> props) throws ConnException {
        super(props);
    }

    @Override
    public Object create(String requestName, HardwareDescription hd, SoftwareDescription sd, Map<String, String> prop, StarterCommand starterCMD) throws ConnException {
        LOGGER.info("Creating VirtualResource with name " + requestName);
        if (DEBUG) {
            LOGGER.debug("- Associated Hardware Description: " + hd);
            LOGGER.debug("- Associated Software Description: " + sd);
        }
        TestMachineId tid = new TestMachineId();
        this.idToHardwareRequest.put(tid, hd);
        this.idToSoftwareRequest.put(tid, sd);
        LOGGER.info("- VR with name " + requestName + " was assigned to ID = " + tid);
        return tid;
    }

    @Override
    public Object[] createMultiple(int replicas, String requestName, HardwareDescription hd, SoftwareDescription sd, Map<String, String> prop, StarterCommand starterCMD) throws ConnException {
        Object[] envIds = new TestMachineId[replicas];
        for (int i = 0; i < replicas; ++i) {
            envIds[i] = (TestMachineId)this.create(requestName, hd, sd, prop, starterCMD);
        }
        return envIds;
    }

    @Override
    public VirtualResource waitUntilCreation(Object id) throws ConnException {
        TestMachineId tid = (TestMachineId)id;
        LOGGER.info("Waiting for creation of " + tid);
        try {
            Thread.sleep(15000L);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        SoftwareDescription sd = this.idToSoftwareRequest.get(tid);
        int port = NEXT_PORT.getAndIncrement();
        sd.getInstallation().setMinPort(port);
        sd.getInstallation().setMaxPort(port + 1);
        String ip = BASE_IP_PREFIX + NEXT_IP_SUFFIX.getAndIncrement();
        HardwareDescription hd = this.idToHardwareRequest.get(tid);
        VirtualResource vr = new VirtualResource();
        vr.setId(tid);
        vr.setIp(ip);
        vr.setHd(hd);
        vr.setSd(sd);
        LOGGER.info("Created machine with ID = " + tid);
        if (DEBUG) {
            LOGGER.debug("- Associated IP = " + ip);
            LOGGER.debug("- Associated HD = " + hd);
            LOGGER.debug("- Associated SD = " + sd);
            LOGGER.debug("- Associated PORT = " + port);
        }
        return vr;
    }

    @Override
    public void destroy(Object id) {
        TestMachineId tid = (TestMachineId)id;
        LOGGER.info("Deleting VirtualResource " + tid);
        this.idToHardwareRequest.remove(tid);
        this.idToSoftwareRequest.remove(tid);
    }

    @Override
    public float getPriceSlot(VirtualResource virtualResource) {
        LOGGER.info("Getting price slot");
        return 0.0f;
    }

    @Override
    public void close() {
        LOGGER.info("Closing");
    }

    private static class TestMachineId {
        private static final AtomicInteger NEXT_ID = new AtomicInteger(0);
        private final int id = NEXT_ID.getAndIncrement();

        private TestMachineId() {
        }

        public String toString() {
            return "TestMachineId-" + this.id;
        }
    }
}

