/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.config;

import com.google.common.base.Function;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.AWSEC2Api;
import org.jclouds.aws.ec2.domain.AWSRunningInstance;
import org.jclouds.aws.ec2.domain.SpotInstanceRequest;
import org.jclouds.aws.ec2.functions.SpotInstanceRequestToAWSRunningInstance;
import org.jclouds.aws.ec2.options.AWSRunInstancesOptions;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.aws.filters.FormSignerV4;
import org.jclouds.date.DateService;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.config.BaseEC2HttpApiModule;
import org.jclouds.ec2.features.AMIApi;
import org.jclouds.ec2.features.InstanceApi;
import org.jclouds.ec2.features.SecurityGroupApi;
import org.jclouds.ec2.options.RunInstancesOptions;
import org.jclouds.rest.ConfiguresHttpApi;

@ConfiguresHttpApi
public class AWSEC2HttpApiModule
extends BaseEC2HttpApiModule<AWSEC2Api> {
    private final SimpleDateFormat iso8601 = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");

    public AWSEC2HttpApiModule() {
        super(AWSEC2Api.class);
        this.iso8601.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    @Singleton
    @Provides
    EC2Api provide(AWSEC2Api in) {
        return in;
    }

    @Singleton
    @Provides
    InstanceApi getInstanceApi(AWSEC2Api in) {
        return in.getInstanceApi().get();
    }

    @Singleton
    @Provides
    SecurityGroupApi getSecurityGroupApi(AWSEC2Api in) {
        return in.getSecurityGroupApi().get();
    }

    @Singleton
    @Provides
    AMIApi getAMIApi(AWSEC2Api in) {
        return in.getAMIApi().get();
    }

    @Override
    protected void configure() {
        this.bind(FormSigner.class).to(FormSignerV4.class);
        this.bind(RunInstancesOptions.class).to(AWSRunInstancesOptions.class);
        this.bind(new TypeLiteral<Function<SpotInstanceRequest, AWSRunningInstance>>(){}).to(SpotInstanceRequestToAWSRunningInstance.class);
        super.configure();
    }

    @Override
    protected String provideTimeStamp(DateService dateService) {
        return this.iso8601.format(new Date());
    }
}

